/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.wizarddisplay.items;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.engine.wizarddisplay.WizardDisplayModelItem;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Button;
import ch.dvbern.tax.common.engine.wizarddisplay.items.ColDef;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Label;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Row;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Section;
import ch.dvbern.tax.common.engine.wizarddisplay.items.WizardDisplayUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import ch.dvbern.tax.common.transfer.util.ColorConstants;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class Item
extends WizardDisplayModelItem {
    private int colspan;
    private int type;
    private String valueKey;
    private LogicModelItem valueModelItem;
    private String stateKey;
    private Boolean readonly;
    private String align;
    private String style;
    private String id;
    private Boolean negative;
    private AbstractConverter rendererAndValidator;
    private boolean cleanOnLoad;
    private String messageItemKey;
    private String fgColor;
    private String reRender;
    static /* synthetic */ Class class$ch$dvbern$tax$common$engine$wizarddisplay$items$Item;

    public Item(int type, String valueKey, int colspan, String stateKey, Boolean readonly, String align, String style, String id, Boolean negative, AbstractConverter rendererAndValidator, boolean cleanOnLoad, String messageItemKey, String fgColor, String reRender) {
        this.type = type;
        this.valueKey = valueKey;
        this.colspan = colspan;
        this.stateKey = stateKey;
        this.readonly = readonly;
        this.align = align;
        this.style = style;
        this.id = id;
        this.negative = negative;
        this.rendererAndValidator = rendererAndValidator;
        this.cleanOnLoad = cleanOnLoad;
        this.messageItemKey = messageItemKey;
        this.fgColor = fgColor;
        this.reRender = reRender;
        this.initializeParent();
    }

    public List getChildren() {
        return null;
    }

    public int getColspan() {
        return this.colspan;
    }

    public AbstractConverter getRendererAndValidator() {
        return this.rendererAndValidator;
    }

    public void additionalInitializeWizardDisplayModel(Map logicModelItems) throws InvalidModelException {
        if (this.valueKey == null || logicModelItems.get(this.valueKey) == null) {
            throw new InvalidModelException("invalid value-reference in item: " + this.valueKey);
        }
        this.valueModelItem = (LogicModelItem)logicModelItems.get(this.valueKey);
        if (this.stateKey != null && logicModelItems.get(this.stateKey) == null) {
            throw new InvalidModelException("invalid state-reference in item: " + this.stateKey);
        }
        if (this.messageItemKey != null && logicModelItems.get(this.messageItemKey) == null) {
            throw new InvalidModelException("invalid messageItem-reference in item: " + this.messageItemKey);
        }
        if (this.readonly == null) {
            this.readonly = this.valueModelItem.isReadonly();
        }
    }

    public Object getFormInfo(WizardDisplayModelItem.ProtectedMap dataModel, String key) {
        ModelItemDTO messageItemDTO;
        ModelItemDTO stateDTO;
        String dataModelKey = EngineUtil.mergeModelKey(this.valueKey, key);
        OptionItemsDTO optionItems = null;
        if (this.valueModelItem instanceof LogicModelItem.SelectItem) {
            optionItems = ((LogicModelItem.SelectItem)((Object)this.valueModelItem)).getOptionItems(dataModel, dataModelKey);
        }
        int index = 0;
        for (int i = 0; i < ((Row)this.getParent()).getCols().size(); ++i) {
            WizardDisplayModelItem element = (WizardDisplayModelItem)((Row)this.getParent()).getCols().get(i);
            if (element == this) {
                index += i;
                break;
            }
            if (element instanceof Label && ((Label)element).getColspan() > 1) {
                index += ((Label)element).getColspan() - 1;
                continue;
            }
            if (element instanceof Button && ((Button)element).getColspan() > 1) {
                index += ((Button)element).getColspan() - 1;
                continue;
            }
            if (!(element instanceof Item) || ((Item)element).getColspan() <= 1) continue;
            index += ((Item)element).getColspan() - 1;
        }
        ModelItemDTO modelItemDTO = dataModel.getModelItem(dataModelKey);
        Object value = this.cleanOnLoad || modelItemDTO == null ? null : modelItemDTO.getValue();
        Collection messages = modelItemDTO != null ? modelItemDTO.getMessages() : null;
        int state = modelItemDTO.getState();
        if (this.stateKey != null && (stateDTO = dataModel.get(EngineUtil.mergeModelKey(this.stateKey, key))) != null) {
            switch (stateDTO.getState()) {
                case 12: {
                    state = 11;
                    break;
                }
                case 11: {
                    state = 11;
                    break;
                }
            }
        }
        if (this.messageItemKey != null && (messageItemDTO = dataModel.get(EngineUtil.mergeModelKey(this.messageItemKey, key))) != null) {
            if (messageItemDTO.getMessages() != null) {
                if (messages == null) {
                    messages = messageItemDTO.getMessages();
                } else {
                    messages.addAll(messageItemDTO.getMessages());
                }
            }
            if (ModelItemDTO.isMoreImportantState(messageItemDTO.getState(), state)) {
                state = messageItemDTO.getState();
            }
        }
        int corrColspan = this.colspan;
        int colDefState = 11;
        block9: for (int i = 0; i < this.colspan; ++i) {
            ColDef coldef = (ColDef)((Section)this.getParent().getParent()).getColdefs().get(index + i);
            WizardDisplayInfoDTO.ColDefItemDTO cdiDTO = (WizardDisplayInfoDTO.ColDefItemDTO)coldef.getFormInfo(dataModel, key);
            switch (cdiDTO.getState()) {
                case 12: {
                    --corrColspan;
                    continue block9;
                }
                case 11: {
                    continue block9;
                }
                default: {
                    colDefState = 1;
                }
            }
        }
        if (colDefState == 11) {
            state = colDefState;
        }
        if (corrColspan <= 0) {
            return null;
        }
        return new WizardDisplayInfoDTO.ItemItemDTO(new Long(this.getUniqueItemIdentifier()), state, this.type, dataModelKey, value, corrColspan, optionItems, messages, this.readonly, this.align, this.style, this.id, this.negative, this.rendererAndValidator, true, this.valueKey, this.fgColor, this.reRender);
    }

    protected void print() {
        System.out.println("Item - type=" + this.type + " value=" + this.valueKey);
    }

    public static class XMLFactory
    implements ElementParser {
        public ClassObjectPair parse(Element element, ParserFactory factory) throws ElementParserException {
            List elements = element.getChildren();
            AbstractConverter rendererAndValidator = null;
            if (elements.size() > 1) {
                throw new ElementParserException("invalid child element in: " + element);
            }
            if (elements.size() == 1) {
                Element subElement = (Element)elements.get(0);
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (!(ref instanceof AbstractConverter)) {
                        throw new ElementParserException("invalid child element type: " + ref);
                    }
                    rendererAndValidator = (AbstractConverter)ref;
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), pnre);
                }
            }
            WizardDisplayUtil.TypeAndConverter typeAndConverter = WizardDisplayUtil.parseInputType(element, rendererAndValidator);
            Boolean readonly = null;
            if (element.getAttribute("readonly") != null) {
                readonly = Boolean.valueOf(element.getAttributeValue("readonly"));
            }
            Boolean negative = Boolean.valueOf(element.getAttributeValue("negative"));
            String fgColor = element.getAttributeValue("fgColor");
            if (fgColor != null && ColorConstants.getColors().get(fgColor) == null) {
                throw new ElementParserException("invalid color definition in element " + element.getName());
            }
            String reRender = "self";
            if (element.getAttribute("reRender") != null) {
                reRender = element.getAttributeValue("reRender");
            }
            if (element.getAttributeValue("javaScript") != null) {
                throw new ElementParserException("invalid argument 'javaScript' in item " + element.getAttributeValue("value"));
            }
            if (element.getAttributeValue("scriptFile") != null) {
                throw new ElementParserException("invalid argument 'scriptFile' in item " + element.getAttributeValue("value"));
            }
            return new ClassObjectPair(class$ch$dvbern$tax$common$engine$wizarddisplay$items$Item == null ? (class$ch$dvbern$tax$common$engine$wizarddisplay$items$Item = Item.class$("ch.dvbern.tax.common.engine.wizarddisplay.items.Item")) : class$ch$dvbern$tax$common$engine$wizarddisplay$items$Item, new Item(typeAndConverter.type, element.getAttributeValue("value"), element.getAttribute("colspan") != null ? Integer.parseInt(element.getAttributeValue("colspan")) : 1, element.getAttributeValue("state"), readonly, typeAndConverter.alignment, element.getAttributeValue("style"), element.getAttributeValue("id"), negative, typeAndConverter.converter, Boolean.valueOf(element.getAttributeValue("clean-on-load")), element.getAttributeValue("messageItem"), fgColor, reRender));
        }
    }
}

