/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.wizarddisplay.items;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.engine.wizarddisplay.WizardDisplayModelItem;
import ch.dvbern.tax.common.engine.wizarddisplay.items.ColDef;
import ch.dvbern.tax.common.engine.wizarddisplay.items.LabelAddOn;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Section;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class Header
extends WizardDisplayModelItem {
    private String name;
    private int colspan;
    private List stateKeyList;
    private List headerAddOns;
    static /* synthetic */ Class class$ch$dvbern$tax$common$engine$wizarddisplay$items$Header;

    public Header(String name, int colspan, String stateKeys, List headerAddOns) {
        this.name = name;
        this.colspan = colspan;
        if (stateKeys != null && stateKeys.length() > 0) {
            this.stateKeyList = new ArrayList();
            StringTokenizer st = new StringTokenizer(stateKeys, ",");
            while (st.hasMoreTokens()) {
                this.stateKeyList.add(st.nextToken().trim());
            }
        }
        this.headerAddOns = headerAddOns;
        this.initializeParent();
    }

    public List getChildren() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public int getColspan() {
        return this.colspan;
    }

    public void additionalInitializeWizardDisplayModel(Map logicModelItems) throws InvalidModelException {
        if (this.stateKeyList != null) {
            Iterator i = this.stateKeyList.iterator();
            while (i.hasNext()) {
                Object key = i.next();
                if (logicModelItems.get(key) != null) continue;
                throw new InvalidModelException("invalid state-reference in label (key=" + key + ")");
            }
        }
        if (this.headerAddOns != null) {
            Iterator iter = this.headerAddOns.iterator();
            while (iter.hasNext()) {
                LabelAddOn element = (LabelAddOn)iter.next();
                element.additionalInitializeWizardDisplayModel(logicModelItems);
            }
        }
    }

    private int getState(WizardDisplayModelItem.ProtectedMap dataModel, String key) {
        int state = 1;
        if (this.stateKeyList != null) {
            Iterator i = this.stateKeyList.iterator();
            while (i.hasNext()) {
                ModelItemDTO miDTO = dataModel.get(EngineUtil.mergeModelKey(i.next().toString(), key));
                if (miDTO == null) continue;
                switch (miDTO.getState()) {
                    case 12: {
                        state = 12;
                        break;
                    }
                    case 11: {
                        state = 11;
                        break;
                    }
                }
            }
        }
        return state;
    }

    public Object getFormInfo(WizardDisplayModelItem.ProtectedMap dataModel, String key) {
        int state = this.getState(dataModel, key);
        ArrayList<Object> labelAddOnDTOs = new ArrayList<Object>();
        if (this.headerAddOns != null) {
            Iterator iter = this.headerAddOns.iterator();
            while (iter.hasNext()) {
                LabelAddOn element = (LabelAddOn)iter.next();
                Object formInfo = element.getFormInfo(dataModel, key);
                if (formInfo == null) continue;
                labelAddOnDTOs.add(formInfo);
            }
        }
        if (labelAddOnDTOs.size() == 0) {
            labelAddOnDTOs = null;
        }
        int corrColspan = this.colspan;
        if (state != 12) {
            Header element;
            int index = 0;
            for (int i = 0; i < ((Section)this.getParent()).getHeaders().size() && (element = (Header)((Section)this.getParent()).getHeaders().get(i)).getState(dataModel, key) != 12; ++i) {
                if (element == this) {
                    index += i;
                    break;
                }
                if (element.colspan <= 1) continue;
                index += element.colspan - 1;
            }
            int colDefState = 11;
            block6: for (int i = 0; i < this.colspan; ++i) {
                ColDef coldef = (ColDef)((Section)this.getParent()).getColdefs().get(index + i);
                WizardDisplayInfoDTO.ColDefItemDTO cdiDTO = (WizardDisplayInfoDTO.ColDefItemDTO)coldef.getFormInfo(dataModel, key);
                switch (cdiDTO.getState()) {
                    case 12: {
                        --corrColspan;
                        continue block6;
                    }
                    case 11: {
                        continue block6;
                    }
                    default: {
                        colDefState = 1;
                    }
                }
            }
            if (colDefState == 11) {
                state = colDefState;
            }
            if (corrColspan <= 0) {
                return null;
            }
        }
        if (state == 12) {
            return null;
        }
        return new WizardDisplayInfoDTO.HeaderItemDTO(this.getUniqueItemIdentifier(), state, this.name, corrColspan, labelAddOnDTOs);
    }

    public static class XMLFactory
    implements ElementParser {
        public ClassObjectPair parse(Element element, ParserFactory factory) throws ElementParserException {
            List elements = element.getChildren();
            ArrayList<Object> labelAddOns = new ArrayList<Object>();
            Iterator i = elements.iterator();
            while (i.hasNext()) {
                Element subElement = (Element)i.next();
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof LabelAddOn) {
                        labelAddOns.add(ref);
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + ref);
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), pnre);
                }
            }
            if (labelAddOns.size() == 0 && element.getAttribute("header-add-on") != null) {
                labelAddOns.add(new LabelAddOn(element.getAttributeValue("header-add-on")));
            }
            if (labelAddOns.size() == 0) {
                labelAddOns = null;
            }
            return new ClassObjectPair(class$ch$dvbern$tax$common$engine$wizarddisplay$items$Header == null ? (class$ch$dvbern$tax$common$engine$wizarddisplay$items$Header = Header.class$("ch.dvbern.tax.common.engine.wizarddisplay.items.Header")) : class$ch$dvbern$tax$common$engine$wizarddisplay$items$Header, new Header(element.getAttributeValue("name"), element.getAttribute("colspan") != null ? Integer.parseInt(element.getAttributeValue("colspan")) : 1, element.getAttributeValue("state"), labelAddOns));
        }
    }
}

