/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.wizarddisplay.items;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.modelitems.Calc;
import ch.dvbern.tax.common.engine.modelitems.TableSum;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.engine.wizarddisplay.WizardDisplayModelItem;
import ch.dvbern.tax.common.engine.wizarddisplay.items.ColDef;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Table;
import ch.dvbern.tax.common.engine.wizarddisplay.items.WizardDisplayUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Col
extends WizardDisplayModelItem {
    private int type;
    private String valueKey;
    private LogicModelItem valueModelItem;
    private Boolean readonly;
    private String align;
    private String style;
    private Boolean negative;
    private AbstractConverter rendererAndValidator;
    static /* synthetic */ Class class$ch$dvbern$tax$common$engine$wizarddisplay$items$Col;

    public Col(int type, String valueKey, Boolean readonly, String align, String style, Boolean negative, AbstractConverter rendererAndValidator) {
        this.type = type;
        this.valueKey = valueKey;
        this.readonly = readonly;
        this.align = align;
        this.style = style;
        this.negative = negative;
        this.rendererAndValidator = rendererAndValidator;
        this.initializeParent();
    }

    public List getChildren() {
        return null;
    }

    public String getAlign() {
        return this.align;
    }

    public String getDataModelKey() {
        return this.valueModelItem.getName();
    }

    public LogicModelItem getValueModelItem() {
        return this.valueModelItem;
    }

    public int getType() {
        return this.type;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public String getStyle() {
        return this.style;
    }

    public boolean isNegative() {
        return this.negative;
    }

    public long getUniqueItemIdentifier() {
        return super.getUniqueItemIdentifier();
    }

    public AbstractConverter getRendererAndValidator() {
        return this.rendererAndValidator;
    }

    public void additionalInitializeWizardDisplayModel(Map logicModelItems) throws InvalidModelException {
        if (this.valueKey != null) {
            if (logicModelItems.get(this.valueKey) == null) {
                throw new InvalidModelException("invalid value in col: " + this.valueKey);
            }
            this.valueModelItem = (LogicModelItem)logicModelItems.get(this.valueKey);
        }
        if (this.readonly == null) {
            this.readonly = this.valueModelItem instanceof Calc || this.valueModelItem instanceof TableSum ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    public Object getFormInfo(WizardDisplayModelItem.ProtectedMap dataModel, String key) {
        int stateParent = 1;
        String parentStateItem = ((Table)this.getParent()).getStateItem();
        if (parentStateItem != null) {
            stateParent = dataModel.getWithoutTouch(EngineUtil.mergeModelKey(parentStateItem, key)).getState();
        }
        int index = 0;
        for (int i = 0; i < ((Table)this.getParent()).getCols().size(); ++i) {
            Col element = (Col)((Table)this.getParent()).getCols().get(i);
            if (element != this) continue;
            index += i;
            break;
        }
        int stateColdef = 12;
        Object formInfo = ((ColDef)((Table)this.getParent()).getColdefs().get(index)).getFormInfo(dataModel, key);
        if (formInfo != null) {
            stateColdef = ((WizardDisplayInfoDTO.ColDefItemDTO)formInfo).getState();
        }
        int stateItemDTO = stateColdef;
        if (stateParent == 11 || stateParent == 12) {
            stateItemDTO = stateParent;
        }
        ArrayList<WizardDisplayInfoDTO.ItemItemDTO> itemsList = new ArrayList<WizardDisplayInfoDTO.ItemItemDTO>();
        Set itemsSet = (Set)dataModel.getWithoutTouch(EngineUtil.mergeModelKey(((Table)this.getParent()).getName(), key)).getValue();
        if (itemsSet == null) {
            return new WizardDisplayInfoDTO.ColItemDTO(this.getUniqueItemIdentifier(), stateItemDTO, null);
        }
        Iterator iter = itemsSet.iterator();
        while (iter.hasNext()) {
            Collection messages;
            String i = (String)iter.next();
            String tableDMK = EngineUtil.mergeModelKey(((Table)this.getParent()).getName(), key);
            String itemNameWithinTable = this.valueModelItem.getNameWithTableIndexShapes();
            itemNameWithinTable = itemNameWithinTable.substring(itemNameWithinTable.lastIndexOf(35) + 1);
            String dataModelKey = tableDMK + "." + i + itemNameWithinTable;
            ModelItemDTO miDTO = dataModel.getWithoutTouch(dataModelKey);
            Object o = miDTO != null ? miDTO.getValue() : "";
            Collection collection = messages = miDTO != null ? miDTO.getMessages() : null;
            if (((Table)this.getParent()).isEditable()) {
                stateItemDTO = miDTO.getState();
            }
            OptionItemsDTO optionItems = null;
            if (this.valueModelItem instanceof LogicModelItem.SelectItem) {
                optionItems = ((LogicModelItem.SelectItem)((Object)this.valueModelItem)).getOptionItems(dataModel, dataModelKey);
            }
            WizardDisplayInfoDTO.ItemItemDTO itemDTO = new WizardDisplayInfoDTO.ItemItemDTO(this.getUniqueItemIdentifier() + dataModelKey, stateItemDTO, this.type, dataModelKey, o, 1, optionItems, messages, this.readonly, this.align, this.style, null, this.negative, this.rendererAndValidator, true, this.valueKey, null, null);
            itemsList.add(itemDTO);
        }
        return new WizardDisplayInfoDTO.ColItemDTO(this.getUniqueItemIdentifier(), stateItemDTO, itemsList);
    }

    public String getValueKey() {
        return this.valueKey;
    }

    public static class XMLFactory
    implements ElementParser {
        public ClassObjectPair parse(Element element, ParserFactory factory) throws ElementParserException {
            List elements = element.getChildren();
            AbstractConverter rendererAndValidator = null;
            if (elements.size() > 1) {
                throw new ElementParserException("invalid child element in: " + element);
            }
            if (elements.size() == 1) {
                Element subElement = (Element)elements.get(0);
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (!(ref instanceof AbstractConverter)) {
                        throw new ElementParserException("invalid child element type: " + ref);
                    }
                    rendererAndValidator = (AbstractConverter)ref;
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), pnre);
                }
            }
            WizardDisplayUtil.TypeAndConverter typeAndConverter = WizardDisplayUtil.parseInputType(element, rendererAndValidator);
            Boolean readonly = null;
            if (element.getAttribute("readonly") != null) {
                readonly = Boolean.valueOf(element.getAttributeValue("readonly"));
            }
            if (element.getAttributeValue("javaScript") != null) {
                throw new ElementParserException("invalid argument 'javaScript' in item " + element.getAttributeValue("value"));
            }
            if (element.getAttributeValue("scriptFile") != null) {
                throw new ElementParserException("invalid argument 'scriptFile' in item " + element.getAttributeValue("value"));
            }
            Boolean negative = Boolean.valueOf(element.getAttributeValue("negative"));
            return new ClassObjectPair(class$ch$dvbern$tax$common$engine$wizarddisplay$items$Col == null ? (class$ch$dvbern$tax$common$engine$wizarddisplay$items$Col = Col.class$("ch.dvbern.tax.common.engine.wizarddisplay.items.Col")) : class$ch$dvbern$tax$common$engine$wizarddisplay$items$Col, new Col(typeAndConverter.type, element.getAttributeValue("value"), readonly, typeAndConverter.alignment, element.getAttributeValue("style"), negative, typeAndConverter.converter));
        }
    }
}

