/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.validators;

import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ZeitraumValidator
implements Validator {
    private static final Logger logger = Logger.getLogger((Class)ZeitraumValidator.class);
    private static final String DEFAULT_ERROR_MESSAGE = "error.zeitraum.ueberschneidung";
    private Reference refBis;
    private String errorMessage;

    public ZeitraumValidator(Reference refBis) {
        this.refBis = refBis;
        this.errorMessage = DEFAULT_ERROR_MESSAGE;
    }

    public ZeitraumValidator(Reference refBis, String optionalErrorMessage) {
        this.refBis = refBis;
        this.errorMessage = optionalErrorMessage;
    }

    public void initializeReferences(Map logicModel, LogicModelItem logicModelItem) throws InvalidModelException {
        this.refBis.registerListenerOnReference(logicModel, logicModelItem, false);
    }

    public ModelItemDTO validate(LogicModelItem.ProtectedMap dataModel, String dataModelKey, ModelItemDTO modelItemDTO) {
        ModelItemDTO result = modelItemDTO;
        if (result.getValue() == null) {
            return result;
        }
        String toLogicName = this.refBis.getReference().getName();
        String fromLogicName = EngineUtil.removeTableIndices(dataModelKey);
        String thisToDMK = EngineUtil.mergeModelKey(toLogicName, dataModelKey);
        if (dataModel.get(thisToDMK) == null) {
            return result;
        }
        Date thisToDate = (Date)dataModel.get(thisToDMK).getValue();
        Date thisFromDate = (Date)result.getValue();
        if (thisToDate == null || thisFromDate == null) {
            return result;
        }
        String tableDMK = dataModelKey;
        while (!EngineUtil.endsWithTableIndex(tableDMK)) {
            tableDMK = EngineUtil.removeLastKeyPart(tableDMK);
        }
        ModelItemDTO tableDTO = dataModel.get(tableDMK = EngineUtil.removeLastKeyPart(tableDMK));
        Set indices = (Set)tableDTO.getValue();
        if (indices != null && indices.size() > 0) {
            Iterator iterator = indices.iterator();
            while (iterator.hasNext()) {
                boolean after;
                String index = (String)iterator.next();
                String fromDMK = EngineUtil.mergeModelKey(fromLogicName, tableDMK + "." + index);
                String toDMK = EngineUtil.mergeModelKey(toLogicName, tableDMK + "." + index);
                if (toDMK.equals(thisToDMK) || dataModel.get(fromDMK) == null || dataModel.get(toDMK) == null) continue;
                Date fromDate = (Date)dataModel.get(fromDMK).getValue();
                Date toDate = (Date)dataModel.get(toDMK).getValue();
                if (fromDate == null || toDate == null) continue;
                boolean before = fromDate.before(thisFromDate) && toDate.before(thisFromDate);
                boolean bl = after = fromDate.after(thisToDate) && toDate.after(thisToDate);
                if (before || after) continue;
                logger.debug((Object)("ueberschneidung in item " + dataModelKey));
                result = result.clone(4, this.errorMessage, thisToDate, 4);
            }
        }
        return result;
    }
}

