/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.validators;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Mandatory
implements Validator {
    private List calcItems;
    private boolean warning;
    private String messageKey;
    private String defaultWarningKey = "warning.missing.data.default";
    private String defaultErrorKey = "error.missing.data.default";
    static /* synthetic */ Class class$ch$dvbern$tax$common$engine$validators$Mandatory;

    public Mandatory(boolean warning, String messageKey) {
        this.warning = warning;
        this.messageKey = messageKey;
        this.calcItems = new ArrayList();
    }

    public Mandatory(List calcItems, boolean warning, String messageKey) {
        this.calcItems = calcItems;
        this.warning = warning;
        this.messageKey = messageKey;
    }

    public void initializeReferences(Map logicModel, LogicModelItem logicModelItem) throws InvalidModelException {
        Iterator i = this.calcItems.iterator();
        while (i.hasNext()) {
            CalcItem ci = (CalcItem)i.next();
            if (!(ci instanceof Reference)) continue;
            ((Reference)((Object)ci)).registerListenerOnReference(logicModel, logicModelItem, false);
        }
    }

    public ModelItemDTO validate(LogicModelItem.ProtectedMap dataModel, String dataModelKey, ModelItemDTO modelItemDTO) {
        Object value;
        FastStack stack = new FastStack();
        Iterator i = this.calcItems.iterator();
        while (i.hasNext()) {
            ((CalcItem)i.next()).evaluate(dataModel, stack, dataModelKey);
        }
        Object object = value = stack.size() > 0 ? stack.pop() : null;
        if ((value != null && value instanceof Boolean && ((Boolean)value).booleanValue() || value == null) && modelItemDTO.getValue() == null) {
            if (modelItemDTO.isTouched()) {
                if (this.warning) {
                    String msg = this.messageKey == null ? this.defaultWarningKey : this.messageKey;
                    modelItemDTO = modelItemDTO.clone(2, msg, value, 2);
                } else {
                    String msg = this.messageKey == null ? this.defaultErrorKey : this.messageKey;
                    modelItemDTO = modelItemDTO.clone(4, msg, value, 4);
                }
            } else {
                modelItemDTO = modelItemDTO.clone(3);
            }
        }
        return modelItemDTO;
    }

    public static class XMLFactory
    implements ElementParser {
        public ClassObjectPair parse(Element element, ParserFactory factory) throws ElementParserException {
            ArrayList<Object> calcItems = new ArrayList<Object>();
            List elements = element.getChildren();
            Iterator i = elements.iterator();
            while (i.hasNext()) {
                Element subElement = (Element)i.next();
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof CalcItem) {
                        calcItems.add(ref);
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + ref);
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), pnre);
                }
            }
            String tmpMessageKey = element.getAttributeValue("message");
            boolean tmpWarning = false;
            if (element.getAttribute("warning") != null) {
                tmpWarning = Boolean.valueOf(element.getAttributeValue("warning"));
            }
            Mandatory result = calcItems.size() > 0 ? new Mandatory(calcItems, tmpWarning, tmpMessageKey) : new Mandatory(tmpWarning, tmpMessageKey);
            return new ClassObjectPair(class$ch$dvbern$tax$common$engine$validators$Mandatory == null ? (class$ch$dvbern$tax$common$engine$validators$Mandatory = Mandatory.class$("ch.dvbern.tax.common.engine.validators.Mandatory")) : class$ch$dvbern$tax$common$engine$validators$Mandatory, result);
        }
    }
}

