/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.validators;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.transfer.dto.MessageItemDTO;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Falsify
implements Validator {
    private List calcItems;
    private boolean booleanExpression;
    private String messageKey;
    private LogicModelItem lmi;
    static /* synthetic */ Class class$ch$dvbern$tax$common$engine$validators$Falsify;

    public Falsify(List calcItems, boolean booleanExpression, String messageKey) {
        this.calcItems = calcItems;
        this.booleanExpression = booleanExpression;
        this.messageKey = messageKey;
    }

    public void initializeReferences(Map logicModel, LogicModelItem logicModelItem) throws InvalidModelException {
        Iterator i = this.calcItems.iterator();
        while (i.hasNext()) {
            CalcItem ci = (CalcItem)i.next();
            if (!(ci instanceof Reference)) continue;
            ((Reference)((Object)ci)).registerListenerOnReference(logicModel, logicModelItem, false);
        }
        this.lmi = logicModelItem;
    }

    public ModelItemDTO validate(LogicModelItem.ProtectedMap dataModel, String dataModelKey, ModelItemDTO modelItemDTO) {
        if (dataModel.allowActiveValidations()) {
            Object value = null;
            if (this.calcItems != null && this.calcItems.size() > 0) {
                FastStack stack = new FastStack();
                Iterator i = this.calcItems.iterator();
                while (i.hasNext()) {
                    ((CalcItem)i.next()).evaluate(dataModel, stack, dataModelKey);
                }
                value = stack.size() > 0 ? stack.pop() : null;
            } else {
                value = modelItemDTO.getValue();
            }
            if (value instanceof Boolean && (Boolean)value == this.booleanExpression && (this.lmi.deleteSubValues(dataModel, dataModelKey, false, null) || modelItemDTO.getValue() != null)) {
                if (this.messageKey != null && this.messageKey.length() > 0) {
                    dataModel.addDeleteWarning(new MessageItemDTO(this.messageKey, null, 2));
                }
                modelItemDTO = modelItemDTO.clone(Boolean.FALSE);
            }
        }
        return modelItemDTO;
    }

    public static class XMLFactory
    implements ElementParser {
        private boolean booleanExpression;

        public XMLFactory(boolean booleanExpression) {
            this.booleanExpression = booleanExpression;
        }

        public ClassObjectPair parse(Element element, ParserFactory factory) throws ElementParserException {
            Boolean b;
            ArrayList<Object> calcItems = new ArrayList<Object>();
            List elements = element.getChildren();
            Iterator i = elements.iterator();
            while (i.hasNext()) {
                Element subElement = (Element)i.next();
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof CalcItem) {
                        calcItems.add(ref);
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + ref);
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), pnre);
                }
            }
            if (element.getAttributeValue("ref") != null) {
                throw new ElementParserException("ref attribute is deprecated in delete validators (" + element.getAttributeValue("ref") + ")");
            }
            String message = element.getAttributeValue("message");
            if (message != null && message.length() == 0) {
                message = null;
            }
            if (message == null && !(b = Boolean.valueOf(element.getAttributeValue("no-message"))).booleanValue()) {
                StringBuffer sb = new StringBuffer(element.getParent().getName());
                sb.append(" (");
                sb.append(element.getParent().getAttribute("name"));
                sb.append(")");
                sb.append(" - Falsify Validator: ");
                throw new ElementParserException(sb.toString() + "no-message attribute must be true, if no message is defined");
            }
            Falsify result = new Falsify(calcItems, this.booleanExpression, message);
            return new ClassObjectPair(class$ch$dvbern$tax$common$engine$validators$Falsify == null ? (class$ch$dvbern$tax$common$engine$validators$Falsify = Falsify.class$("ch.dvbern.tax.common.engine.validators.Falsify")) : class$ch$dvbern$tax$common$engine$validators$Falsify, result);
        }
    }
}

