/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.validators;

import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.transfer.dto.MessageItemDTO;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DeleteTableEntry
implements Validator {
    private CalcItem[] calcItems;
    private String messageKey;
    private LogicModelItem lmi;

    public DeleteTableEntry(CalcItem[] calcItems, String messageKey) {
        this.calcItems = calcItems;
        this.messageKey = messageKey;
    }

    public void initializeReferences(Map logicModel, LogicModelItem logicModelItem) throws InvalidModelException {
        for (int i = 0; i < this.calcItems.length; ++i) {
            CalcItem ci = this.calcItems[i];
            if (!(ci instanceof Reference)) continue;
            ((Reference)((Object)ci)).registerListenerOnReference(logicModel, logicModelItem, false);
        }
        this.lmi = logicModelItem;
    }

    public ModelItemDTO validate(LogicModelItem.ProtectedMap dataModel, String dataModelKey, ModelItemDTO modelItemDTO) {
        ModelItemDTO result = modelItemDTO;
        if (dataModel.allowActiveValidations() && modelItemDTO.getValue() instanceof Set) {
            HashSet workSet = new HashSet((Set)modelItemDTO.getValue());
            Iterator i = workSet.iterator();
            while (i.hasNext()) {
                String tableEntryDMK = dataModelKey + "." + i.next().toString();
                Object value = null;
                if (this.calcItems != null && this.calcItems.length > 0) {
                    FastStack stack = new FastStack();
                    for (int j = 0; j < this.calcItems.length; ++j) {
                        this.calcItems[j].evaluate(dataModel, stack, tableEntryDMK);
                    }
                    Object object = value = stack.size() > 0 ? stack.pop() : null;
                }
                if (!(value instanceof Boolean) || !((Boolean)value).booleanValue()) continue;
                this.lmi.deleteValue(dataModel, tableEntryDMK);
                i.remove();
                if (!modelItemDTO.isTouched() || this.messageKey == null || this.messageKey.length() <= 0) continue;
                dataModel.addDeleteWarning(new MessageItemDTO(this.messageKey, null, 2));
            }
            result = modelItemDTO.clone(workSet);
        }
        return result;
    }
}

