/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.modelitems.optionitems;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.modelitems.Select;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class TableOptionItem
implements Select.OptionItemFactory {
    private Reference ref;
    private String attribute;
    private Map optionMap;
    private String excludeKey;
    private LogicModelItem excludeRef;
    static /* synthetic */ Class class$ch$dvbern$tax$common$engine$modelitems$optionitems$TableOptionItem;

    public TableOptionItem(Reference ref, String attribute, String excludeKey) {
        this.ref = ref;
        this.attribute = attribute;
        this.excludeKey = excludeKey;
    }

    public OptionItemsDTO getOptionItems(LogicModelItem.ProtectedMap dataModel, String dataModelKey) {
        ModelItemDTO miDTO;
        String excludeIdx = null;
        if (this.excludeRef != null) {
            ModelItemDTO excludeDTO = dataModel.get(EngineUtil.mergeModelKey(this.excludeRef.getName(), dataModelKey));
            if (excludeDTO == null || excludeDTO.getValue() == null) {
                return null;
            }
            excludeIdx = excludeDTO.getValue().toString();
        }
        this.optionMap = new TreeMap();
        Object table = null;
        if (this.ref != null && (miDTO = dataModel.get(EngineUtil.mergeModelKey(this.ref.getName(), dataModelKey))) != null) {
            table = miDTO.getValue();
            String tableDmk = EngineUtil.mergeModelKey(this.ref.getName(), dataModelKey);
            Set indices = (Set)table;
            if (indices != null) {
                Iterator iter = indices.iterator();
                while (iter.hasNext()) {
                    ModelItemDTO itemMiDTO;
                    String index = (String)iter.next();
                    if (excludeIdx != null && index.equals(excludeIdx) || (itemMiDTO = dataModel.get(tableDmk + "." + index + "." + this.attribute)) == null) continue;
                    OptionItemDTO optionItemDTO = new OptionItemDTO(index, index, itemMiDTO.getValue() != null ? itemMiDTO.getValue().toString() : "", false);
                    this.optionMap.put(index, optionItemDTO);
                }
            }
        }
        return new OptionItemsDTO(false, this.optionMap);
    }

    public void additionalInitializeReferences(Map logicModel, LogicModelItem logicModelItem) throws InvalidModelException {
        if (this.ref != null) {
            this.ref.registerListenerOnReference(logicModel, logicModelItem, true);
        }
        if (logicModel.get(this.excludeKey) != null) {
            this.excludeRef = (LogicModelItem)logicModel.get(this.excludeKey);
        }
    }

    public boolean hasLocalizedOptions() {
        return false;
    }

    public static class XMLFactory
    implements ElementParser {
        public ClassObjectPair parse(Element element, ParserFactory factory) throws ElementParserException {
            Reference table_ref = null;
            if (element.getAttribute("rel-ref") != null) {
                table_ref = new Reference(element.getAttributeValue("rel-ref"), true);
            }
            if (element.getAttribute("abs-ref") != null) {
                table_ref = new Reference(element.getAttributeValue("abs-ref"), false);
            }
            TableOptionItem result = new TableOptionItem(table_ref, element.getAttributeValue("attribute"), element.getAttributeValue("exclude-ref"));
            return new ClassObjectPair(class$ch$dvbern$tax$common$engine$modelitems$optionitems$TableOptionItem == null ? (class$ch$dvbern$tax$common$engine$modelitems$optionitems$TableOptionItem = TableOptionItem.class$("ch.dvbern.tax.common.engine.modelitems.optionitems.TableOptionItem")) : class$ch$dvbern$tax$common$engine$modelitems$optionitems$TableOptionItem, result);
        }
    }
}

