/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.modelitems.addons;

import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.modelitems.Calc;
import ch.dvbern.tax.common.engine.modelitems.addons.RecursiveCalcGroup;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class RecursiveCalcGroupMember
extends Calc {
    private static final Logger log = Logger.getLogger((Class)RecursiveCalcGroupMember.class);
    private static final double MIN_DIFF_DEFAULT = 0.001;
    private double minDiff;
    public Set calcGroups = new HashSet();

    public RecursiveCalcGroupMember(String name, String pKey, CalcItem[] calcItems) {
        this(name, pKey, calcItems, 0.001);
    }

    public RecursiveCalcGroupMember(String name, String pKey, CalcItem[] calcItems, double minDiff) {
        super(name, pKey, Arrays.asList(calcItems), "false");
        this.minDiff = minDiff;
    }

    public void registerCalcGroup(RecursiveCalcGroup rc) {
        this.calcGroups.add(rc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(LogicModelItem.ProtectedMap dataModel, String dataModelKey, ModelItemDTO oldValue, ModelItemDTO newValue, String changedEventsOnlyOutsideOfThisTable) {
        String dmk = EngineUtil.mergeModelKey(this.getName(), dataModelKey);
        dataModel.getRunningLoops().add(dmk);
        try {
            super.setValueInternal(dataModel, dmk, new ModelItemDTO(null), changedEventsOnlyOutsideOfThisTable);
        }
        finally {
            dataModel.getRunningLoops().remove(dmk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean calculate(LogicModelItem.ProtectedMap dataModel, String dataModelKey, ModelItemDTO oldValue, ModelItemDTO newValue, String changedEventsOnlyOutsideOfThisTable) {
        String dmk = EngineUtil.mergeModelKey(this.getName(), dataModelKey);
        dataModel.getRunningLoops().add(dmk);
        try {
            Object value1 = null;
            ModelItemDTO mi = dataModel.get(dmk);
            if (mi != null) {
                value1 = mi.getValue();
            }
            super.dataChanged(dataModel, dataModelKey, oldValue, newValue, changedEventsOnlyOutsideOfThisTable);
            Object value2 = null;
            mi = dataModel.get(dmk);
            if (mi != null) {
                value2 = mi.getValue();
            }
            if (value1 != null && value2 != null && value1 instanceof Number && value2 instanceof Number) {
                double v1 = ((Number)value1).doubleValue();
                double v2 = ((Number)value2).doubleValue();
                double diff = Math.abs(v1 - v2);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("name=" + this.getName() + " value1=" + value1 + " value2=" + value2 + " diff=" + diff));
                }
                boolean bl = Math.abs(diff) < this.minDiff;
                return bl;
            }
            if (value1 != null) {
                boolean bl = value1.equals(value2);
                return bl;
            }
            if (value2 != null) {
                boolean bl = value2.equals(value1);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            dataModel.getRunningLoops().remove(dmk);
        }
    }

    public void dataChanged(LogicModelItem.ProtectedMap dataModel, String dataModelKey, ModelItemDTO oldValue, ModelItemDTO newValue, String changedEventsOnlyOutsideOfThisTable) {
        String dmk = EngineUtil.mergeModelKey(this.getName(), dataModelKey);
        if (dataModel.getRunningLoops().contains(dmk)) {
            return;
        }
        Iterator it = this.calcGroups.iterator();
        while (it.hasNext()) {
            RecursiveCalcGroup rc = (RecursiveCalcGroup)it.next();
            rc.dataChanged(dataModel, dataModelKey, oldValue, newValue, changedEventsOnlyOutsideOfThisTable);
        }
    }
}

