/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.modelitems.addons;

import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.modelitems.addons.RecursiveCalcGroupMember;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class RecursiveCalcGroup
extends LogicModelItem {
    private static final String START_CALC_VALUE = "doCalculate";
    private Logger log = Logger.getLogger((Class)RecursiveCalcGroup.class);
    private int loops;
    private Reference[] memberRefs;
    private List members;
    private String warning;
    private boolean autoCalc;

    public RecursiveCalcGroup(String name, String persistenceKeyTemplate, Reference[] members, int loops, boolean autoCalc, String warning) {
        super(name, null, persistenceKeyTemplate, true, "false", false);
        this.memberRefs = members;
        this.loops = loops;
        this.warning = warning;
        this.autoCalc = autoCalc;
    }

    public void setValue(LogicModelItem.ProtectedMap dataModel, String dataModelKey, ModelItemDTO modelItemDTO, String changedEventsOnlyOutsideOfThisTable) {
        String dmk = EngineUtil.mergeModelKey(this.getName(), dataModelKey);
        if (changedEventsOnlyOutsideOfThisTable != null && dmk.startsWith(changedEventsOnlyOutsideOfThisTable)) {
            return;
        }
        if (START_CALC_VALUE.equals(modelItemDTO.getValue())) {
            this.runLoops(dmk, dataModel, changedEventsOnlyOutsideOfThisTable);
        }
    }

    public void additionalInitializeReferences(Map logicModel) throws InvalidModelException {
        super.additionalInitializeReferences(logicModel);
        if (!this.autoCalc && this.warning == null) {
            throw new InvalidModelException("warning may not be null if autCalc is disabled in " + this.getName());
        }
        this.members = new ArrayList();
        if (this.memberRefs != null) {
            for (int i = 0; i < this.memberRefs.length; ++i) {
                Reference ref = this.memberRefs[i];
                ref.initializeReference(logicModel, this, false);
                LogicModelItem lmi = ref.getReference();
                if (lmi == null || !(lmi instanceof RecursiveCalcGroupMember)) {
                    throw new InvalidModelException("referenced member is not a RecurisveCalcGroupMember (" + ref.getName() + ") in " + this.getName());
                }
                RecursiveCalcGroupMember member = (RecursiveCalcGroupMember)lmi;
                member.registerCalcGroup(this);
                this.members.add(member);
            }
        }
    }

    public void dataChanged(LogicModelItem.ProtectedMap dataModel, String dataModelKey, ModelItemDTO oldValue, ModelItemDTO newValue, String changedEventsOnlyOutsideOfThisTable) {
        String dmk = EngineUtil.mergeModelKey(this.getName(), dataModelKey);
        if (changedEventsOnlyOutsideOfThisTable != null && dmk.startsWith(changedEventsOnlyOutsideOfThisTable)) {
            return;
        }
        if (dataModel.getRunningLoops().contains(dmk)) {
            return;
        }
        ModelItemDTO thisItem = dataModel.get(dmk);
        if (thisItem == null) {
            thisItem = new ModelItemDTO();
        }
        if (this.autoCalc || dataModel.isRecalculating()) {
            if (!dataModel.getAsyncUpdates().containsKey(dmk)) {
                dataModel.getAsyncUpdates().put(dmk, thisItem.clone(START_CALC_VALUE));
            }
            return;
        }
        thisItem = thisItem.clone(4, this.warning, null, 4);
        this.setValueWithOptionalValidation(dataModel, dmk, thisItem, changedEventsOnlyOutsideOfThisTable, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runLoops(String dmk, LogicModelItem.ProtectedMap dataModel, String changedEventsOnlyOutsideOfThisTable) {
        ModelItemDTO thisItem = dataModel.get(dmk);
        if (thisItem == null) {
            thisItem = new ModelItemDTO();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("starting recursive group calculation. name=" + this.getName()));
        }
        dataModel.getRunningLoops().add(dmk);
        try {
            Iterator it = this.members.iterator();
            while (it.hasNext()) {
                RecursiveCalcGroupMember sc = (RecursiveCalcGroupMember)it.next();
                sc.reset(dataModel, dmk, thisItem, thisItem, changedEventsOnlyOutsideOfThisTable);
            }
            for (int i = 0; i < this.loops; ++i) {
                boolean stable = true;
                Iterator it2 = this.members.iterator();
                while (it2.hasNext()) {
                    RecursiveCalcGroupMember sc = (RecursiveCalcGroupMember)it2.next();
                    if (sc.calculate(dataModel, dmk, thisItem, thisItem, changedEventsOnlyOutsideOfThisTable)) continue;
                    stable = false;
                }
                if (!stable) continue;
                if (!this.log.isDebugEnabled()) break;
                this.log.debug((Object)("breaking recursive group calculation because all members are stable. name=" + this.getName() + " iterationsUsed=" + i));
                break;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("recursive group calculation finished. name=" + this.getName()));
            }
            thisItem = new ModelItemDTO(null, 1);
            this.setValueWithOptionalValidation(dataModel, dmk, thisItem, changedEventsOnlyOutsideOfThisTable, false, false);
        }
        finally {
            dataModel.getRunningLoops().remove(dmk);
        }
    }
}

