/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.modelitems.addons;

import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.modelitems.Calc;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.Arrays;
import java.util.Set;
import org.apache.log4j.Logger;

public class RecursiveCalc
extends Calc {
    private static final double MIN_DIFF_DEFAULT = 0.001;
    private int loops;
    private String name;
    private Logger log = Logger.getLogger((Class)RecursiveCalc.class);
    private double minDiff;

    public RecursiveCalc(String name, String pKey, CalcItem[] calcItems, int loops) {
        this(name, pKey, calcItems, loops, 0.001);
    }

    public RecursiveCalc(String name, String pKey, CalcItem[] calcItems, int loops, double minDiff) {
        super(name, pKey, Arrays.asList(calcItems), "false");
        this.loops = loops;
        this.name = name;
        this.minDiff = minDiff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataChanged(LogicModelItem.ProtectedMap dataModel, String dataModelKey, ModelItemDTO oldValue, ModelItemDTO newValue, String changedEventsOnlyOutsideOfThisTable) {
        String dmk = EngineUtil.mergeModelKey(this.getName(), dataModelKey);
        Set runningLoops = dataModel.getRunningLoops();
        if (runningLoops.contains(dmk)) {
            return;
        }
        try {
            runningLoops.add(dmk);
            this.debug(0, runningLoops.size() - 1);
            newValue = new ModelItemDTO(null);
            super.setValueInternal(dataModel, dmk, newValue, changedEventsOnlyOutsideOfThisTable);
            for (int i = 0; i < this.loops; ++i) {
                this.debug(i + 1, runningLoops.size() - 1);
                Number value1 = null;
                ModelItemDTO mi = dataModel.get(dmk);
                if (mi != null && mi.getValue() instanceof Number) {
                    value1 = (Number)mi.getValue();
                }
                super.dataChanged(dataModel, dataModelKey, oldValue, newValue, changedEventsOnlyOutsideOfThisTable);
                if (value1 == null || (mi = dataModel.get(dmk)) == null || mi.getValue() == null || !(mi.getValue() instanceof Number)) continue;
                Number value2 = (Number)mi.getValue();
                double diff = value1.doubleValue() - value2.doubleValue();
                diff = Math.abs(diff);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("name=" + this.name + " value1=" + value1 + " value2=" + value2 + " diff=" + diff));
                }
                if (!(Math.abs(diff) < this.minDiff)) continue;
                break;
            }
        }
        finally {
            runningLoops.remove(dmk);
        }
    }

    private void debug(int i, int depth) {
        if (!this.log.isDebugEnabled()) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        for (int j = 0; j < depth; ++j) {
            sb.append(" ");
        }
        sb.append("Recursive Calculation:" + this.name + " iteration=" + i + " loops=" + this.loops);
        this.log.debug((Object)sb);
    }
}

