/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.modelitems.addons;

import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ItemEventOnMultipleTableEntriesHelper
extends LogicModelItem {
    private Reference tableWithTheItems;
    private Collection theItems;

    public ItemEventOnMultipleTableEntriesHelper(String name, Reference tableWithTheItems, Reference[] theItems) {
        super(name, null, null, true, "false", true);
        this.tableWithTheItems = tableWithTheItems;
        this.theItems = Arrays.asList(theItems);
    }

    protected void additionalInitializeReferences(Map logicModel) throws InvalidModelException {
        super.additionalInitializeReferences(logicModel);
        Iterator i = this.theItems.iterator();
        while (i.hasNext()) {
            ((Reference)i.next()).registerListenerOnReference(logicModel, this, false);
        }
    }

    public void dataChanged(LogicModelItem.ProtectedMap dataModel, String dataModelKey, ModelItemDTO oldValue, ModelItemDTO newValue, String changedEventsOnlyOutsideOfThisTable) {
        if (changedEventsOnlyOutsideOfThisTable != null && dataModelKey.startsWith(changedEventsOnlyOutsideOfThisTable)) {
            return;
        }
        String tableDMK = EngineUtil.mergeModelKey(this.tableWithTheItems.getName(), dataModelKey);
        tableDMK = EngineUtil.removeLastKeyPart(tableDMK);
        Set tableIndices = (Set)dataModel.get(tableDMK).getValue();
        Iterator i = tableIndices.iterator();
        while (i.hasNext()) {
            String index = i.next().toString();
            String otherItemDMK = this.replaceTableEntryIndex(dataModelKey, tableDMK, index);
            Iterator j = this.theItems.iterator();
            while (j.hasNext()) {
                Reference r = (Reference)j.next();
                r.getReference().dataChanged(dataModel, otherItemDMK, oldValue, newValue, changedEventsOnlyOutsideOfThisTable);
            }
        }
    }

    private String replaceTableEntryIndex(String dataModelKey, String tableDMK, String index) {
        String subDMK = dataModelKey.substring(tableDMK.length() + 1);
        subDMK = subDMK.substring(subDMK.indexOf(46));
        return tableDMK + "." + index + subDMK;
    }
}

