/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.expertdisplay;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModel;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayUtil;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertFormItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertLabelAddOn;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.failure.InvalidModelItemKeyException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class ExpertWizardLinkItem
extends ExpertDisplayModelItem
implements ExpertFormItem.FormElement {
    private String key;
    private int x;
    private int y;
    private int width;
    private int height;
    private int alignment;
    private ExpertDisplayInfoDTO.FontDTO font;
    private ExpertDisplayInfoDTO.ColorDTO bgColor;
    private List labelAddOns;
    private String wizardDmk;
    private LogicModelItem logicModelItem;
    private String stateDmks;
    private List stateModelItems;
    static /* synthetic */ Class class$ch$dvbern$tax$common$engine$expertdisplay$ExpertFormItem$FormElement;

    public ExpertWizardLinkItem(String key, int x, int y, int width, int height, int alignment, ExpertDisplayInfoDTO.FontDTO font, ExpertDisplayInfoDTO.ColorDTO bgColor, List labelAddOns, Set languages, String wizardDmk, String stateDmk) {
        super(languages, 0, true);
        this.key = key;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.alignment = alignment;
        this.font = font;
        this.bgColor = bgColor;
        this.labelAddOns = labelAddOns;
        this.wizardDmk = wizardDmk;
        this.stateDmks = stateDmk;
    }

    public List getChildren() {
        return this.labelAddOns;
    }

    protected void additionalInitialization(Map logicModelItems, Map navigationItems) throws InvalidModelException {
        super.additionalInitialization(logicModelItems, navigationItems);
        this.logicModelItem = (LogicModelItem)logicModelItems.get(this.wizardDmk);
        if (this.logicModelItem == null) {
            throw new InvalidModelException("invalid wizard DMK in wizard link: " + this.wizardDmk + " in " + this.getClass().getName());
        }
        if (this.stateDmks == null) {
            this.stateModelItems = Collections.singletonList(this.logicModelItem);
        } else {
            this.stateModelItems = new ArrayList();
            StringTokenizer st = new StringTokenizer(this.stateDmks, ",");
            while (st.hasMoreTokens()) {
                String dmk = st.nextToken();
                LogicModelItem lmi = (LogicModelItem)logicModelItems.get(dmk);
                if (lmi == null) {
                    throw new InvalidModelException("invalid state DMK in wizard link: " + dmk + " in " + this.getClass().getName());
                }
                this.stateModelItems.add(lmi);
            }
        }
    }

    public ExpertDisplayInfoDTO.ItemDTO getItemDTO(ExpertDisplayModel.RequestContext requestContext) throws InvalidModelItemKeyException {
        String stateDmk;
        ArrayList<ExpertDisplayInfoDTO.LabelDTO.LabelAddOnDTO> labelAddOnDTOs = null;
        if (this.labelAddOns != null && this.labelAddOns.size() > 0) {
            labelAddOnDTOs = new ArrayList<ExpertDisplayInfoDTO.LabelDTO.LabelAddOnDTO>();
            Iterator i = this.labelAddOns.iterator();
            while (i.hasNext()) {
                ExpertLabelAddOn labelAddOn = (ExpertLabelAddOn)i.next();
                ExpertDisplayInfoDTO.LabelDTO.LabelAddOnDTO labelAddOnDTO = labelAddOn.getLabelAddOnDTO(requestContext);
                labelAddOnDTOs.add(labelAddOnDTO);
            }
        }
        int state = -1;
        Iterator iter = this.stateModelItems.iterator();
        while (iter.hasNext()) {
            LogicModelItem lmi = (LogicModelItem)iter.next();
            stateDmk = ExpertDisplayUtil.getModelItemKey(lmi, requestContext.getFormAccessKey());
            ModelItemDTO miDTO = requestContext.getDataModel().getWithoutTouch(stateDmk);
            if (miDTO == null) continue;
            if (state == -1) {
                state = miDTO.getState();
                continue;
            }
            if (ModelItemDTO.isPropagatableState(state)) {
                if (!miDTO.hasMoreImportantState(state) || !miDTO.hasPropagatableState()) continue;
                state = miDTO.getState();
                continue;
            }
            if (miDTO.hasPropagatableState()) {
                state = miDTO.getState();
                continue;
            }
            if (miDTO.getState() != 11) continue;
            state = miDTO.getState();
        }
        if (state == -1) {
            state = 1;
        }
        if (state == 12) {
            return null;
        }
        iter = this.stateModelItems.iterator();
        while (iter.hasNext()) {
            LogicModelItem stateItem = (LogicModelItem)iter.next();
            stateDmk = ExpertDisplayUtil.getModelItemKey(stateItem, requestContext.getFormAccessKey());
            for (LogicModelItem lmi = stateItem; lmi != null; lmi = lmi.getParent()) {
                if (!lmi.isReadonlyIfTransparent()) continue;
                String s = EngineUtil.mergeModelKey(lmi.getName(), stateDmk);
                ModelItemDTO mi = requestContext.getDataModel().get(s);
                if (mi == null || mi.getState() != 11) continue;
                return null;
            }
        }
        String dmk = ExpertDisplayUtil.getModelItemKey(this.logicModelItem, requestContext.getFormAccessKey());
        return new ExpertDisplayInfoDTO.WizardLinkDTO(this.x, this.y, this.width, this.height, this.font != null ? this.font : requestContext.getDefaultFont(), this.bgColor, this.alignment, this.key, labelAddOnDTOs, dmk, state, this.getUniqueItemIdentifier());
    }

    public static class XMLFactory
    implements ElementParser {
        public ClassObjectPair parse(Element element, ParserFactory factory) throws ElementParserException {
            List elements = element.getChildren();
            ArrayList<Object> labelAddOns = null;
            ExpertDisplayInfoDTO.FontDTO font = null;
            Iterator i = elements.iterator();
            while (i.hasNext()) {
                Element subElement = (Element)i.next();
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof ExpertLabelAddOn) {
                        if (labelAddOns == null) {
                            labelAddOns = new ArrayList<Object>();
                        }
                        labelAddOns.add(ref);
                        continue;
                    }
                    if (ref instanceof ExpertDisplayInfoDTO.FontDTO) {
                        font = (ExpertDisplayInfoDTO.FontDTO)ref;
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + ref);
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), pnre);
                }
            }
            String key = element.getAttributeValue("key");
            if (key == null) {
                key = element.getAttributeValue("name");
            }
            if (key == null) {
                key = element.getAttributeValue("i18nKey");
            }
            ExpertWizardLinkItem eli = new ExpertWizardLinkItem(key, ExpertDisplayUtil.toPixel(element.getAttributeValue("x")), ExpertDisplayUtil.toPixel(element.getAttributeValue("y")), ExpertDisplayUtil.toPixel(element.getAttributeValue("width")), ExpertDisplayUtil.toPixel(element.getAttributeValue("height")), ExpertDisplayUtil.parseHAlignment(element.getAttributeValue("halign")), font, ExpertDisplayUtil.parseColor(element.getAttributeValue("bgColor")), labelAddOns, ExpertDisplayUtil.parseLanguages(element.getAttributeValue("lang")), element.getAttributeValue("wizardDmk"), element.getAttributeValue("state"));
            return new ClassObjectPair(class$ch$dvbern$tax$common$engine$expertdisplay$ExpertFormItem$FormElement == null ? (class$ch$dvbern$tax$common$engine$expertdisplay$ExpertFormItem$FormElement = ExpertWizardLinkItem.class$("ch.dvbern.tax.common.engine.expertdisplay.ExpertFormItem$FormElement")) : class$ch$dvbern$tax$common$engine$expertdisplay$ExpertFormItem$FormElement, eli);
        }
    }
}

