/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.expertdisplay;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModel;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayUtil;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertLabelAddOn;
import ch.dvbern.tax.common.engine.expertdisplay.ExtraPagesSumItem;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import ch.dvbern.tax.common.transfer.failure.InvalidModelItemKeyException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ExpertTableColumn
extends ExpertDisplayModelItem {
    private String title;
    private int type;
    private int width;
    private int alignment;
    private boolean readonly;
    private String readonlyItemName;
    private LogicModelItem readonlyItem;
    private ExpertDisplayInfoDTO.FontDTO font;
    private ExpertDisplayInfoDTO.ColorDTO bgColor;
    private String logicModelItemName;
    private LogicModelItem logicModelItem;
    private AbstractConverter rendererAndInputValidator;
    private Map valuePositions;
    private List labelAddOns;
    private String key;
    private boolean isExtraPagesSum;
    private String extraPagesSumKey;
    private ExtraPagesSumItem extraPagesSumPos;
    private boolean submitOnChange;
    private String buttonValueItemName;
    private LogicModelItem buttonValueItem;
    private String uri;
    private String icon;
    private boolean blankItem = false;
    private boolean autoWidthOnFocus;
    private String reRender;
    static /* synthetic */ Class class$ch$dvbern$tax$common$engine$expertdisplay$ExpertDisplayModelItem;

    public ExpertTableColumn(String title, int type, int width, int alignment, boolean readonly, ExpertDisplayInfoDTO.FontDTO font, ExpertDisplayInfoDTO.ColorDTO bgColor, String logicModelItemName, AbstractConverter rendererAndInputValidator, Map valuePositions, String key, List labelAddOns, boolean isExtraPagesSum, String extraPagesSumKey, int printMode, boolean inputColumn, ExtraPagesSumItem extraPagesSumPos, boolean submitOnChange, String buttonValueItemName, String icon, String uri, boolean blankItem, boolean autoWidthOnFocus, String readonlyItemName, String reRender) {
        super(null, printMode, inputColumn);
        this.title = title;
        this.type = type;
        this.width = width;
        this.alignment = alignment;
        this.readonly = readonly;
        this.font = font;
        this.bgColor = bgColor;
        this.logicModelItemName = logicModelItemName;
        this.rendererAndInputValidator = rendererAndInputValidator;
        this.valuePositions = valuePositions;
        this.labelAddOns = labelAddOns;
        this.key = key;
        this.isExtraPagesSum = isExtraPagesSum;
        this.extraPagesSumKey = extraPagesSumKey;
        this.extraPagesSumPos = extraPagesSumPos;
        this.submitOnChange = submitOnChange;
        this.buttonValueItemName = buttonValueItemName;
        this.icon = icon;
        this.uri = uri;
        this.blankItem = blankItem;
        this.autoWidthOnFocus = autoWidthOnFocus;
        this.readonlyItemName = readonlyItemName;
        this.reRender = reRender;
    }

    public LogicModelItem getLogicModelItem() {
        return this.logicModelItem;
    }

    public List getChildren() {
        return this.labelAddOns;
    }

    protected void additionalInitialization(Map logicModelItems, Map navigationItems) throws InvalidModelException {
        super.additionalInitialization(logicModelItems, navigationItems);
        if (this.logicModelItemName != null) {
            this.logicModelItem = (LogicModelItem)logicModelItems.get(this.logicModelItemName);
            if (this.logicModelItem == null) {
                throw new InvalidModelException("invalid item reference (" + this.logicModelItemName + ") in " + this.getClass().getName());
            }
        }
        if (this.buttonValueItemName != null) {
            this.buttonValueItem = (LogicModelItem)logicModelItems.get(this.buttonValueItemName);
            if (this.buttonValueItem == null) {
                throw new InvalidModelException("invalid item reference (" + this.buttonValueItemName + ") in " + this.getClass().getName());
            }
        }
        if (this.readonlyItemName != null) {
            this.readonlyItem = (LogicModelItem)logicModelItems.get(this.readonlyItemName);
            if (this.readonlyItem == null) {
                throw new InvalidModelException("invalid item reference (" + this.readonlyItemName + ") in " + this.getClass().getName());
            }
        }
    }

    private ExpertDisplayInfoDTO.FontDTO getCellFont(ExpertDisplayInfoDTO.FontDTO tableCellFont, ExpertDisplayModel.RequestContext requestContext) {
        if (this.font != null) {
            return this.font;
        }
        if (tableCellFont != null) {
            return tableCellFont;
        }
        if (requestContext.getDefaultTableFont() != null) {
            return requestContext.getDefaultTableFont();
        }
        return requestContext.getDefaultFont();
    }

    private ExpertDisplayInfoDTO.FontDTO getHeaderFont(ExpertDisplayInfoDTO.FontDTO tableHeaderFont, ExpertDisplayModel.RequestContext requestContext) {
        if (tableHeaderFont != null) {
            return tableHeaderFont;
        }
        if (requestContext.getDefaultTableHeaderFont() != null) {
            return requestContext.getDefaultTableHeaderFont();
        }
        if (this.font != null) {
            return this.font;
        }
        if (requestContext.getDefaultTableFont() != null) {
            return requestContext.getDefaultTableFont();
        }
        return requestContext.getDefaultFont();
    }

    public ExpertDisplayInfoDTO.TableDTO.ColumnDTO getColumnDTO(ExpertDisplayModel.RequestContext requestContext, ExpertDisplayInfoDTO.FontDTO tableHeaderFont, ExpertDisplayInfoDTO.FontDTO tableCellFont) throws InvalidModelItemKeyException {
        ExpertDisplayInfoDTO.FontDTO headerFontDTO = this.getHeaderFont(tableHeaderFont, requestContext);
        ExpertDisplayInfoDTO.FontDTO cellFontDTO = this.getCellFont(tableCellFont, requestContext);
        ExpertDisplayInfoDTO.TableDTO.ExtraPagesSumDTO extraPagesSumDTO = null;
        if (this.extraPagesSumPos != null) {
            extraPagesSumDTO = this.extraPagesSumPos.getDTO(headerFontDTO, this.alignment);
        }
        boolean ro = this.readonly;
        if (this.readonlyItem != null) {
            String dmk = ExpertDisplayUtil.getModelItemKey(this.readonlyItem, requestContext.getFormAccessKey());
            ModelItemDTO miDTO = requestContext.getDataModel().getModelItem(dmk);
            if (miDTO != null && Boolean.TRUE.equals(miDTO.getValue())) {
                ro = true;
            }
        }
        return new ExpertDisplayInfoDTO.TableDTO.ColumnDTO(this.title, this.type, this.width, this.alignment, ro, headerFontDTO, this.bgColor, this.rendererAndInputValidator, this.valuePositions, this.isExtraPagesSum, this.extraPagesSumKey, this.getPrintMode(), this.isInputItem(), extraPagesSumDTO, this.submitOnChange, this.autoWidthOnFocus, this.getUniqueItemIdentifier(), this.logicModelItemName, cellFontDTO);
    }

    public ExpertDisplayInfoDTO.TableDTO.CellDTO getCellDTO(ExpertDisplayModel.RequestContext requestContext, String rowFormAccessKey, ExpertDisplayInfoDTO.FontDTO tableCellFont) throws InvalidModelItemKeyException {
        if (this.uri != null) {
            String cmdDmk = ExpertDisplayUtil.getModelItemKey(this.logicModelItem, rowFormAccessKey);
            String valueDmk = ExpertDisplayUtil.getModelItemKey(this.buttonValueItem, rowFormAccessKey);
            return new ExpertDisplayInfoDTO.TableDTO.ButtonCellDTO(cmdDmk, valueDmk, this.key, this.icon, this.uri, requestContext.getDataModel().get(cmdDmk), 1, this.getUniqueItemIdentifier() + "." + rowFormAccessKey, this.getCellFont(tableCellFont, requestContext), this.reRender);
        }
        if (this.key == null) {
            String cellDMK = ExpertDisplayUtil.getModelItemKey(this.getLogicModelItem(), rowFormAccessKey);
            ModelItemDTO cell_miDTO = requestContext.getDataModel().getModelItem(cellDMK);
            OptionItemsDTO optionItems = null;
            LogicModelItem lmi = this.getLogicModelItem();
            if (lmi instanceof LogicModelItem.SelectItem) {
                optionItems = ((LogicModelItem.SelectItem)((Object)lmi)).getOptionItems(requestContext.getDataModel(), cellDMK);
            }
            if (this.type == 2) {
                ExpertDisplayUtil.handleBlankItem(optionItems, this.blankItem);
            }
            return new ExpertDisplayInfoDTO.TableDTO.ValueCellDTO(cellDMK, cell_miDTO, optionItems, 1, this.getUniqueItemIdentifier() + cellDMK, this.getCellFont(tableCellFont, requestContext), this.reRender);
        }
        ArrayList<ExpertDisplayInfoDTO.LabelDTO.LabelAddOnDTO> labelAddOnDTOs = null;
        if (this.labelAddOns != null && this.labelAddOns.size() > 0) {
            labelAddOnDTOs = new ArrayList<ExpertDisplayInfoDTO.LabelDTO.LabelAddOnDTO>();
            Iterator i = this.labelAddOns.iterator();
            while (i.hasNext()) {
                ExpertLabelAddOn labelAddOn = (ExpertLabelAddOn)i.next();
                ExpertDisplayInfoDTO.LabelDTO.LabelAddOnDTO labelAddOnDTO = labelAddOn.getLabelAddOnDTO(requestContext, rowFormAccessKey);
                labelAddOnDTOs.add(labelAddOnDTO);
            }
        }
        return new ExpertDisplayInfoDTO.TableDTO.LabelCellDTO(this.key, labelAddOnDTOs, 1, this.getUniqueItemIdentifier() + "." + rowFormAccessKey, this.getCellFont(tableCellFont, requestContext));
    }

    public String getExtraPagesSumKey() {
        return this.extraPagesSumKey;
    }

    public boolean isExtraPagesSum() {
        return this.isExtraPagesSum;
    }

    public static class XMLFactory
    implements ElementParser {
        public ClassObjectPair parse(Element element, ParserFactory factory) throws ElementParserException {
            String key;
            List elements = element.getChildren();
            HashMap<String, ExpertDisplayInfoDTO.ValuePositionDTO> valuePositions = null;
            ExpertDisplayInfoDTO.FontDTO font = null;
            AbstractConverter converter = null;
            ArrayList<Object> labelAddOns = null;
            ExtraPagesSumItem extraPagesSumPos = null;
            Iterator i = elements.iterator();
            while (i.hasNext()) {
                Element subElement = (Element)i.next();
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof ExpertDisplayInfoDTO.ValuePositionDTO) {
                        ExpertDisplayInfoDTO.ValuePositionDTO vp = (ExpertDisplayInfoDTO.ValuePositionDTO)ref;
                        if (valuePositions == null) {
                            valuePositions = new HashMap<String, ExpertDisplayInfoDTO.ValuePositionDTO>();
                        }
                        valuePositions.put(vp.getValue(), vp);
                        continue;
                    }
                    if (ref instanceof ExpertLabelAddOn) {
                        if (labelAddOns == null) {
                            labelAddOns = new ArrayList<Object>();
                        }
                        labelAddOns.add(ref);
                        continue;
                    }
                    if (ref instanceof ExpertDisplayInfoDTO.FontDTO) {
                        font = (ExpertDisplayInfoDTO.FontDTO)ref;
                        continue;
                    }
                    if (ref instanceof AbstractConverter) {
                        converter = (AbstractConverter)ref;
                        continue;
                    }
                    if (ref instanceof ExtraPagesSumItem) {
                        extraPagesSumPos = (ExtraPagesSumItem)ref;
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + ref);
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), pnre);
                }
            }
            ExpertDisplayUtil.TypeAndConverter typeAndConverter = ExpertDisplayUtil.parseInputType(element, converter);
            String value = element.getAttributeValue("value");
            if (value == null) {
                value = element.getAttributeValue("buttonCommand");
            }
            if ((key = element.getAttributeValue("key")) == null && value == null) {
                throw new ElementParserException("a column must have a key or a value");
            }
            if (key == null && labelAddOns != null && !labelAddOns.isEmpty()) {
                throw new ElementParserException("you must specify a key if you add label-add-ons");
            }
            boolean isExtraPagesSum = ExpertDisplayUtil.getBoolean(element.getAttributeValue("extraPagesSum"), false);
            String extraPagesSumKey = element.getAttributeValue("extraPagesSumKey");
            if (isExtraPagesSum && extraPagesSumKey != null) {
                throw new ElementParserException("a column can't have a extraPagesSumKey and be a extra pages sum");
            }
            String reRender = "self";
            if (element.getAttribute("reRender") != null) {
                reRender = element.getAttributeValue("reRender");
            }
            ExpertTableColumn etc = new ExpertTableColumn(element.getAttributeValue("title"), typeAndConverter.type, ExpertDisplayUtil.toPixel(element.getAttributeValue("width")), ExpertDisplayUtil.parseHAlignment(element.getAttributeValue("halign")), ExpertDisplayUtil.getBoolean(element.getAttributeValue("readonly"), false), font, ExpertDisplayUtil.parseColor(element.getAttributeValue("bgColor")), value, typeAndConverter.converter, valuePositions, key, labelAddOns, isExtraPagesSum, extraPagesSumKey, ExpertDisplayUtil.parseOutputMode(element.getAttributeValue("printColumn"), 8), ExpertDisplayUtil.getBoolean(element.getAttributeValue("inputColumn"), true), extraPagesSumPos, ExpertDisplayUtil.getBoolean(element.getAttributeValue("submitOnChange"), false), element.getAttributeValue("buttonValue"), element.getAttributeValue("icon"), element.getAttributeValue("URI"), ExpertDisplayUtil.getBoolean(element.getAttributeValue("blank-item"), true), ExpertDisplayUtil.getBoolean(element.getAttributeValue("auto-width-on-focus"), false), element.getAttributeValue("readonly-ref"), reRender);
            return new ClassObjectPair(class$ch$dvbern$tax$common$engine$expertdisplay$ExpertDisplayModelItem == null ? (class$ch$dvbern$tax$common$engine$expertdisplay$ExpertDisplayModelItem = ExpertTableColumn.class$("ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModelItem")) : class$ch$dvbern$tax$common$engine$expertdisplay$ExpertDisplayModelItem, etc);
        }
    }
}

