/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.expertdisplay;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModel;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayUtil;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertLabelAddOn;
import ch.dvbern.tax.common.engine.modelitems.Table;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.failure.InvalidModelItemKeyException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class ExpertNavigationItem
extends ExpertDisplayModelItem {
    private ExpertNavigationItem parent;
    private String name;
    private String descKey;
    private String iconName;
    private List subItems;
    private String stateItemNames;
    private String printStateItemNames;
    private String tableItemName;
    private int superTablestructs;
    private List stateItems;
    private List printStateItems;
    private LogicModelItem tableItem;
    private boolean extraForm;
    private boolean printGesamtausdruck;
    private boolean printEinzeldruck;
    private String entryDescKey;
    private String newEntryDescKey;
    private String entryKey;
    private String newEntryKey;
    private List entryDescAddOns;
    private List childs;
    private String deleteItemName;
    private LogicModelItem deleteItem;
    private static Comparator tableRowSorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            if (o1 instanceof String && o2 instanceof String) {
                return new Integer((String)o1).compareTo(new Integer((String)o2));
            }
            return 0;
        }
    };
    static /* synthetic */ Class class$ch$dvbern$tax$common$engine$expertdisplay$ExpertNavigationItem;

    public ExpertNavigationItem(String name, String iconName, List subItems, String stateItemNames, String tableItemName, boolean extraForm, String printStateItemNames, String entryDescKey, List entryDescAddOns, String newEntryDescKey, String newEntryKey, String entryKey, String descKey, String deleteItem, boolean printGesamtausdruck, boolean printEinzeldruck) {
        super(null, 0, true);
        this.name = name;
        this.iconName = iconName;
        this.subItems = subItems;
        this.stateItemNames = stateItemNames;
        this.tableItemName = tableItemName;
        this.extraForm = extraForm;
        this.printStateItemNames = printStateItemNames;
        this.entryDescKey = entryDescKey;
        this.newEntryDescKey = newEntryDescKey;
        this.entryDescAddOns = entryDescAddOns;
        this.entryKey = entryKey;
        this.newEntryKey = newEntryKey;
        this.descKey = descKey;
        this.deleteItemName = deleteItem;
        this.printGesamtausdruck = printGesamtausdruck;
        this.printEinzeldruck = printEinzeldruck;
        this.childs = new ArrayList();
        if (subItems != null) {
            this.childs.addAll(subItems);
        }
        if (entryDescAddOns != null) {
            this.childs.addAll(entryDescAddOns);
        }
    }

    public String getAccessKey() {
        return this.name + "#";
    }

    public String getName() {
        return this.name;
    }

    public List getStateItems() {
        return this.stateItems;
    }

    public List getChildren() {
        return this.childs;
    }

    public int getSuperTablestructs() {
        return this.superTablestructs;
    }

    public List getSubItems() {
        return this.subItems;
    }

    protected boolean isTableNavigation() {
        return this.tableItemName != null;
    }

    private void setParent(ExpertNavigationItem parent) {
        this.parent = parent;
    }

    ExpertNavigationItem getParent() {
        return this.parent;
    }

    protected void additionalInitialization(Map logicModel, Map navigationItems) throws InvalidModelException {
        super.additionalInitialization(logicModel, navigationItems);
        if (this.parent == null) {
            this.superTablestructs = 0;
        } else {
            this.superTablestructs = this.parent.getSuperTablestructs();
            if (this.parent.isTableNavigation()) {
                ++this.superTablestructs;
            }
        }
        if (this.tableItemName != null) {
            this.tableItem = (LogicModelItem)logicModel.get(this.tableItemName);
            if (!(this.tableItem instanceof Table)) {
                throw new InvalidModelException("invalid reference to table item (" + this.tableItemName + ") in " + this.getClass().getName() + " (" + this.name + ")");
            }
            String nwtis = this.tableItem.getNameWithTableIndexShapes();
            if (ExpertDisplayUtil.getShapeCount(nwtis) > this.superTablestructs) {
                throw new InvalidModelException("invalid reference to table item (" + this.tableItemName + ") in " + this.getClass().getName() + " (" + this.name + ")");
            }
        }
        this.stateItems = this.resloveStateItems(this.stateItemNames, logicModel);
        if (this.stateItems.isEmpty()) {
            throw new InvalidModelException("missing stateItems in " + this.getClass().getName() + " (" + this.name + ")");
        }
        this.printStateItems = this.resloveStateItems(this.printStateItemNames, logicModel);
        if (this.deleteItemName != null) {
            this.deleteItem = (LogicModelItem)logicModel.get(this.deleteItemName);
            if (this.deleteItem == null) {
                throw new InvalidModelException("invalid reference to delete item (" + this.deleteItemName + ") in " + this.getClass().getName() + " (" + this.name + ")");
            }
        }
    }

    private List resloveStateItems(String names, Map logicModel) throws InvalidModelException {
        if (names == null || names.length() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<LogicModelItem> items = new ArrayList<LogicModelItem>();
        StringTokenizer st = new StringTokenizer(names, ",");
        while (st.hasMoreTokens()) {
            String s = st.nextToken().trim();
            LogicModelItem lmi = (LogicModelItem)logicModel.get(s);
            if (lmi == null) {
                throw new InvalidModelException("invalid state reference into logic Model (" + s + ") in " + this.getClass().getName() + " (" + this.name + ")");
            }
            String nwtis = lmi.getNameWithTableIndexShapes();
            if (ExpertDisplayUtil.getShapeCount(nwtis) > this.superTablestructs) {
                throw new InvalidModelException("invalid state reference into logic Model (" + s + ") in " + this.getClass().getName() + " (" + this.name + ")");
            }
            items.add(lmi);
        }
        return items;
    }

    public ExpertDisplayInfoDTO.NavigationDTO getDTO(ExpertDisplayModel.ProtectedMap dataModel, String formKey, FastStack tableIndizes, FastStack navigationPath, boolean readonly) throws InvalidModelItemKeyException {
        StringBuffer tableKey = new StringBuffer("X#");
        Iterator i = tableIndizes.iterator();
        while (i.hasNext()) {
            tableKey.append(i.next());
        }
        int state = this.calcState(this.stateItems, dataModel, tableKey.toString());
        if (state == 12) {
            return null;
        }
        if (state == 11 && readonly) {
            return null;
        }
        int printState = this.calcState(this.printStateItems, dataModel, tableKey.toString());
        List<ExpertDisplayInfoDTO.NavigationDTO> subItemDTOs = null;
        ExpertDisplayInfoDTO.NavigationDTO newEntryItem = null;
        if (navigationPath == null || !navigationPath.isEmpty() && navigationPath.peek() == this) {
            if (navigationPath != null) {
                navigationPath.pop();
            }
            subItemDTOs = new ArrayList();
            if (this.tableItem != null) {
                int newIndex = 90000;
                int formCount = 1;
                String tableDMK = ExpertDisplayUtil.getModelItemKey(this.tableItem, tableKey.toString());
                ModelItemDTO miDTO = dataModel.getWithoutTouch(tableDMK);
                if (miDTO != null && miDTO.getValue() != null) {
                    ArrayList sortedRows = new ArrayList((Set)miDTO.getValue());
                    Collections.sort(sortedRows, tableRowSorter);
                    Iterator i2 = sortedRows.iterator();
                    while (i2.hasNext()) {
                        Object currentTableEntryIndex = i2.next();
                        int ctei = new Integer(currentTableEntryIndex.toString());
                        if (ctei >= newIndex) {
                            newIndex = ctei + 1;
                        }
                        tableIndizes.push(currentTableEntryIndex);
                        boolean tableEntryIsSelected = formKey == null || ExpertDisplayUtil.isTableEntrySelected(this.superTablestructs, currentTableEntryIndex, formKey);
                        String fak = this.getAccessKey(tableIndizes);
                        String rowDMK = tableDMK + "." + currentTableEntryIndex;
                        ModelItemDTO rowDTO = dataModel.getWithoutTouch(rowDMK);
                        List descAddOns = this.getDescAddOns(dataModel, fak);
                        List tableEntrySubItemDTOs = this.getSubItemDTOs(dataModel, formKey, tableIndizes, navigationPath, readonly);
                        if (tableEntrySubItemDTOs != null && tableEntrySubItemDTOs.size() > 0) {
                            ExpertDisplayInfoDTO.NavigationDTO entry = (ExpertDisplayInfoDTO.NavigationDTO)tableEntrySubItemDTOs.get(0);
                            fak = entry.getAccessKey();
                        }
                        subItemDTOs.add(new ExpertDisplayInfoDTO.NavigationDTO(rowDTO.getState(), this.entryKey, fak, null, tableEntrySubItemDTOs, tableEntryIsSelected, rowDMK, false, printState, this.entryDescKey, descAddOns, true, true, null, this.getUniqueItemIdentifier() + "." + formKey + "." + currentTableEntryIndex, this.printGesamtausdruck, this.printEinzeldruck));
                        tableIndizes.pop();
                        ++formCount;
                    }
                }
                if (!readonly) {
                    tableIndizes.push(new Integer(newIndex).toString());
                    List tableEntrySubItemDTOs = this.getSubItemDTOs(dataModel, formKey, tableIndizes, navigationPath, readonly);
                    String fak = this.getAccessKey(tableIndizes);
                    if (tableEntrySubItemDTOs != null && !tableEntrySubItemDTOs.isEmpty()) {
                        ExpertDisplayInfoDTO.NavigationDTO entry = (ExpertDisplayInfoDTO.NavigationDTO)tableEntrySubItemDTOs.get(0);
                        fak = entry.getAccessKey();
                    }
                    if (ExpertDisplayUtil.isTableEntrySelected(this.superTablestructs, new Integer(newIndex), formKey)) {
                        subItemDTOs.add(new ExpertDisplayInfoDTO.NavigationDTO(3, this.entryKey, fak, null, tableEntrySubItemDTOs, true, null, false, printState, this.entryDescKey, this.getDescAddOns(dataModel, fak), true, true, null, this.getUniqueItemIdentifier() + "." + formKey + "." + newIndex, this.printGesamtausdruck, this.printEinzeldruck));
                    }
                    newEntryItem = new ExpertDisplayInfoDTO.NavigationDTO(3, this.newEntryKey, fak, null, null, false, null, false, printState, this.newEntryDescKey, null, false, false, null, this.getUniqueItemIdentifier() + "." + formKey + "." + "NEW", this.printGesamtausdruck, this.printEinzeldruck);
                    subItemDTOs.add(newEntryItem);
                    tableIndizes.pop();
                }
            } else {
                subItemDTOs = this.getSubItemDTOs(dataModel, formKey, tableIndizes, navigationPath, readonly);
            }
        }
        String fak = this.getAccessKey(tableIndizes);
        boolean selected = fak.equals(formKey);
        String dmkDelete = null;
        if (this.deleteItem != null) {
            dmkDelete = ExpertDisplayUtil.getModelItemKey(this.deleteItem, fak);
        }
        return new ExpertDisplayInfoDTO.NavigationDTO(state, this.descKey, fak, this.iconName, subItemDTOs, selected, dmkDelete, this.extraForm, printState, this.name, null, dmkDelete != null, true, newEntryItem, this.getUniqueItemIdentifier() + "." + formKey, this.printGesamtausdruck, this.printEinzeldruck);
    }

    private int calcState(List items, ExpertDisplayModel.ProtectedMap dataModel, String tableKey) throws InvalidModelItemKeyException {
        int state = 1;
        if (!items.isEmpty()) {
            int maxPropagateableState = 1;
            int minState = 12;
            Iterator i = items.iterator();
            while (i.hasNext()) {
                int newState;
                LogicModelItem lmi = (LogicModelItem)i.next();
                ModelItemDTO miDTO = dataModel.getWithoutTouch(ExpertDisplayUtil.getModelItemKey(lmi, tableKey));
                int n = newState = miDTO != null ? miDTO.getState() : 3;
                if (ModelItemDTO.isPropagatableState(newState) && ModelItemDTO.isMoreImportantState(newState, maxPropagateableState)) {
                    maxPropagateableState = newState;
                }
                if (ModelItemDTO.isMoreImportantState(newState, minState)) continue;
                minState = newState;
            }
            state = !ModelItemDTO.isPropagatableState(minState) ? minState : maxPropagateableState;
        }
        return state;
    }

    private String getAccessKey(FastStack tableIndizes) {
        StringBuffer result = new StringBuffer(this.name);
        result.append("#");
        Iterator j = tableIndizes.iterator();
        while (j.hasNext()) {
            result.append(j.next().toString());
            if (!j.hasNext()) continue;
            result.append(".");
        }
        return result.toString();
    }

    private List getSubItemDTOs(ExpertDisplayModel.ProtectedMap dataModel, String formKey, FastStack tableIndizes, FastStack navigationPath, boolean readonly) throws InvalidModelItemKeyException {
        ArrayList<ExpertDisplayInfoDTO.NavigationDTO> result = null;
        if (this.subItems != null) {
            Iterator i = this.subItems.iterator();
            while (i.hasNext()) {
                ExpertNavigationItem subItem = (ExpertNavigationItem)i.next();
                ExpertDisplayInfoDTO.NavigationDTO subItemDTO = subItem.getDTO(dataModel, formKey, tableIndizes, navigationPath, readonly);
                if (subItemDTO == null) continue;
                if (result == null) {
                    result = new ArrayList<ExpertDisplayInfoDTO.NavigationDTO>();
                }
                result.add(subItemDTO);
            }
        }
        return result;
    }

    private List getDescAddOns(ExpertDisplayModel.ProtectedMap dataModel, String fak) throws InvalidModelItemKeyException {
        ArrayList<ExpertDisplayInfoDTO.LabelDTO.LabelAddOnDTO> labelAddOnDTOs = null;
        if (this.entryDescAddOns != null && this.entryDescAddOns.size() > 0) {
            ExpertDisplayModel.RequestContext requestContext = new ExpertDisplayModel.RequestContext(dataModel, fak, null, null, null, null, null, null);
            labelAddOnDTOs = new ArrayList<ExpertDisplayInfoDTO.LabelDTO.LabelAddOnDTO>();
            Iterator i = this.entryDescAddOns.iterator();
            while (i.hasNext()) {
                ExpertLabelAddOn labelAddOn = (ExpertLabelAddOn)i.next();
                ExpertDisplayInfoDTO.LabelDTO.LabelAddOnDTO labelAddOnDTO = labelAddOn.getLabelAddOnDTO(requestContext);
                labelAddOnDTOs.add(labelAddOnDTO);
            }
        }
        return labelAddOnDTOs;
    }

    public static class XMLFactory
    implements ElementParser {
        public ClassObjectPair parse(Element element, ParserFactory factory) throws ElementParserException {
            List elements = element.getChildren();
            ArrayList<Object> subItems = null;
            ArrayList<Object> descAddOns = null;
            Iterator i = elements.iterator();
            while (i.hasNext()) {
                Element subElement = (Element)i.next();
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof ExpertNavigationItem) {
                        if (subItems == null) {
                            subItems = new ArrayList<Object>();
                        }
                        subItems.add(ref);
                        continue;
                    }
                    if (ref instanceof ExpertLabelAddOn) {
                        if (descAddOns == null) {
                            descAddOns = new ArrayList<Object>();
                        }
                        descAddOns.add(ref);
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + ref);
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), pnre);
                }
            }
            String name = element.getAttributeValue("name");
            String descKey = element.getAttributeValue("descKey");
            if (descKey == null) {
                descKey = name;
            }
            ExpertNavigationItem eni = new ExpertNavigationItem(name, element.getAttributeValue("icon"), subItems, element.getAttributeValue("stateItems"), element.getAttributeValue("table"), ExpertDisplayUtil.getBoolean(element.getAttributeValue("extraForm"), false), element.getAttributeValue("printStateItems"), element.getAttributeValue("entryDescKey"), descAddOns, element.getAttributeValue("newEntryDescKey"), element.getAttributeValue("newEntryKey"), element.getAttributeValue("entryKey"), descKey, element.getAttributeValue("deleteItem"), ExpertDisplayUtil.getBoolean(element.getAttributeValue("printGesamtausdruck"), true), ExpertDisplayUtil.getBoolean(element.getAttributeValue("printEinzeldruck"), true));
            if (subItems != null) {
                Iterator i2 = subItems.iterator();
                while (i2.hasNext()) {
                    ((ExpertNavigationItem)i2.next()).setParent(eni);
                }
            }
            return new ClassObjectPair(class$ch$dvbern$tax$common$engine$expertdisplay$ExpertNavigationItem == null ? (class$ch$dvbern$tax$common$engine$expertdisplay$ExpertNavigationItem = ExpertNavigationItem.class$("ch.dvbern.tax.common.engine.expertdisplay.ExpertNavigationItem")) : class$ch$dvbern$tax$common$engine$expertdisplay$ExpertNavigationItem, eni);
        }
    }
}

