/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.expertdisplay;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModel;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayUtil;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertLabelAddOn;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertListRowItem;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.failure.InvalidModelItemKeyException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ExpertListLabelRowItem
extends ExpertDisplayModelItem
implements ExpertListRowItem {
    private String labelKey;
    private String stateKey;
    private List labelAddOns;
    private LogicModelItem stateItem;
    static /* synthetic */ Class class$ch$dvbern$tax$common$engine$expertdisplay$ExpertListLabelRowItem;

    public ExpertListLabelRowItem(String labelKey, String stateKey, List labelAddOns) {
        super(null, 8, true);
        this.labelKey = labelKey;
        this.stateKey = stateKey;
        this.labelAddOns = labelAddOns;
    }

    public List getChildren() {
        return this.labelAddOns;
    }

    protected void additionalInitialization(Map logicModelItems, Map navigationItems) throws InvalidModelException {
        super.additionalInitialization(logicModelItems, navigationItems);
        if (this.stateKey != null) {
            this.stateItem = (LogicModelItem)logicModelItems.get(this.stateKey);
            if (this.stateItem == null) {
                throw new InvalidModelException("invalid state-reference in Row (key=" + this.stateKey + ")");
            }
        }
    }

    public ExpertDisplayInfoDTO.ListDTO.RowDTO getRowDTO(ExpertDisplayModel.RequestContext requestContext) throws InvalidModelItemKeyException {
        if (this.stateItem != null) {
            String dmk = ExpertDisplayUtil.getModelItemKey(this.stateItem, requestContext.getFormAccessKey());
            ModelItemDTO miDTO = requestContext.getDataModel().get(dmk);
            if (miDTO == null) {
                return null;
            }
            if (miDTO.getState() == 12) {
                return null;
            }
        }
        ArrayList<ExpertDisplayInfoDTO.LabelDTO.LabelAddOnDTO> labelAddOnDTOs = null;
        if (this.labelAddOns != null && this.labelAddOns.size() > 0) {
            labelAddOnDTOs = new ArrayList<ExpertDisplayInfoDTO.LabelDTO.LabelAddOnDTO>();
            Iterator i = this.labelAddOns.iterator();
            while (i.hasNext()) {
                ExpertLabelAddOn labelAddOn = (ExpertLabelAddOn)i.next();
                labelAddOnDTOs.add(labelAddOn.getLabelAddOnDTO(requestContext));
            }
        }
        return new ExpertDisplayInfoDTO.ListDTO.LabelRowDTO(this.labelKey, labelAddOnDTOs);
    }

    public static class XMLFactory
    implements ElementParser {
        public ClassObjectPair parse(Element element, ParserFactory factory) throws ElementParserException {
            List elements = element.getChildren();
            ArrayList<Object> labelAddOns = null;
            Iterator i = elements.iterator();
            while (i.hasNext()) {
                Element subElement = (Element)i.next();
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof ExpertLabelAddOn) {
                        if (labelAddOns == null) {
                            labelAddOns = new ArrayList<Object>();
                        }
                        labelAddOns.add(ref);
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + ref);
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), pnre);
                }
            }
            String key = element.getAttributeValue("key");
            if (key == null) {
                key = element.getAttributeValue("name");
            }
            if (key == null) {
                key = element.getAttributeValue("i18nKey");
            }
            ExpertListLabelRowItem eli = new ExpertListLabelRowItem(key, element.getAttributeValue("state"), labelAddOns);
            return new ClassObjectPair(class$ch$dvbern$tax$common$engine$expertdisplay$ExpertListLabelRowItem == null ? (class$ch$dvbern$tax$common$engine$expertdisplay$ExpertListLabelRowItem = ExpertListLabelRowItem.class$("ch.dvbern.tax.common.engine.expertdisplay.ExpertListLabelRowItem")) : class$ch$dvbern$tax$common$engine$expertdisplay$ExpertListLabelRowItem, eli);
        }
    }
}

