/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.expertdisplay;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModel;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayUtil;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertListRowItem;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.failure.InvalidModelItemKeyException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ExpertListIteratorItem
extends ExpertDisplayModelItem {
    private String tableKey;
    private String stateKey;
    private LogicModelItem tableItem;
    private LogicModelItem stateItem;
    private List children;
    static /* synthetic */ Class class$ch$dvbern$tax$common$engine$expertdisplay$ExpertListIteratorItem;

    public ExpertListIteratorItem(String tableKey, String stateKey, List rows) {
        super(null, 8, true);
        this.tableKey = tableKey;
        this.stateKey = stateKey;
        this.children = rows;
    }

    public List getChildren() {
        return this.children;
    }

    protected void additionalInitialization(Map logicModelItems, Map navigationItems) throws InvalidModelException {
        super.additionalInitialization(logicModelItems, navigationItems);
        if (this.stateKey != null) {
            this.stateItem = (LogicModelItem)logicModelItems.get(this.stateKey);
            if (this.stateItem == null) {
                throw new InvalidModelException("invalid state-reference in Row (key=" + this.stateKey + ")");
            }
        }
        if (this.tableKey != null) {
            this.tableItem = (LogicModelItem)logicModelItems.get(this.tableKey);
            if (this.tableItem == null) {
                throw new InvalidModelException("invalid table-reference in Row (key=" + this.tableKey + ")");
            }
        } else {
            throw new InvalidModelException("missing table-reference in Row");
        }
    }

    public List getRowDTOs(ExpertDisplayModel.RequestContext requestContext) throws InvalidModelItemKeyException {
        String dmk;
        if (this.stateItem != null) {
            dmk = ExpertDisplayUtil.getModelItemKey(this.stateItem, requestContext.getFormAccessKey());
            ModelItemDTO miDTO = requestContext.getDataModel().get(dmk);
            if (miDTO == null) {
                return null;
            }
            if (miDTO.getState() == 12) {
                return null;
            }
        }
        dmk = ExpertDisplayUtil.getModelItemKey(this.tableItem, requestContext.getFormAccessKey());
        ModelItemDTO tableDTO = requestContext.getDataModel().get(dmk);
        if (tableDTO == null || !(tableDTO.getValue() instanceof Set)) {
            return null;
        }
        ArrayList<ExpertDisplayInfoDTO.ListDTO.RowDTO> result = new ArrayList<ExpertDisplayInfoDTO.ListDTO.RowDTO>();
        Iterator i = ((Set)tableDTO.getValue()).iterator();
        while (i.hasNext()) {
            StringBuffer newFAK = new StringBuffer(requestContext.getFormAccessKey());
            if (!newFAK.toString().endsWith("#")) {
                newFAK.append(".");
            }
            newFAK.append(i.next().toString());
            ExpertDisplayModel.RequestContext rc = new ExpertDisplayModel.RequestContext(requestContext.getDataModel(), newFAK.toString(), requestContext.getDefaultFont(), requestContext.getDefaultTableFont(), requestContext.getDefaultTableHeaderFont(), requestContext.getDefaultTableTitleFont(), requestContext.getDefaultTableTitlePattern(), requestContext.getLogicModelItems());
            Iterator it = this.children.iterator();
            while (it.hasNext()) {
                ExpertListIteratorItem iteratorItem;
                List rows;
                Object child = it.next();
                if (child instanceof ExpertListRowItem) {
                    ExpertListRowItem item = (ExpertListRowItem)child;
                    ExpertDisplayInfoDTO.ListDTO.RowDTO rowDTO = item.getRowDTO(rc);
                    if (rowDTO == null) continue;
                    result.add(rowDTO);
                    continue;
                }
                if (!(child instanceof ExpertListIteratorItem) || (rows = (iteratorItem = (ExpertListIteratorItem)child).getRowDTOs(rc)) == null) continue;
                result.addAll(rows);
            }
        }
        return result;
    }

    public static class XMLFactory
    implements ElementParser {
        public ClassObjectPair parse(Element element, ParserFactory factory) throws ElementParserException {
            List elements = element.getChildren();
            ArrayList<Object> children = new ArrayList<Object>();
            Iterator i = elements.iterator();
            while (i.hasNext()) {
                Element subElement = (Element)i.next();
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof ExpertListRowItem) {
                        children.add(ref);
                        continue;
                    }
                    if (ref instanceof ExpertListIteratorItem) {
                        children.add(ref);
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + ref);
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), pnre);
                }
            }
            ExpertListIteratorItem elrii = new ExpertListIteratorItem(element.getAttributeValue("table"), element.getAttributeValue("state"), children);
            return new ClassObjectPair(class$ch$dvbern$tax$common$engine$expertdisplay$ExpertListIteratorItem == null ? (class$ch$dvbern$tax$common$engine$expertdisplay$ExpertListIteratorItem = ExpertListIteratorItem.class$("ch.dvbern.tax.common.engine.expertdisplay.ExpertListIteratorItem")) : class$ch$dvbern$tax$common$engine$expertdisplay$ExpertListIteratorItem, elrii);
        }
    }
}

