/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.expertdisplay;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModel;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayUtil;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertFormItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertLabelAddOn;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.failure.InvalidModelItemKeyException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ExpertLabelItem
extends ExpertDisplayModelItem
implements ExpertFormItem.FormElement {
    private String key;
    private int x;
    private int y;
    private int width;
    private int height;
    private int alignment;
    private ExpertDisplayInfoDTO.FontDTO font;
    private ExpertDisplayInfoDTO.ColorDTO bgColor;
    private List labelAddOns;
    private boolean printIfAddOnEmpty;
    private String stateItemName;
    private LogicModelItem stateItem;
    static /* synthetic */ Class class$ch$dvbern$tax$common$engine$expertdisplay$ExpertFormItem$FormElement;

    public ExpertLabelItem(String key, int x, int y, int width, int height, int alignment, ExpertDisplayInfoDTO.FontDTO font, ExpertDisplayInfoDTO.ColorDTO bgColor, List labelAddOns, int printMode, boolean inputItem, Set languages, boolean printIfAddOnEmpty, String stateItemName) {
        super(languages, printMode, inputItem);
        this.key = key;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.alignment = alignment;
        this.font = font;
        this.bgColor = bgColor;
        this.labelAddOns = labelAddOns;
        this.printIfAddOnEmpty = printIfAddOnEmpty;
        this.stateItemName = stateItemName;
    }

    public List getChildren() {
        return this.labelAddOns;
    }

    protected void additionalInitialization(Map logicModelItems, Map navigationItems) throws InvalidModelException {
        super.additionalInitialization(logicModelItems, navigationItems);
        if (this.stateItemName != null) {
            this.stateItem = (LogicModelItem)logicModelItems.get(this.stateItemName);
            if (this.stateItem == null) {
                throw new InvalidModelException("invalid state-reference in e-label: " + this.stateItem);
            }
        }
    }

    public ExpertDisplayInfoDTO.ItemDTO getItemDTO(ExpertDisplayModel.RequestContext requestContext) throws InvalidModelItemKeyException {
        int outputMode = this.getPrintMode();
        ArrayList<ExpertDisplayInfoDTO.LabelDTO.LabelAddOnDTO> labelAddOnDTOs = null;
        if (this.stateItem != null) {
            String dmk = ExpertDisplayUtil.getModelItemKey(this.stateItem, requestContext.getFormAccessKey());
            ModelItemDTO stateDTO = requestContext.getDataModel().get(dmk);
            if (stateDTO != null && stateDTO.getState() == 12) {
                return null;
            }
        }
        if (this.labelAddOns != null && this.labelAddOns.size() > 0) {
            labelAddOnDTOs = new ArrayList<ExpertDisplayInfoDTO.LabelDTO.LabelAddOnDTO>();
            Iterator i = this.labelAddOns.iterator();
            while (i.hasNext()) {
                ExpertLabelAddOn labelAddOn = (ExpertLabelAddOn)i.next();
                ExpertDisplayInfoDTO.LabelDTO.LabelAddOnDTO labelAddOnDTO = labelAddOn.getLabelAddOnDTO(requestContext);
                labelAddOnDTOs.add(labelAddOnDTO);
                if (this.printIfAddOnEmpty || labelAddOnDTO.getValue() != null && labelAddOnDTO.getValue().toString().length() != 0) continue;
                outputMode = 0;
            }
        }
        return new ExpertDisplayInfoDTO.LabelDTO(this.x, this.y, this.width, this.height, this.font != null ? this.font : requestContext.getDefaultFont(), this.bgColor, this.alignment, this.key, labelAddOnDTOs, outputMode, requestContext.getFormAccessKey() + "." + this.getUniqueItemIdentifier());
    }

    public static class XMLFactory
    implements ElementParser {
        public ClassObjectPair parse(Element element, ParserFactory factory) throws ElementParserException {
            List elements = element.getChildren();
            ArrayList<Object> labelAddOns = null;
            ExpertDisplayInfoDTO.FontDTO font = null;
            Iterator i = elements.iterator();
            while (i.hasNext()) {
                Element subElement = (Element)i.next();
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof ExpertLabelAddOn) {
                        if (labelAddOns == null) {
                            labelAddOns = new ArrayList<Object>();
                        }
                        labelAddOns.add(ref);
                        continue;
                    }
                    if (ref instanceof ExpertDisplayInfoDTO.FontDTO) {
                        font = (ExpertDisplayInfoDTO.FontDTO)ref;
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + ref);
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), pnre);
                }
            }
            String key = element.getAttributeValue("key");
            if (key == null) {
                key = element.getAttributeValue("name");
            }
            if (key == null) {
                key = element.getAttributeValue("i18nKey");
            }
            ExpertLabelItem eli = new ExpertLabelItem(key, ExpertDisplayUtil.toPixel(element.getAttributeValue("x")), ExpertDisplayUtil.toPixel(element.getAttributeValue("y")), ExpertDisplayUtil.toPixel(element.getAttributeValue("width")), ExpertDisplayUtil.toPixel(element.getAttributeValue("height")), ExpertDisplayUtil.parseHAlignment(element.getAttributeValue("halign")), font, ExpertDisplayUtil.parseColor(element.getAttributeValue("bgColor")), labelAddOns, ExpertDisplayUtil.parseOutputMode(element.getAttributeValue("printItem")), ExpertDisplayUtil.getBoolean(element.getAttributeValue("inputItem"), true), ExpertDisplayUtil.parseLanguages(element.getAttributeValue("lang")), ExpertDisplayUtil.getBoolean(element.getAttributeValue("printIfAddOnEmpty"), true), element.getAttributeValue("state"));
            return new ClassObjectPair(class$ch$dvbern$tax$common$engine$expertdisplay$ExpertFormItem$FormElement == null ? (class$ch$dvbern$tax$common$engine$expertdisplay$ExpertFormItem$FormElement = ExpertLabelItem.class$("ch.dvbern.tax.common.engine.expertdisplay.ExpertFormItem$FormElement")) : class$ch$dvbern$tax$common$engine$expertdisplay$ExpertFormItem$FormElement, eli);
        }
    }
}

