/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.expertdisplay;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.Engine;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayUtil;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertFormItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertNavigationItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.UpdateResultDTO;
import ch.dvbern.tax.common.transfer.failure.InvalidModelItemKeyException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ExpertDisplayModel {
    private Map formItems;
    private List mainNavigationItems;
    private Map allNavigationItems = new HashMap();
    static /* synthetic */ Class class$ch$dvbern$tax$common$engine$expertdisplay$ExpertDisplayModel;

    public ExpertDisplayModel(Map formItems, List mainNavigationItems) {
        this.formItems = formItems;
        this.mainNavigationItems = mainNavigationItems;
        this.registerAllNavigationItems(mainNavigationItems);
    }

    private void registerAllNavigationItems(List navigationItems) {
        if (navigationItems == null || navigationItems.size() == 0) {
            return;
        }
        Iterator i = navigationItems.iterator();
        while (i.hasNext()) {
            ExpertNavigationItem element = (ExpertNavigationItem)i.next();
            this.allNavigationItems.put(element.getName(), element);
            this.registerAllNavigationItems(element.getSubItems());
        }
    }

    public void initializeExpertDisplayModel(Map logicModelItems) throws InvalidModelException {
        ExpertDisplayModelItem element;
        Iterator<Object> i;
        if (this.formItems != null) {
            i = this.formItems.values().iterator();
            while (i.hasNext()) {
                element = (ExpertFormItem)i.next();
                element.initializeExpertDisplayModel(logicModelItems, this.formItems);
            }
        }
        if (this.mainNavigationItems != null) {
            i = this.mainNavigationItems.iterator();
            while (i.hasNext()) {
                element = (ExpertNavigationItem)i.next();
                element.initializeExpertDisplayModel(logicModelItems, this.formItems);
            }
        }
    }

    public ExpertDisplayInfoDTO getExpertDisplayInfo(ProtectedMap dataModel, String key, Map logicModelItems, Locale locale, int mode) throws InvalidModelItemKeyException {
        ExpertFormItem efi;
        if (this.mainNavigationItems == null) {
            return null;
        }
        if (key == null) {
            FastStack tableIndices = new FastStack();
            Iterator it = this.mainNavigationItems.iterator();
            while (it.hasNext()) {
                ExpertNavigationItem eni = (ExpertNavigationItem)it.next();
                ExpertDisplayInfoDTO.NavigationDTO navDTO = eni.getDTO(dataModel, key, tableIndices, null, true);
                if (navDTO == null || navDTO.getState() == 11 || navDTO.getState() == 12 || navDTO.isExtraForm()) continue;
                key = eni.getAccessKey();
                break;
            }
        }
        if ((efi = (ExpertFormItem)this.formItems.get(ExpertDisplayUtil.getFormKeyWithoutTableIndizes(key))) != null) {
            RequestContext ctx = new RequestContext(dataModel, key, efi.getDefaultFont(), efi.getDefaultTableFont(), efi.getDefaultTableHeaderFont(), efi.getDefaultTableTitleFont(), efi.getDefaultTableTitlePattern(), logicModelItems);
            return efi.getDTO(ctx, this.mainNavigationItems, this.allNavigationItems, locale, mode);
        }
        throw new InvalidModelItemKeyException("invalid form access key (" + key + ")");
    }

    public List getFormStateItems(String formAccessKey) {
        ExpertNavigationItem navItem = (ExpertNavigationItem)this.allNavigationItems.get(ExpertDisplayUtil.getFormKeyWithoutTableIndizes(formAccessKey));
        if (navItem != null) {
            return navItem.getStateItems();
        }
        return null;
    }

    public List getExpertNavigationItems(ProtectedMap dataModel) throws InvalidModelItemKeyException {
        ArrayList<ExpertDisplayInfoDTO.NavigationDTO> result = new ArrayList<ExpertDisplayInfoDTO.NavigationDTO>();
        if (this.mainNavigationItems != null) {
            Iterator i = this.mainNavigationItems.iterator();
            while (i.hasNext()) {
                ExpertNavigationItem eni = (ExpertNavigationItem)i.next();
                ExpertDisplayInfoDTO.NavigationDTO dto = eni.getDTO(dataModel, null, new FastStack(), null, true);
                if (dto == null) continue;
                result.add(dto);
            }
        }
        return result;
    }

    public static class XMLFactory
    implements ElementParser {
        public ClassObjectPair parse(Element element, ParserFactory factory) throws ElementParserException {
            List elements = element.getChildren();
            HashMap<String, Object> formItems = null;
            ArrayList<Object> navigationItems = null;
            Iterator i = elements.iterator();
            while (i.hasNext()) {
                Element subElement = (Element)i.next();
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof ExpertNavigationItem) {
                        if (navigationItems == null) {
                            navigationItems = new ArrayList<Object>();
                        }
                        navigationItems.add(ref);
                        continue;
                    }
                    if (ref instanceof ExpertFormItem) {
                        if (formItems == null) {
                            formItems = new HashMap<String, Object>();
                        }
                        formItems.put(((ExpertFormItem)ref).getName(), ref);
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + ref);
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), pnre);
                }
            }
            return new ClassObjectPair(class$ch$dvbern$tax$common$engine$expertdisplay$ExpertDisplayModel == null ? (class$ch$dvbern$tax$common$engine$expertdisplay$ExpertDisplayModel = ExpertDisplayModel.class$("ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModel")) : class$ch$dvbern$tax$common$engine$expertdisplay$ExpertDisplayModel, new ExpertDisplayModel(formItems, navigationItems));
        }
    }

    public static class ProtectedMap
    extends LogicModelItem.ProtectedMap {
        private Engine e;
        private boolean writeOnView;
        private Map cache = new HashMap();

        public ProtectedMap(Map nestedMap, boolean writeOnView, Engine e) {
            super(nestedMap, true);
            this.writeOnView = writeOnView;
            this.e = e;
        }

        public ModelItemDTO getModelItem(Object key) {
            ModelItemDTO modelItemDTO = (ModelItemDTO)this.cache.get(key);
            if (modelItemDTO != null) {
                return modelItemDTO;
            }
            modelItemDTO = (ModelItemDTO)this.nestedMap.get(key);
            if (modelItemDTO == null) {
                modelItemDTO = new ModelItemDTO(null, 3);
                if (this.writeOnView) {
                    this.writeItemInModelOnRead(modelItemDTO, key);
                }
                modelItemDTO = (ModelItemDTO)this.nestedMap.get(key);
            }
            this.cache.put(key, modelItemDTO);
            return modelItemDTO;
        }

        private void writeItemInModelOnRead(ModelItemDTO modelItemDTO, Object key) {
            HashMap<Object, ModelItemDTO> changes = new HashMap<Object, ModelItemDTO>();
            changes.put(key, modelItemDTO);
            UpdateResultDTO result = this.e.update(this.nestedMap, changes, true);
            this.getChangedMap().putAll(result.getPersistenceWriteDTOs());
            this.getTableUpdates().putAll(result.getTableUpdates());
        }

        public ModelItemDTO getTable(Object key) {
            Map result;
            HashMap<Object, ModelItemDTO> changes;
            ModelItemDTO modelItemDTO = (ModelItemDTO)this.nestedMap.get(key);
            if (modelItemDTO == null) {
                modelItemDTO = new ModelItemDTO(new HashSet(), 1);
                modelItemDTO.setTouched();
                changes = new HashMap();
                changes.put(key, modelItemDTO);
                result = this.e.update(this.nestedMap, changes, true).getPersistenceWriteDTOs();
                this.getChangedMap().putAll(result);
            }
            if (modelItemDTO.getValue() == null || !modelItemDTO.isTouched()) {
                if (!modelItemDTO.isTouched()) {
                    modelItemDTO = modelItemDTO.clone(modelItemDTO.getValue());
                    modelItemDTO.setTouched();
                }
                changes = new HashMap<Object, ModelItemDTO>();
                changes.put(key, modelItemDTO);
                result = this.e.update(this.nestedMap, changes, true).getPersistenceWriteDTOs();
                this.getChangedMap().putAll(result);
            }
            return modelItemDTO;
        }

        public ModelItemDTO getWithoutTouch(Object key) {
            ModelItemDTO modelItemDTO = (ModelItemDTO)this.nestedMap.get(key);
            if (modelItemDTO == null) {
                modelItemDTO = new ModelItemDTO(null, 3);
            }
            return modelItemDTO;
        }

        public boolean getWriteOnView() {
            return this.writeOnView;
        }

        public void setWriteOnView(boolean writeOnView) {
            this.writeOnView = writeOnView;
        }
    }

    public static class RequestContext {
        ProtectedMap dataModel;
        String formAccessKey;
        ExpertDisplayInfoDTO.FontDTO defaultFont;
        ExpertDisplayInfoDTO.FontDTO defaultTableFont;
        ExpertDisplayInfoDTO.FontDTO defaultTableHeaderFont;
        ExpertDisplayInfoDTO.FontDTO defaultTableTitleFont;
        ExpertDisplayInfoDTO.PatternDTO defaultTableTitlePattern;
        Map logicModelItems;

        public RequestContext(ProtectedMap dataModel, String formAccessKey, ExpertDisplayInfoDTO.FontDTO defaultFont, ExpertDisplayInfoDTO.FontDTO defaultTableFont, ExpertDisplayInfoDTO.FontDTO defaultTableHeaderFont, ExpertDisplayInfoDTO.FontDTO defaultTableTitleFont, ExpertDisplayInfoDTO.PatternDTO defaultTableTitlePattern, Map logicModelItems) {
            this.dataModel = dataModel;
            this.formAccessKey = formAccessKey;
            this.defaultFont = defaultFont;
            this.defaultTableFont = defaultTableFont;
            this.defaultTableHeaderFont = defaultTableHeaderFont;
            this.defaultTableTitleFont = defaultTableTitleFont;
            this.defaultTableTitlePattern = defaultTableTitlePattern;
            this.logicModelItems = logicModelItems;
        }

        public ProtectedMap getDataModel() {
            return this.dataModel;
        }

        public String getFormAccessKey() {
            return this.formAccessKey;
        }

        public ExpertDisplayInfoDTO.FontDTO getDefaultFont() {
            return this.defaultFont;
        }

        public ExpertDisplayInfoDTO.FontDTO getDefaultTableFont() {
            return this.defaultTableFont;
        }

        public ExpertDisplayInfoDTO.FontDTO getDefaultTableHeaderFont() {
            return this.defaultTableHeaderFont;
        }

        public ExpertDisplayInfoDTO.FontDTO getDefaultTableTitleFont() {
            return this.defaultTableTitleFont;
        }

        public ExpertDisplayInfoDTO.PatternDTO getDefaultTableTitlePattern() {
            return this.defaultTableTitlePattern;
        }

        public Map getLogicModelItems() {
            return this.logicModelItems;
        }
    }
}

