/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.expertdisplay;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.expertdisplay.Barcode2DGenerator;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModel;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayUtil;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertFormItem;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.failure.InvalidModelItemKeyException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class Barcode2DContainerItem
extends ExpertDisplayModelItem
implements ExpertFormItem.FormElement {
    private int x;
    private int y;
    private int width;
    private int height;
    private int length;
    private int errorCorrection;
    private int rowHeight;
    private int type;
    private int rows;
    private int columns;
    private float aspectRatio;
    private ExpertDisplayInfoDTO.ColorDTO bgColor;
    private List barcodes;
    private Barcode2DGenerator generator;
    static /* synthetic */ Class class$ch$dvbern$tax$common$engine$expertdisplay$Barcode2DContainerItem;

    public Barcode2DContainerItem(int x, int y, int width, int height, ExpertDisplayInfoDTO.ColorDTO bgColor, List barcodes, int length, int errorCorrection, float aspectRatio, int rowHeight, int type, int columns, int rows, Barcode2DGenerator generator, Set languages) {
        super(languages, 1, false);
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.bgColor = bgColor;
        this.barcodes = barcodes;
        this.length = length;
        this.errorCorrection = errorCorrection;
        this.aspectRatio = aspectRatio;
        this.rowHeight = rowHeight;
        this.generator = generator;
        this.type = type;
        this.rows = rows;
        this.columns = columns;
    }

    public List getChildren() {
        return Collections.EMPTY_LIST;
    }

    public ExpertDisplayInfoDTO.ItemDTO getItemDTO(ExpertDisplayModel.RequestContext requestContext) throws InvalidModelItemKeyException {
        byte[] data = this.generator.generateData(requestContext);
        byte[] id = this.generator.generateId(requestContext);
        byte contentType = this.generator.getContentType();
        return new ExpertDisplayInfoDTO.Barcode2DContainerDTO(this.x, this.y, this.width, this.height, this.bgColor, data, this.barcodes, this.length, this.errorCorrection, this.aspectRatio, this.rowHeight, this.type, this.columns, this.rows, id, contentType, this.getUniqueItemIdentifier());
    }

    public static class XMLFactory
    implements ElementParser {
        public ClassObjectPair parse(Element element, ParserFactory factory) throws ElementParserException {
            ArrayList<Object> barcodes = new ArrayList<Object>();
            Barcode2DGenerator generator = null;
            Iterator i = element.getChildren().iterator();
            while (i.hasNext()) {
                Element subElement = (Element)i.next();
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof ExpertDisplayInfoDTO.Barcode2DDTO) {
                        barcodes.add(ref);
                        continue;
                    }
                    if (ref instanceof Barcode2DGenerator) {
                        generator = (Barcode2DGenerator)ref;
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + ref);
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), pnre);
                }
            }
            int type = 2;
            String typeStr = element.getAttributeValue("type").toLowerCase();
            if ("macropdf417".equals(typeStr)) {
                type = 1;
            }
            return new ClassObjectPair(class$ch$dvbern$tax$common$engine$expertdisplay$Barcode2DContainerItem == null ? (class$ch$dvbern$tax$common$engine$expertdisplay$Barcode2DContainerItem = Barcode2DContainerItem.class$("ch.dvbern.tax.common.engine.expertdisplay.Barcode2DContainerItem")) : class$ch$dvbern$tax$common$engine$expertdisplay$Barcode2DContainerItem, new Barcode2DContainerItem(ExpertDisplayUtil.toPixel(element.getAttributeValue("x")), ExpertDisplayUtil.toPixel(element.getAttributeValue("y")), ExpertDisplayUtil.toPixel(element.getAttributeValue("width")), ExpertDisplayUtil.toPixel(element.getAttributeValue("height")), ExpertDisplayUtil.parseColor(element.getAttributeValue("bgColor")), barcodes, ExpertDisplayUtil.getInt(element.getAttributeValue("length"), 800), ExpertDisplayUtil.getInt(element.getAttributeValue("errorCorrection"), 5), ExpertDisplayUtil.getFloat(element.getAttributeValue("aspectRatio"), 1.2f), ExpertDisplayUtil.getInt(element.getAttributeValue("rowHeight"), 3), type, ExpertDisplayUtil.getInt(element.getAttributeValue("columns"), 0), ExpertDisplayUtil.getInt(element.getAttributeValue("rows"), 0), generator, ExpertDisplayUtil.parseLanguages(element.getAttributeValue("lang"))));
        }
    }
}

