/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.calcitems;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.DataResource;
import ch.dvbern.tax.common.engine.DataResourceImpl;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import java.lang.reflect.Constructor;
import org.apache.log4j.Logger;

public class Constant
implements CalcItem {
    private Object value;
    private String key;
    private Class clazz;
    private DataResource dataResource;
    private static final Logger log = Logger.getLogger((Class)Constant.class);
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Double;

    public Constant(Object value, String key, Class clazz, DataResource dataResource) {
        this.value = value;
        this.key = key;
        this.clazz = clazz;
        this.dataResource = dataResource;
    }

    public Object getValue() {
        return this.value;
    }

    public void evaluate(LogicModelItem.ProtectedMap model, FastStack stack, String dataModelKey) {
        if (this.key != null) {
            String sValue = (String)this.dataResource.get("constants", null, null).get(this.key);
            if (sValue == null) {
                log.error((Object)("key " + this.key + " not found in constants.txt"));
                stack.push(null);
                return;
            }
            try {
                Constructor constructor = this.clazz.getConstructor(String.class);
                this.value = constructor.newInstance(sValue);
            }
            catch (Throwable t) {
                log.error((Object)("could not convert constant-value " + sValue + " to given class " + this.clazz), t);
                stack.push(null);
                return;
            }
        }
        stack.push(this.value);
    }

    public static class XMLFactory
    implements ElementParser {
        private DataResource dataResource;

        public XMLFactory(DataResource dataResource) {
            this.dataResource = dataResource;
        }

        public ClassObjectPair parse(Element element, ParserFactory factory) throws ElementParserException {
            String sValue = element.getAttributeValue("value");
            String sKey = element.getAttributeValue("key");
            if (sValue == null && sKey == null || sValue != null && sKey != null) {
                throw new ElementParserException("either value or key must be specified, concernes CalcItem " + element.getParent().getAttributeValue("name"));
            }
            Class clazz = null;
            if (element.getAttributeValue("class") != null) {
                try {
                    clazz = Class.forName(element.getAttributeValue("class"));
                }
                catch (ClassNotFoundException cnfe) {
                    throw new ElementParserException(cnfe);
                }
            } else {
                Class clazz2 = sValue.indexOf(".") == -1 ? (class$java$lang$Long == null ? (class$java$lang$Long = Constant.class$("java.lang.Long")) : class$java$lang$Long) : (class$java$lang$Double == null ? (class$java$lang$Double = Constant.class$("java.lang.Double")) : class$java$lang$Double);
                clazz = clazz2;
            }
            DataResourceImpl ds = null;
            Object value = null;
            if (sKey != null) {
                ds = new DataResourceImpl(this.dataResource, element.getAttributeValue("code"));
            } else {
                try {
                    Constructor constructor = clazz.getConstructor(class$java$lang$String == null ? (class$java$lang$String = Constant.class$("java.lang.String")) : class$java$lang$String);
                    value = constructor.newInstance(sValue);
                }
                catch (Throwable t) {
                    throw new ElementParserException(t);
                }
            }
            return new ClassObjectPair(class$ch$dvbern$tax$common$engine$calcitems$Constant == null ? (class$ch$dvbern$tax$common$engine$calcitems$Constant = Constant.class$("ch.dvbern.tax.common.engine.calcitems.Constant")) : class$ch$dvbern$tax$common$engine$calcitems$Constant, new Constant(value, sKey, clazz, ds));
        }
    }
}

