/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class TranslationChecker
extends Task {
    private String command = null;
    private String source = null;
    private String bundle = null;
    private String reference = null;
    private String[] sources = null;
    private String bundle_used = null;
    private String bundle_unused = null;
    private String bundle_untranslated = null;

    public static void main(String[] args) {
        try {
            TranslationChecker checker = new TranslationChecker();
            checker.setCommand("extractKeys");
            checker.setSource("src/model/be/01_stammdaten/stammdaten.logic.xml");
            checker.setBundle("config/be/common/resources/resources_de.properties");
            checker.initFiles();
            checker.execute();
            checker.setCommand("extractUnusedKeys");
            checker.execute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initFiles() throws IOException {
        this.bundle_used = this.bundle.substring(0, this.bundle.lastIndexOf(".")) + "_used.properties";
        this.bundle_unused = this.bundle.substring(0, this.bundle.lastIndexOf(".")) + "_unused.properties";
        this.bundle_untranslated = this.bundle.substring(0, this.bundle.lastIndexOf(".")) + "_untranslated.properties";
        File usedFile = new File(this.bundle_used);
        File unusedFile = new File(this.bundle_unused);
        File untranslatedFile = new File(this.bundle_untranslated);
        try {
            if (!usedFile.exists()) {
                usedFile.createNewFile();
            }
            if (!unusedFile.exists()) {
                unusedFile.createNewFile();
            }
            if (!untranslatedFile.exists()) {
                untranslatedFile.createNewFile();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IOException();
        }
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public void setSource(String source) {
        this.source = source;
        StringTokenizer tokenizer = new StringTokenizer(source, ",");
        this.sources = new String[tokenizer.countTokens()];
        for (int i = 0; i < this.sources.length; ++i) {
            this.sources[i] = tokenizer.nextToken().trim();
        }
    }

    public void setBundle(String bundle) {
        this.bundle = bundle;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public void execute() throws BuildException {
        block14: {
            super.execute();
            try {
                this.initFiles();
                if ("extractKeys".equalsIgnoreCase(this.command)) {
                    if (this.source != null && this.bundle != null) {
                        this.extractAllKeys();
                        break block14;
                    }
                    throw new BuildException("missing source and/or bundle arguments!");
                }
                if ("cleanupBundle".equalsIgnoreCase(this.command)) {
                    if (this.bundle != null && this.reference != null) {
                        this.cleanupBundle();
                        break block14;
                    }
                    throw new BuildException("missing bundle and/or reference arguments!");
                }
                if ("bundleInfo".equalsIgnoreCase(this.command)) {
                    if (this.bundle != null) {
                        this.bundleInfo();
                        break block14;
                    }
                    throw new BuildException("missing bundle argument!");
                }
                if ("bundleDiff".equalsIgnoreCase(this.command)) {
                    if (this.bundle != null && this.reference != null) {
                        this.bundleDiff();
                        break block14;
                    }
                    throw new BuildException("missing bundle and/or reference arguments!");
                }
                if ("bundleMerge".equalsIgnoreCase(this.command)) {
                    if (this.bundle != null && this.reference != null) {
                        this.bundleMerge();
                        break block14;
                    }
                    throw new BuildException("missing bundle and/or reference arguments!");
                }
                if ("extractUnusedKeys".equalsIgnoreCase(this.command)) {
                    if (this.bundle != null) {
                        this.searchForUnusedKeys();
                        break block14;
                    }
                    throw new BuildException("missing source and/or bundle arguments!");
                }
                throw new BuildException("missing command argument ('extractKeys' or 'cleanupBundle')!");
            }
            catch (Throwable t) {
                throw new BuildException(t);
            }
        }
    }

    private void extractAllKeys() throws Exception {
        Properties propUsed = new Properties();
        Properties propUntranslated = new Properties();
        File bundleFile = new File(this.bundle.replace('\\', '/'));
        Properties properties = new Properties();
        properties.load(new BufferedInputStream(new FileInputStream(bundleFile.getAbsoluteFile())));
        for (int i = 0; i < this.sources.length; ++i) {
            String source = this.sources[i];
            System.out.println("extracting source: " + source);
            File sourceFile = new File(source.replace('\\', '/'));
            this.searchForUntranslatedStrings(sourceFile, properties, propUntranslated, propUsed);
        }
        System.out.println("Nbr of untranslated keys: " + propUntranslated.size());
        File untranslatedFile = new File(this.bundle_untranslated);
        propUntranslated.store(new BufferedOutputStream(new FileOutputStream(untranslatedFile)), "untranslated keys");
        File usedFile = new File(this.bundle_used);
        propUsed.store(new BufferedOutputStream(new FileOutputStream(usedFile)), "generated resource file with only used keys");
    }

    private void searchForUnusedKeys() throws Exception {
        File usedFile = new File(this.bundle_used);
        Properties propUsed = new Properties();
        propUsed.load(new BufferedInputStream(new FileInputStream(usedFile.getAbsoluteFile())));
        Properties propUnused = new Properties();
        File bundleFile = new File(this.bundle.replace('\\', '/'));
        Properties properties = new Properties();
        properties.load(new BufferedInputStream(new FileInputStream(bundleFile.getAbsoluteFile())));
        System.out.println("Nbr of used keys: " + propUsed.keySet().size());
        System.out.println("Nbr of keys in resources.properties: " + properties.keySet().size());
        Iterator<Object> iter = properties.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (propUsed.containsKey(key)) continue;
            propUnused.put(key, "");
        }
        System.out.println("Nbr of unused keys: " + propUnused.keySet().size());
        File newUnusedFile = new File(this.bundle_unused);
        propUnused.store(new BufferedOutputStream(new FileOutputStream(newUnusedFile)), "generated: unused keys");
    }

    private void searchForUntranslatedStrings(File file, Properties properties, Properties propUntranslated, Properties propUsed) throws Exception {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int j = 0; j < files.length; ++j) {
                File f = files[j].getAbsoluteFile();
                this.searchForUntranslatedStrings(f, properties, propUntranslated, propUsed);
            }
        } else {
            InputStreamReader fr;
            try {
                fr = new InputStreamReader(new GZIPInputStream(new BufferedInputStream(new FileInputStream(file))));
            }
            catch (Exception ze) {
                fr = new InputStreamReader(new BufferedInputStream(new FileInputStream(file)));
            }
            StringBuffer data = new StringBuffer();
            char[] buffer = new char[8192];
            int len = fr.read(buffer);
            while (len > -1) {
                data.append(buffer, 0, len);
                len = fr.read(buffer);
            }
            Iterator iter = this.initRegexList().iterator();
            while (iter.hasNext()) {
                String regex = (String)iter.next();
                Pattern pattern = Pattern.compile(regex);
                Matcher matcher = pattern.matcher(data);
                while (matcher.find()) {
                    String key = matcher.group(1);
                    String value = properties.getProperty(key);
                    if (value != null) {
                        propUsed.put(key, value);
                    } else {
                        propUsed.put(key, "");
                    }
                    if (value != null && value.length() > 0 && !value.startsWith("?") && !value.startsWith("!")) continue;
                    propUntranslated.put(key, "");
                }
            }
            fr.close();
        }
    }

    private List initRegexList() {
        ArrayList<String> regexList = new ArrayList<String>();
        regexList.add(".*<module.*title=\\\"([^\\\"]*)\\\".*");
        regexList.add(".*<optionItem.*id=\\\"([^\\\"]*)\\\".*");
        regexList.add(".*<button.*name=\\\"([^\\\"]*)\\\".*");
        regexList.add(".*<form.*header=\\\"([^\\\"]*)\\\".*");
        regexList.add(".*<header.*name=\\\"([^\\\"]*)\\\".*");
        regexList.add(".*<header-add-on.*name=\\\"([^\\\"]*)\\\".*");
        regexList.add(".*<help.*id=\\\"([^\\\"]*)\\\".*");
        regexList.add(".*<label.*name=\\\"([^\\\"]*)\\\".*");
        regexList.add(".*<dm-table.*header=\\\"([^\\\"]*)\\\".*");
        regexList.add(".*<section.*help=\\\"([^\\\"]*)\\\".*");
        regexList.add(".*<dm-table.*help=\\\"([^\\\"]*)\\\".*");
        regexList.add(".*<mandatory.*[^\\-]message=\\\"([^\\\"]*)\\\".*");
        regexList.add(".*<max.*[^\\-]message=\\\"([^\\\"]*)\\\".*");
        regexList.add(".*<min.*[^\\-]message=\\\"([^\\\"]*)\\\".*");
        regexList.add(".*<delete-if-false.*[^\\-]message=\\\"([^\\\"]*)\\\".*");
        regexList.add(".*<delete-if-true.*[^\\-]message=\\\"([^\\\"]*)\\\".*");
        regexList.add(".*<not-negative.*[^\\-]message=\\\"([^\\\"]*)\\\".*");
        regexList.add(".*<tmo:button.*key=\\\"([^${][^\\\"]*[^}])\\\".*");
        regexList.add(".*<fmt:message.*key=\\\"([^${][^\\\"]*[^}])\\\".*");
        regexList.add(".*<tmo:message.*key=\\\"([^${][^\\\"]*[^}])\\\".*");
        regexList.add(".*<tmo:label.*key=\\\"([^${][^\\\"]*[^}])\\\".*");
        regexList.add(".*Messages.getString\\(\\\"([^\\\"]*)\\.*");
        regexList.add(".*Messages.getStringWithoutTranslation\\(\\\"([^\\\"]*)\\\"\\).*");
        return regexList;
    }

    private void cleanupBundle() throws Exception {
        File bundleFile = new File(this.bundle.replace('\\', '/'));
        File referenceFile = new File(this.reference.replace('\\', '/'));
        Properties properties = new Properties();
        properties.load(new BufferedInputStream(new FileInputStream(bundleFile.getAbsoluteFile())));
        Properties referenceProperties = new Properties();
        referenceProperties.load(new BufferedInputStream(new FileInputStream(referenceFile.getAbsoluteFile())));
        Properties newProperties = new Properties();
        Iterator<Map.Entry<Object, Object>> i = properties.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<Object, Object> me = i.next();
            Object k = me.getKey();
            Object v = me.getValue();
            if (v != null && v.toString().length() > 0 && v.equals(referenceProperties.get(k))) {
                System.out.println("identical bundle entry removed from resource file: " + v);
                continue;
            }
            if (v == null || v.toString().length() == 0) {
                System.out.println("empty resource bundle entry: " + k);
                newProperties.put(k, v);
                continue;
            }
            newProperties.put(k, v);
        }
        File newBundle = new File(this.bundle);
        System.out.println("\nresource bundle file cleaned up: " + newBundle.getName());
        newProperties.store(new BufferedOutputStream(new FileOutputStream(newBundle)), "generated resource bundle file");
    }

    private void bundleInfo() throws Exception {
        File bundleFile = new File(this.bundle.replace('\\', '/'));
        Properties properties = new Properties();
        properties.load(new BufferedInputStream(new FileInputStream(bundleFile.getAbsoluteFile())));
        System.out.println("number of entries in bundle file: " + properties.size() + "\n");
        System.out.println("empty properties in bundle file:");
        Iterator<Map.Entry<Object, Object>> i = properties.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<Object, Object> me = i.next();
            Object k = me.getKey();
            Object v = me.getValue();
            if (v != null && v.toString().length() != 0) continue;
            System.out.println(k + "=");
        }
    }

    private void bundleDiff() throws Exception {
        Object o;
        Object v;
        Object k;
        Map.Entry<Object, Object> me;
        File bundleFile = new File(this.bundle.replace('\\', '/'));
        File referenceFile = new File(this.reference.replace('\\', '/'));
        Properties properties = new Properties();
        properties.load(new BufferedInputStream(new FileInputStream(bundleFile.getAbsoluteFile())));
        Properties referenceProperties = new Properties();
        referenceProperties.load(new BufferedInputStream(new FileInputStream(referenceFile.getAbsoluteFile())));
        System.out.println("new entries in reference file:");
        Iterator<Map.Entry<Object, Object>> i = referenceProperties.entrySet().iterator();
        while (i.hasNext()) {
            me = i.next();
            k = me.getKey();
            v = me.getValue();
            o = properties.get(k);
            if (o != null) continue;
            System.out.println(k + "=" + v);
        }
        System.out.println("\nchanged entries:");
        i = properties.entrySet().iterator();
        while (i.hasNext()) {
            me = i.next();
            k = me.getKey();
            v = me.getValue();
            o = referenceProperties.get(k);
            if (o == null || v.equals(o)) continue;
            System.out.println("bundle key: " + k);
            System.out.println("  bundle:    " + v);
            System.out.println("  reference: " + o);
        }
    }

    private void bundleMerge() throws Exception {
        File bundleFile = new File(this.bundle.replace('\\', '/'));
        File referenceFile = new File(this.reference.replace('\\', '/'));
        Properties properties = new Properties();
        properties.load(new BufferedInputStream(new FileInputStream(bundleFile.getAbsoluteFile())));
        Properties referenceProperties = new Properties();
        referenceProperties.load(new BufferedInputStream(new FileInputStream(referenceFile.getAbsoluteFile())));
        Iterator<Map.Entry<Object, Object>> i = referenceProperties.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<Object, Object> me = i.next();
            Object k = me.getKey();
            Object v = me.getValue();
            Object o = properties.get(k);
            if (o == null) {
                properties.put(k, v);
                System.out.println("added: " + k + "=" + v);
                continue;
            }
            if (o.equals(v)) continue;
            properties.put(k, v);
            System.out.println("changed: " + k + "=" + v);
        }
        File newBundle = new File(this.bundle);
        System.out.println("\nresources merged in bundle file: " + newBundle.getName());
        properties.store(new BufferedOutputStream(new FileOutputStream(newBundle)), "generated resource bundle file");
    }
}

