/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine;

import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.ModelChangeListener;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class Reference {
    protected String name;
    private boolean relativeReference;
    private LogicModelItem reference;

    public Reference(String name, boolean relativeReference) {
        this.name = name;
        this.relativeReference = relativeReference;
    }

    public String getName() {
        return this.name;
    }

    public String initializeReference(Map logicModel, LogicModelItem logicModelItem, boolean referenceIntoTables) throws InvalidModelException {
        String rToken;
        if (this.relativeReference) {
            LogicModelItem lmi;
            LogicModelItem logicModelItem2 = lmi = logicModelItem instanceof LogicModelItem.ModuleItem ? logicModelItem : logicModelItem.getParent();
            while (this.name.startsWith(".") && lmi != null) {
                lmi = lmi.getParent();
                this.name = this.name.substring(1);
            }
            StringBuffer absName = new StringBuffer(lmi != null ? lmi.getName() : "");
            if (absName.length() > 0) {
                absName.append('.');
            }
            absName.append(this.name);
            this.name = absName.toString();
        }
        StringBuffer listenerName = new StringBuffer();
        StringBuffer referenceName = new StringBuffer();
        StringTokenizer stListener = new StringTokenizer(logicModelItem.getName(), ".");
        StringTokenizer stReference = new StringTokenizer(this.name, ".");
        String lToken = stListener.hasMoreTokens() ? stListener.nextToken() : null;
        String string = rToken = stReference.hasMoreTokens() ? stReference.nextToken() : null;
        while (lToken != null && rToken != null && lToken.equals(rToken)) {
            if (listenerName.length() > 0) {
                listenerName.append('.');
            }
            listenerName.append(lToken);
            if (referenceName.length() > 0) {
                referenceName.append('.');
            }
            referenceName.append(rToken);
            lToken = stListener.hasMoreTokens() ? stListener.nextToken() : null;
            rToken = stReference.hasMoreTokens() ? stReference.nextToken() : null;
        }
        if (lToken != null) {
            if (listenerName.length() > 0) {
                listenerName.append('.');
            }
            listenerName.append(lToken);
            String string2 = lToken = stListener.hasMoreTokens() ? stListener.nextToken() : null;
        }
        while (lToken != null) {
            LogicModelItem lmi = (LogicModelItem)logicModel.get(listenerName.toString().replace('#', '.'));
            if (lmi instanceof LogicModelItem.TableItem) {
                listenerName.append('#');
            } else {
                listenerName.append('.');
            }
            listenerName.append(lToken);
            lToken = stListener.hasMoreTokens() ? stListener.nextToken() : null;
        }
        while (rToken != null) {
            if (referenceName.length() > 0) {
                referenceName.append('.');
            }
            referenceName.append(rToken);
            String string3 = rToken = stReference.hasMoreTokens() ? stReference.nextToken() : null;
            if (referenceIntoTables || rToken == null || !(logicModel.get(EngineUtil.removeTableIndices(referenceName.toString())) instanceof LogicModelItem.TableItem)) continue;
            throw new InvalidModelException("invalid reference into table (" + this.name + ") in " + logicModelItem.getName());
        }
        this.reference = (LogicModelItem)logicModel.get(referenceName.toString());
        if (this.reference == null) {
            throw new InvalidModelException("invalid reference (" + this.name + ") in " + logicModelItem.getName());
        }
        return listenerName.toString();
    }

    public LogicModelItem getReference() {
        return this.reference;
    }

    public void registerListenerOnReference(Map logicModel, LogicModelItem logicModelItem, boolean referenceIntoTables) throws InvalidModelException {
        String listenerName = this.initializeReference(logicModel, logicModelItem, referenceIntoTables);
        if (listenerName.toString().indexOf("#") != -1) {
            this.reference.addDataModelListener(new TableDataChangeListener(listenerName, logicModelItem));
        } else {
            this.reference.addDataModelListener(logicModelItem);
        }
    }

    private class TableDataChangeListener
    implements ModelChangeListener {
        private String keyWithHash;
        private LogicModelItem item;

        public TableDataChangeListener(String keyWithHash, LogicModelItem item) {
            this.keyWithHash = keyWithHash;
            this.item = item;
        }

        public void dataChanged(LogicModelItem.ProtectedMap dataModel, String dataModelKey, ModelItemDTO oldValue, ModelItemDTO newValue, String changedEventsOnlyOutsideOfThisTable) {
            ArrayList elements = new ArrayList();
            this.substituteHashes(dataModel, elements, EngineUtil.mergeModelKey(this.keyWithHash, dataModelKey));
            Iterator iterator = elements.iterator();
            while (iterator.hasNext()) {
                String element = (String)iterator.next();
                this.item.dataChanged(dataModel, element, oldValue, newValue, changedEventsOnlyOutsideOfThisTable);
            }
        }

        private void substituteHashes(LogicModelItem.ProtectedMap dataModel, List keys, String key) {
            int p = key.indexOf(35);
            if (p != -1) {
                ModelItemDTO mi = dataModel.get(key.substring(0, p));
                if (mi != null && mi.getValue() != null) {
                    Iterator i = ((Collection)mi.getValue()).iterator();
                    while (i.hasNext()) {
                        this.substituteHashes(dataModel, keys, key.substring(0, p) + "." + i.next() + "." + key.substring(p + 1));
                    }
                }
            } else {
                keys.add(key);
            }
        }

        public void stateChanged(LogicModelItem.ProtectedMap dataModel, String dataModelKey, ModelItemDTO oldValue, ModelItemDTO newValue, String changedEventsOnlyOutsideOfThisTable) {
        }

        public String getName() {
            return Reference.this.name;
        }
    }
}

