/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine;

import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.ModelChangeListener;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.MessageItemDTO;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.PersistenceReadDTO;
import ch.dvbern.tax.common.transfer.dto.PersistenceWriteDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public abstract class LogicModelItem
implements ModelChangeListener {
    private static final Logger log = Logger.getLogger((Class)LogicModelItem.class);
    private static final int IMPORT_NO_CASE = 0;
    private static final int IMPORT_EMPTY_CASE_ONLY = 1;
    private static final int IMPORT_ALL_CASES = 2;
    private String name;
    private String nameWithTableIndexShapes;
    private List children;
    private LogicModelItem parent;
    private Set modelChangeListeners;
    private List validators;
    private List persistenceKeyTemplates;
    private LogicModelItem previousItem;
    private LogicModelItem nextItem;
    private boolean readonly;
    private int importPrevious;
    private boolean readonlyIfTransparent;

    public LogicModelItem(String name, List children, String persistenceKeyTemplate, boolean readonly, String importPrevious, boolean readonlyIfTransparent) {
        this.name = name;
        this.children = children;
        if (children != null) {
            Iterator i = children.iterator();
            while (i.hasNext()) {
                ((LogicModelItem)i.next()).setParent(this);
            }
        }
        this.persistenceKeyTemplates = new ArrayList();
        if (persistenceKeyTemplate != null) {
            StringTokenizer tokenizer = new StringTokenizer(persistenceKeyTemplate, ",");
            while (tokenizer.hasMoreTokens()) {
                this.persistenceKeyTemplates.add(tokenizer.nextToken().trim());
            }
        }
        this.readonly = readonly;
        this.readonlyIfTransparent = readonlyIfTransparent;
        this.importPrevious = 0;
        if (importPrevious != null) {
            if ((importPrevious = importPrevious.toLowerCase()).indexOf("emptycase") >= 0) {
                this.importPrevious = 1;
            } else if ("true".equals(importPrevious)) {
                this.importPrevious = 2;
            }
        }
    }

    public final String getName() {
        return this.name;
    }

    public final String getNameWithTableIndexShapes() {
        return this.nameWithTableIndexShapes;
    }

    public final LogicModelItem getParent() {
        return this.parent;
    }

    public final List getChildren() {
        return this.children;
    }

    public final LogicModelItem getPreviousItem() {
        return this.previousItem;
    }

    public final LogicModelItem getNextItem() {
        return this.nextItem;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public boolean isReadonlyIfTransparent() {
        return this.readonlyIfTransparent;
    }

    public boolean isImportable(boolean preinitializedCase) {
        if (this.importPrevious == 0) {
            return false;
        }
        if (this.importPrevious == 1) {
            return !preinitializedCase;
        }
        return this.importPrevious == 2;
    }

    public final void addDataModelListener(ModelChangeListener aListener) {
        if (this.modelChangeListeners == null) {
            this.modelChangeListeners = new HashSet();
        }
        this.modelChangeListeners.add(aListener);
    }

    public final void addValidator(Validator validator) {
        if (this.validators == null) {
            this.validators = new ArrayList();
        }
        this.validators.add(validator);
    }

    public final LogicModelItem initializeLogicModel(Map logicModelItems, List persistenceReadDTOs, String itemPath, int tables, LogicModelItem previous, Map persistenceKeys) throws InvalidModelException {
        String completeNameWithoutShapes;
        StringBuffer itemPathWithoutShapes = new StringBuffer();
        String[] sArray = itemPath.split(".#");
        for (int i = 0; i < sArray.length; ++i) {
            itemPathWithoutShapes.append(sArray[i]);
        }
        if (this.name == null || this.name.length() == 0) {
            throw new InvalidModelException("invalid model item name in " + itemPathWithoutShapes);
        }
        this.nameWithTableIndexShapes = itemPath.length() > 0 ? itemPath + "." + this.name : this.name;
        String string = completeNameWithoutShapes = itemPathWithoutShapes.length() > 0 ? itemPathWithoutShapes + "." + this.name : this.name;
        if (this.name.indexOf(46) != -1) {
            throw new InvalidModelException("invalid character (.) in " + completeNameWithoutShapes);
        }
        if (this.name.indexOf(35) != -1) {
            throw new InvalidModelException("invalid character (#) in " + completeNameWithoutShapes);
        }
        if (this.name.charAt(0) >= '0' && this.name.charAt(0) <= '9') {
            throw new InvalidModelException("invalid name (initial digit) in " + completeNameWithoutShapes);
        }
        this.name = completeNameWithoutShapes;
        if (logicModelItems.containsKey(this.name)) {
            throw new InvalidModelException("duplicate logic model item: " + this.name);
        }
        logicModelItems.put(this.name, this);
        Iterator iter = this.persistenceKeyTemplates.iterator();
        while (iter.hasNext()) {
            String persistenceKeyTemplate = (String)iter.next();
            if (persistenceKeys != null) {
                if (persistenceKeys.containsKey(persistenceKeyTemplate)) {
                    System.out.println("warning: duplicate persistence keys in " + this.name + " and " + (String)persistenceKeys.get(persistenceKeyTemplate) + " (" + persistenceKeyTemplate + ")");
                } else {
                    persistenceKeys.put(persistenceKeyTemplate, this.name);
                }
            }
            int sharpCount = 0;
            int p = persistenceKeyTemplate.indexOf(35);
            while (p >= 0) {
                p = persistenceKeyTemplate.indexOf(35, p + 1);
                ++sharpCount;
            }
            if (sharpCount != tables) {
                throw new InvalidModelException("invalid pKey (wrong # count) in " + completeNameWithoutShapes);
            }
            persistenceReadDTOs.add(new PersistenceReadDTO(this.nameWithTableIndexShapes, persistenceKeyTemplate, this.isImportable(true)));
        }
        if (this instanceof ModuleItem) {
            this.previousItem = previous;
            if (previous != null) {
                previous.setNextModelItem(this);
            }
            previous = this;
        }
        if (this.children != null) {
            Iterator i = this.children.iterator();
            while (i.hasNext()) {
                int t = this instanceof TableItem ? tables + 1 : tables;
                String s = this.nameWithTableIndexShapes + (this instanceof TableItem ? ".#" : "");
                LogicModelItem childItem = (LogicModelItem)i.next();
                if (childItem instanceof TableItem) {
                    childItem.initializeLogicModel(logicModelItems, persistenceReadDTOs, s, t, null, persistenceKeys);
                    continue;
                }
                previous = childItem.initializeLogicModel(logicModelItems, persistenceReadDTOs, s, t, previous, persistenceKeys);
            }
        }
        return previous;
    }

    public final void initializeReferences(Map logicModel) throws InvalidModelException {
        Iterator i;
        if (this.children != null) {
            i = this.children.iterator();
            while (i.hasNext()) {
                ((LogicModelItem)i.next()).initializeReferences(logicModel);
            }
        }
        if (this.validators != null) {
            i = this.validators.iterator();
            while (i.hasNext()) {
                ((Validator)i.next()).initializeReferences(logicModel, this);
            }
        }
        this.additionalInitializeReferences(logicModel);
    }

    protected void additionalInitializeReferences(Map logicModel) throws InvalidModelException {
    }

    public void dataChanged(ProtectedMap dataModel, String dataModelKey, ModelItemDTO oldValue, ModelItemDTO newValue, String changedEventsOnlyOutsideOfThisTable) {
        this.dataChangedWithConditionalActiveValidation(dataModel, dataModelKey, oldValue, newValue, changedEventsOnlyOutsideOfThisTable, true);
    }

    protected void dataChangedWithConditionalActiveValidation(ProtectedMap dataModel, String dataModelKey, ModelItemDTO oldValue, ModelItemDTO newValue, String changedEventsOnlyOutsideOfThisTable, boolean activeValidation) {
        String dmk = EngineUtil.mergeModelKey(this.getName(), dataModelKey);
        if (changedEventsOnlyOutsideOfThisTable != null && dmk.startsWith(changedEventsOnlyOutsideOfThisTable)) {
            return;
        }
        ModelItemDTO oldDTO = dataModel.get(dmk);
        ModelItemDTO dto = oldDTO;
        if (dto == null) {
            dto = new ModelItemDTO();
        }
        ModelItemDTO newDTO = this.validateItemValue(dataModel, dmk, dto);
        if (!activeValidation && !dto.valueIsEqual(newDTO)) {
            newDTO = newDTO.clone(dto.getValue());
        }
        dataModel.put(this, dmk, newDTO, this.persistenceKeyTemplates, oldDTO);
        this.updateItemStates(dataModel, dmk, newDTO.getState(), newDTO, oldDTO);
        if (!newDTO.valueIsEqual(oldDTO)) {
            this.fireDataChangedEvent(dataModel, dmk, oldDTO, newDTO, changedEventsOnlyOutsideOfThisTable);
        }
        if (oldDTO == null || newDTO.getState() != oldDTO.getState()) {
            this.fireStateChangedEvent(dataModel, dmk, oldDTO, newDTO, changedEventsOnlyOutsideOfThisTable);
        }
    }

    public void stateChanged(ProtectedMap dataModel, String dataModelKey, ModelItemDTO oldValue, ModelItemDTO newValue, String changedEventsOnlyOutsideOfThisTable) {
    }

    public void setValue(ProtectedMap dataModel, String dataModelKey, ModelItemDTO modelItemDTO, String changedEventsOnlyOutsideOfThisTable) {
        this.setValueWithOptionalValidation(dataModel, dataModelKey, modelItemDTO, changedEventsOnlyOutsideOfThisTable, true, true);
    }

    protected void setValueWithOptionalValidation(ProtectedMap dataModel, String dataModelKey, ModelItemDTO modelItemDTO, String changedEventsOnlyOutsideOfThisTable, boolean validationRequired, boolean activeValidation) {
        this.updateTableIndices(dataModel, dataModelKey);
        ModelItemDTO oldDTO = dataModel.get(dataModelKey);
        if (this instanceof TableItem) {
            if (EngineUtil.endsWithTableIndex(dataModelKey)) {
                return;
            }
            if (oldDTO != null && oldDTO.getValue() instanceof Set && ((Set)oldDTO.getValue()).size() > 0) {
                return;
            }
        }
        ModelItemDTO newDTO = modelItemDTO;
        if (validationRequired) {
            newDTO = this.validateItemValue(dataModel, dataModelKey, modelItemDTO);
            if (!activeValidation && !modelItemDTO.valueIsEqual(newDTO)) {
                newDTO = newDTO.clone(modelItemDTO.getValue());
            }
        }
        dataModel.put(this, dataModelKey, newDTO, this.persistenceKeyTemplates, oldDTO);
        this.updateItemStates(dataModel, dataModelKey, newDTO.getState(), newDTO, oldDTO);
        if (!newDTO.valueIsEqual(oldDTO)) {
            this.fireDataChangedEvent(dataModel, dataModelKey, oldDTO, newDTO, changedEventsOnlyOutsideOfThisTable);
        }
        if (oldDTO == null || newDTO.getState() != oldDTO.getState()) {
            this.fireStateChangedEvent(dataModel, dataModelKey, oldDTO, newDTO, changedEventsOnlyOutsideOfThisTable);
        }
    }

    public final boolean deleteValue(ProtectedMap dataModel, String dataModelKey) {
        boolean result = this.deleteSubValues(dataModel, dataModelKey, true, null);
        if (result) {
            int i;
            for (i = 0; this.deleteSubValues(dataModel, dataModelKey, true, null) && i < 10; ++i) {
            }
            if (i >= 10) {
                log.error((Object)("Loeschen abgebrochen. Stabilitaet wurde nach " + i + " Versuchen nicht erreicht."));
            }
        }
        if (this instanceof TableItem && EngineUtil.endsWithTableIndex(dataModelKey)) {
            String tableDMK = EngineUtil.removeLastKeyPart(dataModelKey);
            this.updateItemStates(dataModel, tableDMK, 1, null, null);
        } else if (this.parent != null) {
            String parentDMK = EngineUtil.mergeModelKey(this.parent.getName(), dataModelKey);
            this.parent.updateItemStates(dataModel, parentDMK, 1, null, null);
        }
        return result;
    }

    public final boolean deleteSubValues(ProtectedMap dataModel, String dataModelKey, boolean removeThisToo, String dataChangedEventsOnlyOutsideOfThisTable) {
        ModelItemDTO tableEntry;
        boolean isWholeTableDMK;
        boolean result = false;
        boolean bl = isWholeTableDMK = this instanceof TableItem && !EngineUtil.endsWithTableIndex(dataModelKey);
        if (this.getChildren() != null && !isWholeTableDMK) {
            Iterator i = this.getChildren().iterator();
            while (i.hasNext()) {
                LogicModelItem element = (LogicModelItem)i.next();
                String dceooott = dataChangedEventsOnlyOutsideOfThisTable;
                if (dceooott == null && this instanceof TableItem) {
                    dceooott = EngineUtil.mergeModelKey(this.getName(), dataModelKey);
                }
                String childDMK = EngineUtil.mergeModelKey(element.getName(), dataModelKey);
                result |= element.deleteSubValues(dataModel, childDMK, true, dceooott);
            }
        }
        if (isWholeTableDMK && (tableEntry = dataModel.get(dataModelKey)) != null && tableEntry.getValue() instanceof Set) {
            Iterator j = ((Set)tableEntry.getValue()).iterator();
            while (j.hasNext()) {
                String index = (String)j.next();
                result |= this.deleteSubValues(dataModel, dataModelKey + "." + index, true, null);
            }
        }
        if (removeThisToo) {
            String index;
            HashSet newValue;
            String tableDMK;
            ModelItemDTO tableDTO;
            ModelItemDTO oldDTO = dataModel.remove(dataModelKey, this.persistenceKeyTemplates);
            if (this instanceof TableItem && EngineUtil.endsWithTableIndex(dataModelKey) && (tableDTO = dataModel.get(tableDMK = EngineUtil.removeLastKeyPart(dataModelKey))) != null && tableDTO.getValue() != null && (newValue = new HashSet((Set)tableDTO.getValue())).remove(index = EngineUtil.getLastKeyPart(dataModelKey))) {
                dataModel.put(this, tableDMK, tableDTO.clone(newValue), this.persistenceKeyTemplates, tableDTO);
                Collection tableEventListeners = ((TableItem)((Object)this)).getTableEventListeners();
                if (tableEventListeners != null) {
                    Iterator i = tableEventListeners.iterator();
                    while (i.hasNext()) {
                        TableItem.TableEventListener listener = (TableItem.TableEventListener)i.next();
                        listener.onTableEntryRemove(this, dataModel, tableDMK, index);
                    }
                }
            }
            if (oldDTO != null) {
                String s;
                String dceooott = dataChangedEventsOnlyOutsideOfThisTable;
                if (dceooott == null && this instanceof TableItem && EngineUtil.endsWithTableIndex(s = EngineUtil.mergeModelKey(this.getName(), dataModelKey))) {
                    dceooott = s;
                }
                this.fireDataChangedEvent(dataModel, dataModelKey, oldDTO, null, dceooott);
                this.fireStateChangedEvent(dataModel, dataModelKey, oldDTO, null, dceooott);
                boolean moduleOrTable = this instanceof ModuleItem || this instanceof TableItem;
                return result || !this.readonly && !moduleOrTable && oldDTO.isTouched() && oldDTO.getValue() != null;
            }
        }
        return result;
    }

    protected boolean hasAnInitialGreenState() {
        return this instanceof ModuleItem || this.isReadonly();
    }

    protected ModelItemDTO getDefaultValue(ProtectedMap dataModel, String dataModelKey) {
        return null;
    }

    final void initializeDefaultValues(ProtectedMap dataModel, String dataModelKey) {
        String dmk;
        ModelItemDTO oldDTO;
        ModelItemDTO defaultValue = this.getDefaultValue(dataModel, dataModelKey);
        if (defaultValue != null && ((oldDTO = dataModel.get(dmk = EngineUtil.mergeModelKey(this.getName(), dataModelKey))) == null || oldDTO.getValue() == null && (!oldDTO.isTouched() || this.isReadonly()))) {
            ModelItemDTO newDTO = this.validateItemValue(dataModel, dmk, defaultValue);
            dataModel.put(this, dmk, newDTO, this.persistenceKeyTemplates, oldDTO);
            this.updateItemStates(dataModel, dmk, newDTO.getState(), newDTO, null);
            this.fireDataChangedEvent(dataModel, dmk, oldDTO, newDTO, null);
            this.fireStateChangedEvent(dataModel, dmk, oldDTO, newDTO, null);
        }
        if (this.children != null) {
            Iterator i = this.children.iterator();
            while (i.hasNext()) {
                LogicModelItem lmi = (LogicModelItem)i.next();
                if (lmi instanceof TableItem) {
                    String dmk2 = EngineUtil.mergeModelKey(lmi.getName(), dataModelKey);
                    ModelItemDTO tableDTO = dataModel.get(dmk2);
                    if (tableDTO == null || !(tableDTO.getValue() instanceof Set)) continue;
                    Iterator tableIterator = ((Set)tableDTO.getValue()).iterator();
                    while (tableIterator.hasNext()) {
                        lmi.initializeDefaultValues(dataModel, dmk2 + "." + tableIterator.next().toString());
                    }
                    continue;
                }
                lmi.initializeDefaultValues(dataModel, dataModelKey);
            }
        }
    }

    public final List getValidators() {
        return this.validators;
    }

    private ModelItemDTO validateItemValue(ProtectedMap dataModel, String dataModelKey, ModelItemDTO modelItemDTO) {
        Collection messages;
        int resultState;
        int initialState;
        int n = initialState = this.hasAnInitialGreenState() || modelItemDTO.isTouched() ? 1 : 3;
        if (initialState != 1 && EngineUtil.endsWithTableIndex(dataModelKey)) {
            initialState = 1;
        }
        ModelItemDTO result = modelItemDTO.clone(initialState, null);
        if (this.validators != null && this.validators.size() > 0) {
            Iterator i = this.validators.iterator();
            while (i.hasNext()) {
                Validator v = (Validator)i.next();
                ModelItemDTO newResult = v.validate(dataModel, dataModelKey, result);
                if (newResult == null) {
                    log.warn((Object)("Validator " + v.getClass().getName() + " returned a null value!"));
                    continue;
                }
                result = result.hasMoreImportantState(newResult.getState()) ? newResult.clone(result.getState()) : newResult;
            }
            if (!(dataModel.allowActiveValidations || this.isReadonly() || result.valueIsEqual(modelItemDTO))) {
                result = result.clone(modelItemDTO.getValue());
            }
        }
        if (((resultState = result.getState()) == 11 || resultState == 12) && (messages = result.getMessages()) != null && messages.size() > 0) {
            messages.clear();
        }
        return result;
    }

    final void fireDataChangedEvent(ProtectedMap dataModel, String dataModelKey, ModelItemDTO oldValue, ModelItemDTO newValue, String changedEventsOnlyOutsideOfThisTable) {
        try {
            if (this.modelChangeListeners != null) {
                Iterator i = this.modelChangeListeners.iterator();
                while (i.hasNext()) {
                    ModelChangeListener l = (ModelChangeListener)i.next();
                    l.dataChanged(dataModel, dataModelKey, oldValue, newValue, changedEventsOnlyOutsideOfThisTable);
                }
            }
        }
        catch (StackOverflowError soe) {
            String error = "stack overflow error in method fireDataChangedEvent of " + this.name + "; ";
            System.err.println(error);
            throw new RuntimeException(error, soe);
        }
    }

    final void fireStateChangedEvent(ProtectedMap dataModel, String dataModelKey, ModelItemDTO oldValue, ModelItemDTO newValue, String changedEventsOnlyOutsideOfThisTable) {
        try {
            if (this.modelChangeListeners != null) {
                Iterator i = this.modelChangeListeners.iterator();
                while (i.hasNext()) {
                    ModelChangeListener l = (ModelChangeListener)i.next();
                    l.stateChanged(dataModel, dataModelKey, oldValue, newValue, changedEventsOnlyOutsideOfThisTable);
                }
            }
        }
        catch (StackOverflowError soe) {
            String error = "stack overflow error in method fireDataChangedEvent of " + this.name + "; ";
            System.err.println(error);
            throw new RuntimeException(error, soe);
        }
    }

    private void updateTableIndices(ProtectedMap dataModel, String dataModelKey) {
        String dmk = dataModelKey;
        if (this instanceof TableItem && EngineUtil.endsWithTableIndex(dmk = EngineUtil.mergeModelKey(this.name, dataModelKey))) {
            String index = EngineUtil.getLastKeyPart(dmk);
            String s = EngineUtil.removeLastKeyPart(dmk);
            ModelItemDTO dto = null;
            ModelItemDTO oldDTO = dataModel.get(s);
            if (oldDTO == null || oldDTO.getValue() == null) {
                dto = new ModelItemDTO();
                dto = dto.clone(new HashSet());
            } else {
                dto = oldDTO.clone(new HashSet((Set)oldDTO.getValue()));
            }
            if (!((Set)dto.getValue()).add(index)) {
                return;
            }
            dto.setTouched();
            dataModel.put(this, s, dto, this.persistenceKeyTemplates, oldDTO);
            dataModel.getTableUpdates().put(s, dto);
            this.initializeDefaultValues(dataModel, dmk);
            Collection tableEventListeners = ((TableItem)((Object)this)).getTableEventListeners();
            if (tableEventListeners != null) {
                Iterator i = tableEventListeners.iterator();
                while (i.hasNext()) {
                    TableItem.TableEventListener listener = (TableItem.TableEventListener)i.next();
                    listener.onTableEntryAdd(this, dataModel, s, index);
                }
            }
        }
        if (this.parent != null) {
            this.parent.updateTableIndices(dataModel, dmk);
        }
    }

    private void updateItemStates(ProtectedMap dataModel, String dataModelKey, int newState, ModelItemDTO storedDTO, ModelItemDTO oldStateDTO) {
        String parentDataModelKey;
        ModelItemDTO newDTO;
        boolean propagatedFromSubhierarchy;
        boolean bl = propagatedFromSubhierarchy = storedDTO == null && oldStateDTO == null;
        if (propagatedFromSubhierarchy) {
            storedDTO = oldStateDTO = dataModel.get(dataModelKey);
        }
        if (oldStateDTO != null && oldStateDTO.getState() == newState) {
            return;
        }
        if (propagatedFromSubhierarchy && oldStateDTO != null && !oldStateDTO.hasPropagatableState()) {
            return;
        }
        if (oldStateDTO == null || oldStateDTO.hasMoreImportantState(newState)) {
            Iterator i;
            if (this instanceof TableItem && !EngineUtil.endsWithTableIndex(dataModelKey)) {
                if (storedDTO != null && storedDTO.getValue() instanceof Set) {
                    i = ((Set)storedDTO.getValue()).iterator();
                    while (i.hasNext()) {
                        ModelItemDTO subDTO = dataModel.get(dataModelKey + "." + i.next());
                        if (subDTO == null || !subDTO.hasMoreImportantState(newState) || !subDTO.hasPropagatableState()) continue;
                        newState = subDTO.getState();
                    }
                }
            } else if (this.children != null) {
                i = this.children.iterator();
                while (i.hasNext()) {
                    LogicModelItem lmi = (LogicModelItem)i.next();
                    if (!lmi.isImportantState()) continue;
                    String s = EngineUtil.mergeModelKey(lmi.getName(), dataModelKey);
                    ModelItemDTO subDTO = dataModel.get(s);
                    if (subDTO == null && !lmi.isReadonly() && ModelItemDTO.isMoreImportantState(3, newState)) {
                        newState = 3;
                    }
                    if (subDTO == null || !subDTO.hasMoreImportantState(newState) || !subDTO.hasPropagatableState()) continue;
                    newState = subDTO.getState();
                }
            }
        }
        ModelItemDTO modelItemDTO = newDTO = storedDTO != null ? storedDTO : new ModelItemDTO();
        if (newState != newDTO.getState()) {
            newDTO = newDTO.clone(newState);
            dataModel.put(this, dataModelKey, newDTO, this.persistenceKeyTemplates, storedDTO);
            this.fireStateChangedEvent(dataModel, dataModelKey, storedDTO, newDTO, null);
        }
        if (!newDTO.hasPropagatableState()) {
            newState = 1;
        }
        if (this instanceof TableItem && EngineUtil.endsWithTableIndex(dataModelKey)) {
            parentDataModelKey = EngineUtil.removeLastKeyPart(dataModelKey);
            this.updateItemStates(dataModel, parentDataModelKey, newState, null, null);
        } else if (this.parent != null) {
            parentDataModelKey = EngineUtil.mergeModelKey(this.parent.getName(), dataModelKey);
            this.parent.updateItemStates(dataModel, parentDataModelKey, newState, null, null);
        }
    }

    private void setParent(LogicModelItem parent) {
        this.parent = parent;
    }

    private void setNextModelItem(LogicModelItem next) {
        this.nextItem = next;
    }

    public List getPersistenceKeyTemplates() {
        return this.persistenceKeyTemplates;
    }

    protected boolean isImportantState() {
        return true;
    }

    public static class ProtectedMap {
        protected Map nestedMap;
        protected Map changedMap;
        private Map undoInfoMap;
        private Set deleteWarnings;
        private boolean allowActiveValidations;
        private Map tableUpdates;
        private Set recursions;
        private Map asyncUpdates;
        private boolean recalculating = false;

        public ProtectedMap(Map nestedMap, boolean allowActiveValidations) {
            this.nestedMap = nestedMap;
            this.changedMap = new HashMap();
            this.undoInfoMap = new HashMap();
            this.tableUpdates = new HashMap();
            this.recursions = new HashSet();
            this.asyncUpdates = new LinkedHashMap();
            this.allowActiveValidations = allowActiveValidations;
        }

        public ProtectedMap(ProtectedMap protectedMap) {
            this.nestedMap = protectedMap.nestedMap;
            this.changedMap = protectedMap.changedMap;
            this.undoInfoMap = protectedMap.undoInfoMap;
            this.tableUpdates = new HashMap();
            this.recursions = new HashSet();
            this.asyncUpdates = new LinkedHashMap();
            this.allowActiveValidations = false;
        }

        public ModelItemDTO get(Object key) {
            return (ModelItemDTO)this.nestedMap.get(key);
        }

        public Map getChangedMap() {
            return this.changedMap;
        }

        public Map getUndoInfoMap() {
            return this.undoInfoMap;
        }

        public Map getTableUpdates() {
            return this.tableUpdates;
        }

        public Collection getDeleteWarnings() {
            return this.deleteWarnings;
        }

        public void addDeleteWarning(MessageItemDTO messageItemDTO) {
            if (this.deleteWarnings == null) {
                this.deleteWarnings = new HashSet();
            }
            this.deleteWarnings.add(messageItemDTO);
        }

        public boolean allowActiveValidations() {
            return this.allowActiveValidations;
        }

        public Set entrySet() {
            return this.nestedMap.entrySet();
        }

        public Set keySet() {
            return this.nestedMap.keySet();
        }

        public Set getRunningLoops() {
            return this.recursions;
        }

        public Map getAsyncUpdates() {
            return this.asyncUpdates;
        }

        public void setRecalculating(boolean recalculating) {
            this.recalculating = recalculating;
        }

        public boolean isRecalculating() {
            return this.recalculating;
        }

        private Object put(LogicModelItem lmi, Object dataModelKey, ModelItemDTO value, List persistenceKeyTemplates, ModelItemDTO oldValue) {
            if (value.equals(oldValue)) {
                return oldValue;
            }
            if (persistenceKeyTemplates.size() > 0 && (lmi.isReadonly() || value.isTouched() || this.recalculating)) {
                ArrayList<PersistenceWriteDTO> dtos = new ArrayList<PersistenceWriteDTO>();
                Iterator iter = persistenceKeyTemplates.iterator();
                while (iter.hasNext()) {
                    String persistenceKeyTemplate = (String)iter.next();
                    String persistenceKey = EngineUtil.convertPersistenceKey(persistenceKeyTemplate, (String)dataModelKey);
                    PersistenceWriteDTO dto = new PersistenceWriteDTO(persistenceKey, value);
                    dtos.add(dto);
                }
                this.changedMap.put(dataModelKey, dtos);
            }
            if (!this.undoInfoMap.containsKey(dataModelKey)) {
                this.undoInfoMap.put(dataModelKey, oldValue);
            }
            return this.nestedMap.put(dataModelKey, value);
        }

        private ModelItemDTO remove(String dataModelKey, List persistenceKeyTemplates) {
            ModelItemDTO oldDTO = (ModelItemDTO)this.nestedMap.remove(dataModelKey);
            if (oldDTO != null) {
                if (persistenceKeyTemplates.size() > 0 && !EngineUtil.endsWithTableIndex(dataModelKey)) {
                    ArrayList<PersistenceWriteDTO> dtos = new ArrayList<PersistenceWriteDTO>();
                    Iterator iter = persistenceKeyTemplates.iterator();
                    while (iter.hasNext()) {
                        String persistenceKeyTemplate = (String)iter.next();
                        String persistenceKey = EngineUtil.convertPersistenceKey(persistenceKeyTemplate, dataModelKey);
                        PersistenceWriteDTO dto = new PersistenceWriteDTO(persistenceKey, null);
                        dtos.add(dto);
                    }
                    this.changedMap.put(dataModelKey, dtos);
                }
                if (!this.undoInfoMap.containsKey(dataModelKey)) {
                    this.undoInfoMap.put(dataModelKey, oldDTO);
                }
            }
            return oldDTO;
        }
    }

    public static interface SelectItem {
        public OptionItemsDTO getOptionItems(ProtectedMap var1, String var2);

        public boolean hasTableOption();
    }

    public static interface ModuleItem {
        public String getTitle();

        public boolean isImportantState();

        public boolean isTransparentIfNotReleasable();

        public boolean isTransparentIfNotReleased();

        public boolean isTransparentIfReleased();

        public boolean isDisabledIfCd();

        public boolean isDisabledIfOnline();
    }

    public static interface TableItem {
        public void addSharedTable(TableItem var1);

        public Collection getSharedTables();

        public void addTableEventListener(TableEventListener var1);

        public Collection getTableEventListeners();

        public static interface TableEventListener {
            public void onTableEntryAdd(LogicModelItem var1, ProtectedMap var2, String var3, String var4);

            public void onTableEntryRemove(LogicModelItem var1, ProtectedMap var2, String var3, String var4);
        }
    }
}

