/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine;

import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.LogicModel;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayUtil;
import ch.dvbern.tax.common.engine.modelitems.Bool;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.engine.validators.Transparent;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.failure.InvalidModelItemKeyException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ExpertUpdatePreprocessor {
    private static final Logger log = Logger.getLogger((Class)ExpertUpdatePreprocessor.class);
    Map logicModelItems;
    Map preselectionItems = new HashMap();
    Map preselectionDependants = new HashMap();

    public ExpertUpdatePreprocessor(LogicModel logicModel, Map logicModelItems) {
        this.logicModelItems = logicModelItems;
        List moduls = logicModel.getModuls();
        if (moduls != null) {
            Iterator i = moduls.iterator();
            while (i.hasNext()) {
                LogicModelItem lmi = (LogicModelItem)i.next();
                this.initializePreselectionItems(lmi);
            }
        }
    }

    private void initializePreselectionItems(LogicModelItem lmi) {
        Iterator i;
        List validators = lmi.getValidators();
        List children = lmi.getChildren();
        if (children != null) {
            i = children.iterator();
            while (i.hasNext()) {
                LogicModelItem childLMI = (LogicModelItem)i.next();
                this.initializePreselectionItems(childLMI);
            }
        }
        if (!lmi.isReadonly() && validators != null) {
            i = validators.iterator();
            while (i.hasNext()) {
                LogicModelItem preSel;
                CalcItem ci;
                Transparent t;
                Validator v = (Validator)i.next();
                if (!(v instanceof Transparent) || (t = (Transparent)v).getCalcItems().size() != 1 || !((ci = (CalcItem)t.getCalcItems().iterator().next()) instanceof Reference) || !((preSel = (LogicModelItem)this.logicModelItems.get(((Reference)((Object)ci)).getName())) instanceof Bool) && !(preSel instanceof LogicModelItem.SelectItem) || preSel.isReadonly()) continue;
                String key = preSel.getName() + t.getBooleanExpression();
                PreselectionItem pi = (PreselectionItem)this.preselectionItems.get(key);
                if (pi == null) {
                    pi = new PreselectionItem(preSel, !t.getBooleanExpression());
                    this.preselectionItems.put(key, pi);
                }
                pi.addDependantItem(lmi);
                if (this.preselectionDependants.containsKey(lmi.getName())) {
                    log.warn((Object)("more than one preselection item for " + lmi.getName()));
                    continue;
                }
                this.preselectionDependants.put(lmi.getName(), pi);
            }
        }
    }

    public Map preProcessExpertUpdate(Map dataModel, Map newValues) {
        HashMap<String, ModelItemDTO> preUpdateValues = null;
        HashMap<String, ModelItemDTO> postUpdateValues = null;
        Iterator i1 = newValues.entrySet().iterator();
        while (i1.hasNext()) {
            Map.Entry me = i1.next();
            String currentDMK = me.getKey().toString();
            PreselectionItem pi = this.findAnyPreselectionItem(currentDMK);
            if (pi == null) continue;
            ModelItemDTO miDTO = (ModelItemDTO)me.getValue();
            if (this.containsUserInput(miDTO)) {
                String dmk = EngineUtil.mergeModelKey(pi.getLogicModelItem().getName(), currentDMK);
                ModelItemDTO preSelectionDTO = new ModelItemDTO(pi.enabledValue);
                preSelectionDTO.setTouched();
                if (preUpdateValues == null) {
                    preUpdateValues = new HashMap<String, ModelItemDTO>();
                }
                preUpdateValues.put(dmk, preSelectionDTO);
                continue;
            }
            boolean existingOtherInput = false;
            Iterator i2 = pi.getDependantItems().iterator();
            while (i2.hasNext() && !existingOtherInput) {
                LogicModelItem lmi = (LogicModelItem)i2.next();
                existingOtherInput = this.containsUserInput(currentDMK, lmi, newValues, dataModel);
            }
            if (existingOtherInput) continue;
            String dmk = EngineUtil.mergeModelKey(pi.getLogicModelItem().getName(), currentDMK);
            ModelItemDTO preSelectionDTO = (ModelItemDTO)dataModel.get(dmk);
            Boolean preSelectionDisabled = !pi.enabledValue;
            if (preSelectionDTO == null || !preSelectionDisabled.equals(preSelectionDTO.getValue())) {
                preSelectionDTO = new ModelItemDTO(preSelectionDisabled);
                preSelectionDTO.setTouched();
                if (postUpdateValues == null) {
                    postUpdateValues = new HashMap<String, ModelItemDTO>();
                }
                postUpdateValues.put(dmk, preSelectionDTO);
                continue;
            }
            i1.remove();
        }
        if (preUpdateValues != null || postUpdateValues != null) {
            LinkedHashMap<String, ModelItemDTO> orderedNewValues = new LinkedHashMap<String, ModelItemDTO>();
            if (preUpdateValues != null) {
                orderedNewValues.putAll(preUpdateValues);
            }
            orderedNewValues.putAll(newValues);
            if (postUpdateValues != null) {
                orderedNewValues.putAll(postUpdateValues);
            }
            return orderedNewValues;
        }
        return newValues;
    }

    private boolean containsUserInput(String dmk, LogicModelItem lmi, Map newValues, Map dataModel) {
        String s = EngineUtil.mergeModelKey(lmi.getName(), dmk);
        if (lmi instanceof LogicModelItem.ModuleItem) {
            if (lmi.getChildren() == null) {
                return false;
            }
            Iterator i = lmi.getChildren().iterator();
            while (i.hasNext()) {
                if (!this.containsUserInput(dmk, (LogicModelItem)i.next(), newValues, dataModel)) continue;
                return true;
            }
        }
        if (lmi instanceof LogicModelItem.TableItem) {
            ModelItemDTO tDTO;
            if (EngineUtil.endsWithTableIndex(s)) {
                s = EngineUtil.removeLastKeyPart(s);
            }
            if ((tDTO = (ModelItemDTO)dataModel.get(s)) != null && tDTO.getValue() instanceof Set && ((Set)tDTO.getValue()).size() > 0) {
                return true;
            }
            Iterator i = newValues.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry me = i.next();
                if (!((String)me.getKey()).startsWith(s) || !this.containsUserInput((ModelItemDTO)me.getValue())) continue;
                return true;
            }
        }
        if (lmi.isReadonly()) {
            return false;
        }
        ModelItemDTO tmp = (ModelItemDTO)newValues.get(s);
        if (tmp == null) {
            tmp = (ModelItemDTO)dataModel.get(s);
        }
        return this.containsUserInput(tmp);
    }

    private boolean containsUserInput(ModelItemDTO miDTO) {
        if (miDTO == null || miDTO.getValue() == null) {
            return false;
        }
        Object v = miDTO.getValue();
        if (v instanceof Collection) {
            return ((Collection)v).size() > 0;
        }
        return v.toString().length() > 0;
    }

    public PreselectionItem findAnyPreselectionItem(String dmk) {
        String s = EngineUtil.removeTableIndices(dmk);
        PreselectionItem pi = (PreselectionItem)this.preselectionDependants.get(s);
        while (pi == null && s.indexOf(".") > 0) {
            s = EngineUtil.removeLastKeyPart(s);
            pi = (PreselectionItem)this.preselectionDependants.get(s);
        }
        return pi;
    }

    public Map touchModelItems(String formAccessKey, List modules, Map dataModel) throws InvalidModelItemKeyException {
        HashMap<String, ModelItemDTO> result = new HashMap<String, ModelItemDTO>();
        if (formAccessKey == null || modules == null || dataModel == null) {
            return result;
        }
        Iterator i = modules.iterator();
        while (i.hasNext()) {
            Set unsortedRowIndices;
            LogicModelItem lmi = (LogicModelItem)i.next();
            if (lmi instanceof LogicModelItem.ModuleItem && !((LogicModelItem.ModuleItem)((Object)lmi)).isImportantState()) continue;
            String dmk = ExpertDisplayUtil.getModelItemKey(lmi, formAccessKey);
            ModelItemDTO miDTO = (ModelItemDTO)dataModel.get(dmk);
            boolean touchChildren = false;
            if (miDTO == null) {
                miDTO = new ModelItemDTO(null, 1);
                miDTO.setTouched();
                result.put(dmk, miDTO);
                touchChildren = true;
            } else if (miDTO.getState() == 3) {
                miDTO.setTouched();
                result.put(dmk, miDTO);
                touchChildren = true;
            } else if (miDTO.getState() == 4 || miDTO.getState() == 2) {
                touchChildren = true;
            }
            if (touchChildren && lmi instanceof LogicModelItem.ModuleItem) {
                result.putAll(this.touchModelItems(formAccessKey, lmi.getChildren(), dataModel));
                continue;
            }
            if (!touchChildren || !(lmi instanceof LogicModelItem.TableItem) || (unsortedRowIndices = miDTO != null && miDTO.getValue() != null ? (Set)miDTO.getValue() : null) == null || unsortedRowIndices.size() <= 0) continue;
            Iterator it = unsortedRowIndices.iterator();
            while (it.hasNext()) {
                String rowIndex = it.next().toString();
                String fak = formAccessKey;
                if (fak.indexOf("#") == -1) {
                    fak = fak + "#";
                }
                fak = fak + (fak.endsWith("#") ? "" + rowIndex : "." + rowIndex);
                result.putAll(this.touchModelItems(fak, lmi.getChildren(), dataModel));
            }
        }
        return result;
    }

    private static class PreselectionItem {
        LogicModelItem logicModelItem;
        boolean enabledValue;
        List dependantItems = new ArrayList();

        public PreselectionItem(LogicModelItem logicModelItem, boolean enabledValue) {
            this.logicModelItem = logicModelItem;
            this.enabledValue = enabledValue;
        }

        public void addDependantItem(LogicModelItem lmi) {
            this.dependantItems.add(lmi);
        }

        public List getDependantItems() {
            return this.dependantItems;
        }

        public boolean getEnabledValue() {
            return this.enabledValue;
        }

        public LogicModelItem getLogicModelItem() {
            return this.logicModelItem;
        }
    }
}

