/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine;

import ch.dvbern.tax.common.engine.Engine;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class EngineXML
extends Task {
    public static final String ENCODING = "ISO-8859-1";
    public static final String SRC_ENCODING = "UTF-8";
    private String tmoLine;
    private String baseDir;
    private String sInputfile;
    private String sOutputfile;
    private StringBuffer logicStructure = new StringBuffer();
    private StringBuffer wizardDisplayStructure = new StringBuffer();
    private StringBuffer expertDisplayStructure = new StringBuffer();

    public EngineXML() {
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("usage: ");
            System.out.println("arg[0]: path of conf file");
            System.out.println("arg[1]: name of output-file");
            System.exit(0);
        }
        new EngineXML(null, args[0], args[1]);
    }

    public void execute() throws BuildException {
        super.execute();
        try {
            this.mergeAll();
        }
        catch (Throwable t) {
            throw new BuildException(t);
        }
    }

    public EngineXML(String baseDir, String sInputfile, String sOutputfile) {
        this.baseDir = baseDir;
        this.sInputfile = sInputfile;
        this.sOutputfile = sOutputfile;
        this.mergeAll();
    }

    private void mergeAll() {
        File directory = new File(this.sInputfile.replace('\\', '/'));
        try {
            this.baseDir = this.baseDir != null ? this.baseDir + "/" : "";
            FilterInputStream is = new BufferedInputStream(new FileInputStream(directory));
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)is, SRC_ENCODING));
            String line = br.readLine();
            while (line != null) {
                if (!line.startsWith("*") && !line.startsWith("#")) {
                    File tmp = new File(this.baseDir + line);
                    this.merge(tmp);
                }
                line = br.readLine();
            }
            br.close();
            this.generateFile();
            StringBuffer xmlStructure = new StringBuffer();
            is = new GZIPInputStream(new BufferedInputStream(new FileInputStream(this.sOutputfile)));
            br = new BufferedReader(new InputStreamReader((InputStream)is, ENCODING));
            line = br.readLine();
            while (line != null) {
                xmlStructure.append(line);
                line = br.readLine();
            }
            Engine.createEngine(xmlStructure.toString(), null, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private void merge(File file) {
        block14: {
            boolean isExpertDisplay;
            boolean isWizardDisplay;
            boolean isLogic;
            block13: {
                isLogic = false;
                isWizardDisplay = false;
                isExpertDisplay = false;
                if (!file.isDirectory()) break block13;
                File[] files = file.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    this.merge(files[i]);
                }
                break block14;
            }
            if (!file.getName().substring(file.getName().length() - 3).equals("xml")) break block14;
            try {
                System.out.println("merge file: " + file.getAbsolutePath());
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
                BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)is, SRC_ENCODING));
                String line = br.readLine();
                while (line != null) {
                    if (line.indexOf("<model-root name=") > -1) {
                        this.tmoLine = line;
                    }
                    if (line.indexOf("<logic-model") > -1 || line.indexOf("</wizard-display-model") > -1 || line.indexOf("</expert-display-model") > -1) {
                        isLogic = true;
                        isWizardDisplay = false;
                        isExpertDisplay = false;
                    }
                    if (line.indexOf("<wizard-display-model") > -1 || line.indexOf("</expert-display-model") > -1 || line.indexOf("</logic-model") > -1) {
                        isLogic = false;
                        isWizardDisplay = true;
                        isExpertDisplay = false;
                    }
                    if (line.indexOf("<expert-display-model") > -1 || line.indexOf("</wizard-display-model") > -1 || line.indexOf("</logic-model") > -1) {
                        isLogic = false;
                        isWizardDisplay = false;
                        isExpertDisplay = true;
                    }
                    if (line.indexOf("<?xml") == -1 && line.indexOf("<!DOCTYPE") == -1 && line.indexOf("<model-root") == -1 && line.indexOf("</model-root") == -1 && line.indexOf("logic-model") == -1 && line.indexOf("wizard-display-model") == -1 && line.indexOf("expert-display-model") == -1) {
                        if (isLogic) {
                            this.logicStructure.append(line + "\n");
                        }
                        if (isWizardDisplay) {
                            this.wizardDisplayStructure.append(line + "\n");
                        }
                        if (isExpertDisplay) {
                            this.expertDisplayStructure.append(line + "\n");
                        }
                    }
                    line = br.readLine();
                }
            }
            catch (FileNotFoundException fnf) {
                fnf.printStackTrace();
            }
            catch (IOException io) {
                io.printStackTrace();
            }
        }
    }

    private File generateFile() {
        File file = new File(this.sOutputfile);
        file.getParentFile().mkdirs();
        try {
            PrintStream writer = new PrintStream((OutputStream)new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(file))), true, ENCODING);
            writer.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
            writer.println("<!DOCTYPE EngineDTO.dtd>");
            writer.println(this.tmoLine);
            writer.println("<logic-model>");
            writer.print(this.logicStructure.toString());
            writer.println("</logic-model>");
            writer.println("<wizard-display-model>");
            writer.print(this.wizardDisplayStructure.toString());
            writer.println("</wizard-display-model>");
            writer.println("<expert-display-model>");
            writer.print(this.expertDisplayStructure.toString());
            writer.println("</expert-display-model>");
            writer.println("</model-root>");
            writer.flush();
            writer.close();
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        return file;
    }

    public void setBaseDir(String string) {
        this.baseDir = string;
    }

    public void setSInputfile(String string) {
        this.sInputfile = string;
    }

    public void setSOutputfile(String string) {
        this.sOutputfile = string;
    }
}

