/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.common;

import org.apache.xerces.utils.QName;
import org.apache.xerces.validators.common.CMException;
import org.apache.xerces.validators.common.ContentLeafNameTypeVector;
import org.apache.xerces.validators.common.InsertableElementsInfo;
import org.apache.xerces.validators.common.XMLContentModel;
import org.apache.xerces.validators.schema.SchemaGrammar;
import org.apache.xerces.validators.schema.SubstitutionGroupComparator;

public class MixedContentModel
implements XMLContentModel {
    private int fCount;
    private QName[] fChildren;
    private int[] fChildrenType;
    private SubstitutionGroupComparator comparator = null;
    private boolean fOrdered;
    private boolean fDTD;

    public MixedContentModel(QName[] qNameArray, int[] nArray, int n, int n2) throws CMException {
        this(qNameArray, nArray, n, n2, false, false);
    }

    public MixedContentModel(QName[] qNameArray, int[] nArray, int n, int n2, boolean bl) throws CMException {
        this(qNameArray, nArray, n, n2, bl, false);
    }

    public MixedContentModel(QName[] qNameArray, int[] nArray, int n, int n2, boolean bl, boolean bl2) throws CMException {
        this.fCount = n2;
        this.fChildren = new QName[this.fCount];
        this.fChildrenType = new int[this.fCount];
        int n3 = 0;
        while (n3 < this.fCount) {
            this.fChildren[n3] = new QName(qNameArray[n + n3]);
            this.fChildrenType[n3] = nArray[n + n3];
            ++n3;
        }
        this.fOrdered = bl;
        this.fDTD = bl2;
    }

    public void checkUniqueParticleAttribution(SchemaGrammar schemaGrammar) {
        int n = 0;
        while (n < this.fCount) {
            this.fChildren[n].uri = schemaGrammar.getContentSpecOrgUri(this.fChildren[n].uri);
            ++n;
        }
    }

    public int validateContent(QName[] qNameArray, int n, int n2) throws Exception {
        if (this.fOrdered) {
            int n3 = 0;
            int n4 = 0;
            while (n4 < n2) {
                QName qName = qNameArray[n + n4];
                if (qName.localpart != -1) {
                    int n5 = this.fChildrenType[n3];
                    if (n5 == 0 ? (this.fDTD ? this.fChildren[n3].rawname != qNameArray[n + n4].rawname : this.fChildren[n3].uri != qNameArray[n + n4].uri && this.fChildren[n3].localpart != qNameArray[n + n4].localpart) : n5 != 6 && (n5 == 8 ? qNameArray[n4].uri != this.fChildren[n3].uri : n5 == 7 && this.fChildren[n3].uri == qNameArray[n4].uri)) {
                        return n4;
                    }
                    ++n3;
                }
                ++n4;
            }
        } else {
            int n6 = 0;
            while (n6 < n2) {
                QName qName = qNameArray[n + n6];
                if (qName.localpart != -1) {
                    int n7 = 0;
                    while (n7 < this.fCount) {
                        int n8 = this.fChildrenType[n7];
                        if (n8 == 0 ? (this.fDTD ? qName.rawname == this.fChildren[n7].rawname : qName.uri == this.fChildren[n7].uri && qName.localpart == this.fChildren[n7].localpart) : n8 == 6 || (n8 == 8 ? qNameArray[n6].uri == this.fChildren[n7].uri : n8 == 7 && this.fChildren[n7].uri != qNameArray[n6].uri)) break;
                        ++n7;
                    }
                    if (n7 == this.fCount) {
                        return n6;
                    }
                }
                ++n6;
            }
        }
        return -1;
    }

    public int validateContentSpecial(QName[] qNameArray, int n, int n2) throws Exception {
        return this.validateContent(qNameArray, n, n2);
    }

    public void setSubstitutionGroupComparator(SubstitutionGroupComparator substitutionGroupComparator) {
        this.comparator = substitutionGroupComparator;
    }

    public int whatCanGoHere(boolean bl, InsertableElementsInfo insertableElementsInfo) throws Exception {
        int n;
        int n2 = insertableElementsInfo.insertAt;
        while (n2 < insertableElementsInfo.childCount) {
            insertableElementsInfo.curChildren[n2] = insertableElementsInfo.curChildren[n2 + 1];
            ++n2;
        }
        --insertableElementsInfo.childCount;
        int n3 = this.validateContent(insertableElementsInfo.curChildren, 0, insertableElementsInfo.childCount);
        if (n3 != -1 && n3 < insertableElementsInfo.insertAt) {
            return n3;
        }
        insertableElementsInfo.canHoldPCData = true;
        insertableElementsInfo.isValidEOC = true;
        insertableElementsInfo.resultsCount = this.fCount;
        if (insertableElementsInfo.results == null || insertableElementsInfo.results.length < insertableElementsInfo.resultsCount) {
            insertableElementsInfo.results = new boolean[insertableElementsInfo.resultsCount];
        }
        if (insertableElementsInfo.possibleChildren == null || insertableElementsInfo.possibleChildren.length < insertableElementsInfo.resultsCount) {
            insertableElementsInfo.possibleChildren = new QName[insertableElementsInfo.resultsCount];
            n = 0;
            while (n < insertableElementsInfo.possibleChildren.length) {
                insertableElementsInfo.possibleChildren[n] = new QName();
                ++n;
            }
        }
        n = 1;
        if (bl && n3 < insertableElementsInfo.childCount) {
            n = 0;
        }
        int n4 = 0;
        while (n4 < this.fCount) {
            insertableElementsInfo.possibleChildren[n4].setValues(this.fChildren[n4]);
            insertableElementsInfo.results[n4] = n;
            ++n4;
        }
        return -1;
    }

    public ContentLeafNameTypeVector getContentLeafNameTypeVector() {
        return null;
    }
}

