/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.transfer.dto.convert;

import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NoValeur
extends AbstractConverter {
    private static final long serialVersionUID = 3258413941062578742L;
    private Pattern patternValidate = Pattern.compile("(\\d)(\\ ?)(\\d{1,3})(\\ ?)(\\d{1,3})");
    private Pattern patternRender = Pattern.compile("(\\d)(\\d{1,3})(\\d{1,3})");

    public Object getObject(String s, OptionItemsDTO optionItems) throws AbstractConverter.ConvertException {
        if (s == null || s.length() <= 0) {
            return null;
        }
        Matcher m = this.patternValidate.matcher(s);
        s = this.convert(s);
        if (!m.matches()) {
            throw new AbstractConverter.ConvertException("error.format.noValeur");
        }
        return s;
    }

    public String getRenderedValue(Object o, boolean readonly, OptionItemsDTO optionItems, LocalizationHelper locHelper) {
        if (o == null) {
            return "";
        }
        Matcher m = this.patternRender.matcher(o.toString());
        return o.toString();
    }

    public String getUserInputRegExpPattern() {
        return "[0-9]{1,1}(\\ ?)[0-9]{0,3}(\\ ?)[0-9]{0,3}";
    }

    private String convert(String no) {
        int length;
        String toReturn = new String();
        if (no != null & no.length() > 0 && (length = (no = no.replaceAll(" ", "")).length()) > 0) {
            StringBuffer sb = new StringBuffer(no);
            switch (length) {
                case 4: {
                    sb.insert(1, ' ');
                    break;
                }
                case 5: {
                    sb.insert(2, ' ');
                    break;
                }
                case 6: {
                    sb.insert(3, ' ');
                    break;
                }
                case 7: {
                    sb.insert(1, ' ');
                    sb.insert(5, ' ');
                    break;
                }
            }
            toReturn = sb.toString();
        }
        return toReturn;
    }
}

