/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.transfer.dto.convert;

import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NoIBAN
extends AbstractConverter {
    private static final long serialVersionUID = 3258413941062578742L;
    private Pattern patternValidate = Pattern.compile("(\\d\\d)(\\ ?)(\\w\\w\\w\\w)(\\ ?)(\\w\\w\\w\\w)(\\ ?)(\\w\\w\\w\\w)(\\ ?)(\\w\\w\\w\\w)(\\ ?)(\\w)");
    private Pattern patternRender = Pattern.compile("(\\d\\d)(\\w\\w\\w\\w)(\\w\\w\\w\\w)(\\w\\w\\w\\w)(\\w\\w\\w\\w)(\\w)");

    public Object getObject(String s, OptionItemsDTO optionItems) throws AbstractConverter.ConvertException {
        if (s == null || s.length() <= 0) {
            return null;
        }
        Matcher m = this.patternValidate.matcher(s);
        if (!m.matches()) {
            throw new AbstractConverter.ConvertException("error.format.noIBAN");
        }
        if (!this.isValid(s)) {
            throw new AbstractConverter.ConvertException("error.false.noIBAN");
        }
        return s;
    }

    public String getRenderedValue(Object o, boolean readonly, OptionItemsDTO optionItems, LocalizationHelper locHelper) {
        if (o == null) {
            return "";
        }
        Matcher m = this.patternRender.matcher(o.toString());
        if (m.matches()) {
            return m.group(1) + " " + m.group(2) + " " + m.group(3) + " " + m.group(4) + " " + m.group(5) + " " + m.group(6);
        }
        return o.toString();
    }

    public String getUserInputRegExpPattern() {
        return "[0-9]|[0-9]{2}(\\ ?)[0-9a-zA-Z]{0,4}(\\ ?)[0-9a-zA-Z]{0,4}(\\ ?)[0-9a-zA-Z]{0,4}(\\ ?)[0-9a-zA-Z]{0,4}(\\ ?)[0-9a-zA-Z]{0,1}";
    }

    private boolean isValid(String noIbanComplet) {
        String noIbanAvecPays = "CH" + noIbanComplet.replaceAll(" ", "");
        String noIbanPretPourControle = noIbanAvecPays.substring(4, 21) + noIbanAvecPays.substring(0, 4);
        String sNoIbanNumerique = this.transformeToNumber(noIbanPretPourControle);
        String noToDivide = sNoIbanNumerique.substring(0, 9);
        sNoIbanNumerique = sNoIbanNumerique.substring(9, sNoIbanNumerique.length());
        long reste = 0L;
        while (sNoIbanNumerique.length() >= 0) {
            reste = Long.valueOf(noToDivide) % 97L;
            if (reste / 10L > 0L) {
                if (sNoIbanNumerique.length() >= 7) {
                    noToDivide = String.valueOf(reste) + sNoIbanNumerique.substring(0, 7);
                    sNoIbanNumerique = sNoIbanNumerique.substring(7, sNoIbanNumerique.length());
                    continue;
                }
                noToDivide = String.valueOf(reste) + sNoIbanNumerique.substring(0, sNoIbanNumerique.length());
                return Long.valueOf(noToDivide) % 97L == 1L;
            }
            if (sNoIbanNumerique.length() >= 8) {
                noToDivide = String.valueOf(reste) + sNoIbanNumerique.substring(0, 8);
                sNoIbanNumerique = sNoIbanNumerique.substring(8, sNoIbanNumerique.length());
                continue;
            }
            noToDivide = String.valueOf(reste) + sNoIbanNumerique.substring(0, sNoIbanNumerique.length());
            return Long.valueOf(noToDivide) % 97L == 1L;
        }
        return false;
    }

    private String transformeToNumber(String noIbanAlphanumerique) {
        String noIbanAlphanumeriqueMaj = noIbanAlphanumerique.toUpperCase();
        StringBuffer noIbanNumerique = new StringBuffer();
        for (int i = 0; i < noIbanAlphanumeriqueMaj.length(); ++i) {
            char caractere = noIbanAlphanumeriqueMaj.charAt(i);
            if (!Character.isDigit(caractere)) {
                String temp = Integer.toString(caractere - 55);
                noIbanNumerique.append(temp);
                continue;
            }
            noIbanNumerique.append(caractere);
        }
        return noIbanNumerique.toString();
    }
}

