/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.transfer.dto.convert;

import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NoContribuableConverter
extends AbstractConverter {
    private static final long serialVersionUID = 3258413941062578742L;
    private Pattern patternValidate = Pattern.compile("(\\d\\d\\d)(\\.?)(\\d\\d\\d)(\\.?)(\\d\\d\\d)");
    private Pattern patternRender = Pattern.compile("(\\d\\d\\d)(\\d\\d\\d)(\\d\\d\\d)");

    public Object getObject(String s, OptionItemsDTO optionItems) throws AbstractConverter.ConvertException {
        if (s == null || s.length() <= 0) {
            return null;
        }
        Matcher m = this.patternValidate.matcher(s);
        if (!m.matches()) {
            throw new AbstractConverter.ConvertException("error.format.noContribuable");
        }
        return s;
    }

    public String getRenderedValue(Object o, boolean readonly, OptionItemsDTO optionItems, LocalizationHelper locHelper) {
        if (o == null) {
            return "";
        }
        Matcher m = this.patternRender.matcher(o.toString());
        if (m.matches()) {
            return m.group(1) + "." + m.group(2) + "." + m.group(3);
        }
        return o.toString();
    }

    private int berechnenPruefziffer(int iZahl) {
        List vZiffern = this.ziffernReverse(iZahl /= 10);
        int summe = 0;
        for (int i = 0; i < vZiffern.size(); ++i) {
            if (this.odd(i)) {
                summe += ((Integer)vZiffern.get(i)).intValue();
                continue;
            }
            summe += this.querSumme((Integer)vZiffern.get(i) * 2);
        }
        return ((summe + 10) / 10 * 10 - summe) % 10;
    }

    protected boolean isPruefzifferValid(String sZahl) {
        try {
            int iZahl = new Integer(sZahl);
            int iPruefziffer = iZahl % 10;
            if (iPruefziffer == this.berechnenPruefziffer(iZahl)) {
                return true;
            }
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return false;
    }

    private boolean odd(int iZahl) {
        return iZahl % 2 != 0;
    }

    private int querSumme(int iZahl) {
        int iQuerSumme = iZahl % 10;
        if (iZahl < 10) {
            return iQuerSumme;
        }
        return iQuerSumme + this.querSumme(iZahl /= 10);
    }

    private List ziffernReverse(int iZahl) {
        ArrayList<Integer> vZiffern = new ArrayList<Integer>();
        while (iZahl != 0) {
            vZiffern.add(new Integer(iZahl % 10));
            iZahl /= 10;
        }
        return vZiffern;
    }

    public String getUserInputRegExpPattern() {
        return "[0-9]{1,3}(\\.?)[0-9]{0,3}(\\.?)[0-9]{0,3}";
    }
}

