/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.transfer.dto.convert;

import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AhvNeuAltConverter
extends AbstractConverter {
    private static final long serialVersionUID = -6841670933609606809L;
    private Pattern patternValidateNeu = Pattern.compile("(\\d\\d\\d)(\\.?)(\\d\\d\\d\\d)(\\.?)(\\d\\d\\d\\d)(\\.?)(\\d\\d)");
    private Pattern patternRenderNeu = Pattern.compile("(\\d\\d\\d)(\\d\\d\\d\\d)(\\d\\d\\d\\d)(\\d\\d)");
    private Pattern patternValidateAlt = Pattern.compile("(\\d\\d\\d)(\\.?)(\\d\\d)(\\.?)(\\d\\d\\d)(\\.?)(\\d\\d\\d)");
    private Pattern patternRenderAlt = Pattern.compile("(\\d\\d\\d)(\\d\\d)(\\d\\d\\d)(\\d\\d\\d)");
    int[] testChiffres = new int[]{5, 4, 3, 2, 7, 6, 5, 4, 3, 2};

    public Object getObject(String s, OptionItemsDTO optionItems) throws AbstractConverter.ConvertException {
        if (s == null || s.length() <= 0) {
            return null;
        }
        Matcher mAlt = this.patternValidateAlt.matcher(s);
        Matcher mNeu = this.patternValidateNeu.matcher(s);
        boolean altMatch = mAlt.matches();
        boolean neuMatch = mNeu.matches();
        if (!mAlt.matches() && !mNeu.matches()) {
            throw new AbstractConverter.ConvertException("error.format.ahv");
        }
        if (mAlt.matches() && !this.isChiffreCTLValid(s)) {
            throw new AbstractConverter.ConvertException("error.format.ahv");
        }
        if (mNeu.matches() && !this.isChiffreNSSValid(s)) {
            throw new AbstractConverter.ConvertException("error.format.ahv");
        }
        return this.getRenderedValue(s, false, optionItems, null);
    }

    public String getRenderedValue(Object o, boolean readonly, OptionItemsDTO optionItems, LocalizationHelper locHelper) {
        if (o == null) {
            return "";
        }
        Matcher mAlt = this.patternValidateAlt.matcher(o.toString());
        Matcher mNeu = this.patternValidateNeu.matcher(o.toString());
        Matcher m = null;
        if (mAlt.matches()) {
            m = this.patternRenderAlt.matcher(o.toString());
        } else if (mNeu.matches()) {
            m = this.patternRenderNeu.matcher(o.toString());
        } else {
            return o.toString();
        }
        if (m.matches()) {
            return m.group(1) + "." + m.group(2) + "." + m.group(3) + "." + m.group(4);
        }
        return o.toString();
    }

    public int getMaxLength() {
        return 16;
    }

    public String getUserInputRegExpPattern() {
        return super.getUserInputRegExpPattern();
    }

    private boolean isChiffreCTLValid(String sAvs) {
        int[] chiffres = this.calcChiffres(sAvs);
        int chiffreCTL = this.calcChiffreCTL(sAvs);
        int sum = 0;
        for (int i = 0; i < chiffres.length; ++i) {
            sum += chiffres[i];
        }
        int chiffreControle = 11 - sum % 11;
        if (chiffreControle == 11) {
            chiffreControle = 0;
        }
        return chiffreControle == chiffreCTL;
    }

    private boolean isChiffreNSSValid(String sAvs) {
        int checkDigit = 0;
        int[] chiffres = this.getDigitsNew(sAvs);
        int length = chiffres.length;
        for (int i = 0; i < length - 1; ++i) {
            if (i % 2 == 0) {
                checkDigit += chiffres[i];
                continue;
            }
            checkDigit += 3 * chiffres[i];
        }
        checkDigit %= 10;
        return (checkDigit = (10 - checkDigit) % 10) == chiffres[length - 1];
    }

    private int calcChiffreCTL(String sAvs) {
        return Integer.parseInt(sAvs.substring(sAvs.length() - 1));
    }

    private int[] calcChiffres(String sAvs) {
        int i;
        int[] chiffres = new int[10];
        int j = 0;
        for (i = 0; i < sAvs.length() - 1; ++i) {
            String tmpString = sAvs.substring(i, i + 1);
            if (".".indexOf(tmpString) != -1) continue;
            chiffres[j] = Integer.parseInt(sAvs.substring(i, i + 1));
            ++j;
        }
        for (i = 0; i < chiffres.length; ++i) {
            chiffres[i] = chiffres[i] * this.testChiffres[i];
        }
        return chiffres;
    }

    public int[] getDigitsNew(String sAvs) {
        int avsLength = sAvs.length();
        int[] chiffres = new int[13];
        int j = 0;
        for (int i = 0; i < sAvs.length() - 1; ++i) {
            String tmpString = sAvs.substring(i, i + 1);
            if (".".indexOf(tmpString) != -1) continue;
            chiffres[j] = Integer.parseInt(sAvs.substring(i, i + 1));
            ++j;
        }
        chiffres[12] = Integer.parseInt(sAvs.substring(avsLength - 1));
        return chiffres;
    }
}

