/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.transfer.dto.convert;

import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AhvConverter
extends AbstractConverter {
    private static final long serialVersionUID = 3618977871490462256L;
    private Pattern patternValidate = Pattern.compile("(\\d\\d\\d)(\\.?)(\\d\\d)(\\.?)(\\d\\d\\d)(\\.?)(\\d\\d\\d)");
    private Pattern patternRender = Pattern.compile("(\\d\\d\\d)(\\d\\d)(\\d\\d\\d)(\\d\\d\\d)");
    int[] testChiffres = new int[]{5, 4, 3, 2, 7, 6, 5, 4, 3, 2};

    public Object getObject(String s, OptionItemsDTO optionItems) throws AbstractConverter.ConvertException {
        if (s == null || s.length() <= 0) {
            return null;
        }
        if (!this.isChiffreCTLValid(s)) {
            throw new AbstractConverter.ConvertException("error.format.ahv");
        }
        Matcher m = this.patternValidate.matcher(s);
        if (!m.matches()) {
            throw new AbstractConverter.ConvertException("error.format.ahv");
        }
        return s;
    }

    public String getRenderedValue(Object o, boolean readonly, OptionItemsDTO optionItems, LocalizationHelper locHelper) {
        if (o == null) {
            return "";
        }
        Matcher m = this.patternRender.matcher(o.toString());
        if (m.matches()) {
            return m.group(1) + "." + m.group(2) + "." + m.group(3) + "." + m.group(4);
        }
        return o.toString();
    }

    public String getUserInputRegExpPattern() {
        return "[0-9]{1,3}(\\.?)[0-9]{0,2}(\\.?)[0-9]{0,3}(\\.?)[0-9]{0,3}";
    }

    private boolean isChiffreCTLValid(String sAvs) {
        int[] chiffres = this.calcChiffres(sAvs);
        int chiffreCTL = this.calcChiffreCTL(sAvs);
        int sum = 0;
        for (int i = 0; i < chiffres.length; ++i) {
            sum += chiffres[i];
        }
        int chiffreControle = 11 - sum % 11;
        if (chiffreControle == 11) {
            chiffreControle = 0;
        }
        return chiffreControle == chiffreCTL;
    }

    private int calcChiffreCTL(String sAvs) {
        return Integer.parseInt(sAvs.substring(sAvs.length() - 1));
    }

    private int[] calcChiffres(String sAvs) {
        int i;
        int[] chiffres = new int[10];
        int j = 0;
        for (i = 0; i < sAvs.length() - 1; ++i) {
            String tmpString = sAvs.substring(i, i + 1);
            if (".".indexOf(tmpString) != -1) continue;
            chiffres[j] = Integer.parseInt(sAvs.substring(i, i + 1));
            ++j;
        }
        for (i = 0; i < chiffres.length; ++i) {
            chiffres[i] = chiffres[i] * this.testChiffres[i];
        }
        return chiffres;
    }
}

