/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.presentation.common.imports;

import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.presentation.common.imports.ImportContext;
import ch.dvbern.tax.common.presentation.common.imports.ImportException;
import ch.dvbern.tax.common.presentation.common.imports.TaxFileImporter;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class GeTaxFileImporter
extends TaxFileImporter {
    private static final Logger log = Logger.getLogger(GeTaxFileImporter.class);
    private static final String TAX_YEAR_KEY = "Declaration.PeriodeTaxation";
    private static final String TAX_YEAR_KEY_AF = "Declaration_af.PeriodeTaxation";
    private static final Long TAX_YEAR_EXPECTED = new Long(2007L);
    private static final String TAX_YEAR_ERROR_CODE = "error.import.steuerjahr";
    private static final Map DECLA_PAGE_1;
    private static final Map DECLA_AF_PAGE_1;
    private static final Map ANNEXE_F;
    private static final Map ANNEXE_F_AF;
    private static final Map ANNEXE_J;
    private static final Map ANNEXE_J_AF;
    private static final Map ANNEXE_K;
    private static final Map ANNEXE_K_AF;
    private static final String SELECTION_SA = "Selection.SA";
    private static final String SELECTION_AF = "Selection.AF";
    private boolean selectionSa;
    private boolean selectionAf;

    public GeTaxFileImporter(ImportContext ctx) {
        super(ctx);
    }

    protected void importOldModelItems() throws ImportException {
        ModelItemDTO afItem;
        Object value;
        Long taxYear = null;
        ModelItemDTO taxYearItem = (ModelItemDTO)this.getOldDataModel().get(TAX_YEAR_KEY);
        ModelItemDTO taxYearItem_af = (ModelItemDTO)this.getOldDataModel().get(TAX_YEAR_KEY_AF);
        if (taxYearItem != null) {
            value = taxYearItem.getValue();
            if (value != null) {
                if (value instanceof Long) {
                    taxYear = (Long)value;
                } else {
                    try {
                        taxYear = Long.valueOf(value.toString());
                    }
                    catch (Exception e) {
                        log.warn("tax year conversion failed", e);
                        taxYear = null;
                    }
                }
            }
        } else if (taxYearItem_af != null && (value = taxYearItem_af.getValue()) != null) {
            if (value instanceof Long) {
                taxYear = (Long)value;
            } else {
                try {
                    taxYear = Long.valueOf(value.toString());
                }
                catch (Exception e) {
                    log.warn("tax year conversion failed", e);
                    taxYear = null;
                }
            }
        }
        if (!TAX_YEAR_EXPECTED.equals(taxYear)) {
            throw new ImportException(TAX_YEAR_ERROR_CODE);
        }
        super.importOldModelItems();
        ModelItemDTO saItem = (ModelItemDTO)this.getNewDataModel().get(SELECTION_SA);
        if (saItem != null && saItem.getValue() != null && saItem.getValue() instanceof Boolean) {
            this.selectionSa = (Boolean)saItem.getValue();
        }
        if ((afItem = (ModelItemDTO)this.getNewDataModel().get(SELECTION_AF)) != null && afItem.getValue() != null && afItem.getValue() instanceof Boolean) {
            this.selectionAf = (Boolean)afItem.getValue();
        }
        if (this.selectionSa) {
            this.deleteDataFromAnnexeM();
            this.traitePertesFiscalesSA_ICC();
            this.traitePertesFiscalesSA_IFD();
        }
        if (this.selectionAf) {
            this.traitePertesFiscalesAF_ICC();
            this.traitePertesFiscalesAF_IFD();
        }
    }

    protected void storeInNewModel(String key, ModelItemDTO value) throws ImportException {
        long result;
        long valLoc;
        Long valLocObj;
        Double tauxObj;
        Long longValue;
        Object idObj;
        ModelItemDTO miValFiscale;
        String dmkValFiscale;
        ModelItemDTO miValLocative;
        String dmkValLocative;
        ModelItemDTO miDateDebut;
        String dmkDateDebut;
        Object dateObj;
        ModelItemDTO mi;
        String dmk;
        String lmk;
        String current;
        String logicModelKey = EngineUtil.removeTableIndices(key);
        Iterator it = DECLA_PAGE_1.keySet().iterator();
        while (it.hasNext()) {
            current = (String)it.next();
            if (!logicModelKey.equals(current)) continue;
            lmk = (String)DECLA_PAGE_1.get(current);
            dmk = EngineUtil.mergeModelKey(lmk, key);
            mi = (ModelItemDTO)this.getOldDataModel().get(dmk);
            if (mi == null || mi.getValue() == null || !((dateObj = mi.getValue()) instanceof Date)) continue;
            dmkDateDebut = EngineUtil.removeLastKeyPart(dmk) + ".DateDeb";
            miDateDebut = (ModelItemDTO)this.getOldDataModel().get(dmkDateDebut);
            if (miDateDebut != null) {
                miDateDebut = miDateDebut.clone(this.addDay((Date)dateObj, 1));
                super.storeInNewModel(dmkDateDebut, miDateDebut);
            }
            value = value.clone(this.addYear((Date)dateObj, 1));
        }
        it = ANNEXE_F.keySet().iterator();
        while (it.hasNext()) {
            current = (String)it.next();
            if (!logicModelKey.equals(current)) continue;
            lmk = (String)ANNEXE_F.get(current);
            dmk = EngineUtil.mergeModelKey(lmk, key);
            mi = (ModelItemDTO)this.getOldDataModel().get(dmk);
            dmkValLocative = EngineUtil.removeLastKeyPart(dmk) + ".ValLocative";
            miValLocative = (ModelItemDTO)this.getOldDataModel().get(dmkValLocative);
            dmkValFiscale = EngineUtil.removeLastKeyPart(dmk) + ".ValFiscale";
            miValFiscale = (ModelItemDTO)this.getOldDataModel().get(dmkValFiscale);
            if (mi != null && mi.getValue() != null && (idObj = mi.getValue()) instanceof Long) {
                longValue = (Long)idObj;
                long lValue = longValue;
                if (lValue == 1L) {
                    value = value.clone(new Double(0.0));
                }
                if (lValue == 2L) {
                    value = value.clone(new Double(0.0));
                }
                if (lValue == 3L) {
                    value = value.clone(new Double(0.0));
                }
                if (lValue == 4L) {
                    value = value.clone(new Double(0.0));
                }
                if (lValue == 5L) {
                    value = value.clone(new Double(5.97));
                }
                if (lValue == 6L) {
                    value = value.clone(new Double(6.8));
                }
                if (lValue == 7L) {
                    value = value.clone(new Double(7.0));
                }
                if (lValue == 8L) {
                    value = value.clone(new Double(5.47));
                }
            }
            tauxObj = null;
            valLocObj = null;
            if (miValFiscale != null && miValLocative != null && value != null) {
                tauxObj = (Double)value.getValue();
                valLocObj = (Long)miValLocative.getValue();
            }
            if (tauxObj == null || valLocObj == null) continue;
            double taux = tauxObj;
            valLoc = valLocObj;
            if (taux != 0.0) {
                result = new Double(Math.round((double)valLoc / taux * 100.0)).longValue();
                miValFiscale = miValFiscale.clone(new Long(result));
            } else {
                miValFiscale = miValFiscale.clone(null);
            }
            super.storeInNewModel(dmkValFiscale, miValFiscale);
        }
        it = ANNEXE_J.keySet().iterator();
        while (it.hasNext()) {
            current = (String)it.next();
            if (!logicModelKey.equals(current)) continue;
            lmk = (String)ANNEXE_J.get(current);
            dmk = EngineUtil.mergeModelKey(lmk, key);
            mi = (ModelItemDTO)this.getOldDataModel().get(dmk);
            if (mi == null || mi.getValue() == null || !((dateObj = mi.getValue()) instanceof Date)) continue;
            value = value.clone(this.addYear((Date)dateObj, 1));
        }
        it = ANNEXE_K.keySet().iterator();
        while (it.hasNext()) {
            current = (String)it.next();
            if (!logicModelKey.equals(current)) continue;
            lmk = (String)ANNEXE_K.get(current);
            dmk = EngineUtil.mergeModelKey(lmk, key);
            mi = (ModelItemDTO)this.getOldDataModel().get(dmk);
            if (mi == null || mi.getValue() == null || !((dateObj = mi.getValue()) instanceof Date)) continue;
            value = value.clone(this.addYear((Date)dateObj, 1));
        }
        it = DECLA_AF_PAGE_1.keySet().iterator();
        while (it.hasNext()) {
            current = (String)it.next();
            if (!logicModelKey.equals(current)) continue;
            lmk = (String)DECLA_AF_PAGE_1.get(current);
            dmk = EngineUtil.mergeModelKey(lmk, key);
            mi = (ModelItemDTO)this.getOldDataModel().get(dmk);
            if (mi == null || mi.getValue() == null || !((dateObj = mi.getValue()) instanceof Date)) continue;
            dmkDateDebut = EngineUtil.removeLastKeyPart(dmk) + ".DateDeb";
            miDateDebut = (ModelItemDTO)this.getOldDataModel().get(dmkDateDebut);
            if (miDateDebut != null) {
                miDateDebut = miDateDebut.clone(this.addDay((Date)dateObj, 1));
                super.storeInNewModel(dmkDateDebut, miDateDebut);
            }
            value = value.clone(this.addYear((Date)dateObj, 1));
        }
        it = ANNEXE_F_AF.keySet().iterator();
        while (it.hasNext()) {
            current = (String)it.next();
            if (!logicModelKey.equals(current)) continue;
            lmk = (String)ANNEXE_F_AF.get(current);
            dmk = EngineUtil.mergeModelKey(lmk, key);
            mi = (ModelItemDTO)this.getOldDataModel().get(dmk);
            dmkValLocative = EngineUtil.removeLastKeyPart(dmk) + ".ValLocative";
            miValLocative = (ModelItemDTO)this.getOldDataModel().get(dmkValLocative);
            dmkValFiscale = EngineUtil.removeLastKeyPart(dmk) + ".ValFiscale";
            miValFiscale = (ModelItemDTO)this.getOldDataModel().get(dmkValFiscale);
            if (mi != null && mi.getValue() != null && (idObj = mi.getValue()) instanceof Long) {
                longValue = (Long)idObj;
                long lValue = longValue;
                if (lValue == 1L) {
                    value = value.clone(new Double(0.0));
                }
                if (lValue == 2L) {
                    value = value.clone(new Double(0.0));
                }
                if (lValue == 3L) {
                    value = value.clone(new Double(0.0));
                }
                if (lValue == 4L) {
                    value = value.clone(new Double(0.0));
                }
                if (lValue == 5L) {
                    value = value.clone(new Double(5.97));
                }
                if (lValue == 6L) {
                    value = value.clone(new Double(6.8));
                }
                if (lValue == 7L) {
                    value = value.clone(new Double(7.0));
                }
                if (lValue == 8L) {
                    value = value.clone(new Double(5.47));
                }
            }
            tauxObj = null;
            valLocObj = null;
            if (miValFiscale != null && miValLocative != null && value != null) {
                tauxObj = (Double)value.getValue();
                valLocObj = (Long)miValLocative.getValue();
            }
            if (tauxObj == null || valLocObj == null) continue;
            double taux = tauxObj;
            valLoc = valLocObj;
            if (taux != 0.0) {
                result = new Double(Math.round((double)valLoc / taux * 100.0)).longValue();
                miValFiscale = miValFiscale.clone(new Long(result));
            } else {
                miValFiscale = miValFiscale.clone(null);
            }
            super.storeInNewModel(dmkValFiscale, miValFiscale);
        }
        it = ANNEXE_J_AF.keySet().iterator();
        while (it.hasNext()) {
            current = (String)it.next();
            if (!logicModelKey.equals(current)) continue;
            lmk = (String)ANNEXE_J_AF.get(current);
            dmk = EngineUtil.mergeModelKey(lmk, key);
            mi = (ModelItemDTO)this.getOldDataModel().get(dmk);
            if (mi == null || mi.getValue() == null || !((dateObj = mi.getValue()) instanceof Date)) continue;
            value = value.clone(this.addYear((Date)dateObj, 1));
        }
        it = ANNEXE_K_AF.keySet().iterator();
        while (it.hasNext()) {
            current = (String)it.next();
            if (!logicModelKey.equals(current)) continue;
            lmk = (String)ANNEXE_K_AF.get(current);
            dmk = EngineUtil.mergeModelKey(lmk, key);
            mi = (ModelItemDTO)this.getOldDataModel().get(dmk);
            if (mi == null || mi.getValue() == null || !((dateObj = mi.getValue()) instanceof Date)) continue;
            value = value.clone(this.addYear((Date)dateObj, 1));
        }
        super.storeInNewModel(key, value);
    }

    private void deleteDataFromAnnexeM() throws ImportException {
        ArrayList<String> AnnexeM_PertesFiscales = new ArrayList<String>();
        AnnexeM_PertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins1NonImposableSuisse");
        AnnexeM_PertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins1NonImposableCanton");
        AnnexeM_PertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins1ActiviteFinanciereHoldingExempte");
        AnnexeM_PertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins1ActiviteFinanciereDroitCommun");
        AnnexeM_PertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins1ActiviteFinanciere15Pct");
        AnnexeM_PertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins1ActiviteFinanciere2_5Pct");
        AnnexeM_PertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins1ActiviteCommercialeDroitCommun");
        AnnexeM_PertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins1ActiviteCommerciale20Pct");
        AnnexeM_PertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins1ActiviteCommercialeAutre");
        AnnexeM_PertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins2NonImposableSuisse");
        AnnexeM_PertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins2NonImposableCanton");
        AnnexeM_PertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins2ActiviteFinanciereHoldingExempte");
        AnnexeM_PertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins2ActiviteFinanciereDroitCommun");
        AnnexeM_PertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins2ActiviteFinanciere15Pct");
        AnnexeM_PertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins2ActiviteFinanciere2_5Pct");
        AnnexeM_PertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins2ActiviteCommercialeDroitCommun");
        AnnexeM_PertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins2ActiviteCommerciale20Pct");
        AnnexeM_PertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins2ActiviteCommercialeAutre");
        AnnexeM_PertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins3NonImposableSuisse");
        AnnexeM_PertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins3NonImposableCanton");
        AnnexeM_PertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins3ActiviteFinanciereHoldingExempte");
        AnnexeM_PertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins3ActiviteFinanciereDroitCommun");
        AnnexeM_PertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins3ActiviteFinanciere15Pct");
        AnnexeM_PertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins3ActiviteFinanciere2_5Pct");
        AnnexeM_PertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins3ActiviteCommercialeDroitCommun");
        AnnexeM_PertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins3ActiviteCommerciale20Pct");
        AnnexeM_PertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins3ActiviteCommercialeAutre");
        AnnexeM_PertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins4NonImposableSuisse");
        AnnexeM_PertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins4NonImposableCanton");
        AnnexeM_PertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins4ActiviteFinanciereHoldingExempte");
        AnnexeM_PertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins4ActiviteFinanciereDroitCommun");
        AnnexeM_PertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins4ActiviteFinanciere15Pct");
        AnnexeM_PertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins4ActiviteFinanciere2_5Pct");
        AnnexeM_PertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins4ActiviteCommercialeDroitCommun");
        AnnexeM_PertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins4ActiviteCommerciale20Pct");
        AnnexeM_PertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins4ActiviteCommercialeAutre");
        AnnexeM_PertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins5NonImposableSuisse");
        AnnexeM_PertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins5NonImposableCanton");
        AnnexeM_PertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins5ActiviteFinanciereHoldingExempte");
        AnnexeM_PertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins5ActiviteFinanciereDroitCommun");
        AnnexeM_PertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins5ActiviteFinanciere15Pct");
        AnnexeM_PertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins5ActiviteFinanciere2_5Pct");
        AnnexeM_PertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins5ActiviteCommercialeDroitCommun");
        AnnexeM_PertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins5ActiviteCommerciale20Pct");
        AnnexeM_PertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins5ActiviteCommercialeAutre");
        AnnexeM_PertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins6NonImposableSuisse");
        AnnexeM_PertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins6NonImposableCanton");
        AnnexeM_PertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins6ActiviteFinanciereHoldingExempte");
        AnnexeM_PertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins6ActiviteFinanciereDroitCommun");
        AnnexeM_PertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins6ActiviteFinanciere15Pct");
        AnnexeM_PertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins6ActiviteFinanciere2_5Pct");
        AnnexeM_PertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins6ActiviteCommercialeDroitCommun");
        AnnexeM_PertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins6ActiviteCommerciale20Pct");
        AnnexeM_PertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins6ActiviteCommercialeAutre");
        AnnexeM_PertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins7NonImposableSuisse");
        AnnexeM_PertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins7NonImposableCanton");
        AnnexeM_PertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins7ActiviteFinanciereHoldingExempte");
        AnnexeM_PertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins7ActiviteFinanciereDroitCommun");
        AnnexeM_PertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins7ActiviteFinanciere15Pct");
        AnnexeM_PertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins7ActiviteFinanciere2_5Pct");
        AnnexeM_PertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins7ActiviteCommercialeDroitCommun");
        AnnexeM_PertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins7ActiviteCommerciale20Pct");
        AnnexeM_PertesFiscales.add("AnnexeM.Page2.PertesFiscales.PerteAnneeMoins7ActiviteCommercialeAutre");
        String ANNEXE_M_10_1 = "AnnexeM.Page2.TransfertCategorie.BeneficeNetTotalCantonTotalImposableCanton";
        Long champ_10_1 = null;
        ModelItemDTO item_10_1 = (ModelItemDTO)this.getOldDataModel().get("AnnexeM.Page2.TransfertCategorie.BeneficeNetTotalCantonTotalImposableCanton");
        if (item_10_1 != null) {
            Object champ_10_1_Obj = item_10_1.getValue();
            if (champ_10_1_Obj != null && champ_10_1_Obj instanceof Long) {
                champ_10_1 = (Long)champ_10_1_Obj;
            }
            if (champ_10_1 != null && champ_10_1 > 0L) {
                Iterator it = AnnexeM_PertesFiscales.iterator();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    ModelItemDTO item = (ModelItemDTO)this.getNewDataModel().get(key);
                    if (item == null || item.getValue() == null) continue;
                    item = item.clone(null);
                    super.storeInNewModel(key, item);
                }
            }
        }
    }

    private void importReservesGenerales() throws ImportException {
        Object reservesICC_obj;
        String RESERVES_LEGALES_PERIODE_PRECEDENTE = "Declaration.Form3.UtilisationBenefice.AttributionRL";
        String RESERVES_GENERALES_ICC = "Declaration.Form3.CapitalPropre.ReserveGeneraleICC";
        ModelItemDTO miReservesICC = (ModelItemDTO)this.getOldDataModel().get("Declaration.Form3.CapitalPropre.ReserveGeneraleICC");
        ModelItemDTO miReservesPeriodePrecedente = (ModelItemDTO)this.getOldDataModel().get("Declaration.Form3.UtilisationBenefice.AttributionRL");
        ModelItemDTO miReservesICCNew = (ModelItemDTO)this.getNewDataModel().get("Declaration.Form3.CapitalPropre.ReserveGeneraleICC");
        if (miReservesICC == null && miReservesPeriodePrecedente == null && miReservesICCNew == null) {
            return;
        }
        long newValue = 0L;
        if (miReservesICC != null && miReservesICC.getValue() != null && (reservesICC_obj = miReservesICC.getValue()) instanceof Long) {
            newValue = (Long)reservesICC_obj;
        }
        if (miReservesPeriodePrecedente != null && miReservesPeriodePrecedente.getValue() != null) {
            Object reservesPeriodePrecedente_obj = miReservesPeriodePrecedente.getValue();
            newValue += ((Long)reservesPeriodePrecedente_obj).longValue();
            miReservesPeriodePrecedente = miReservesPeriodePrecedente.clone(null);
            super.storeInNewModel("Declaration.Form3.UtilisationBenefice.AttributionRL", miReservesPeriodePrecedente);
        }
        miReservesICCNew = newValue != 0L ? miReservesICC.clone(new Long(newValue)) : miReservesICC.clone(null);
        super.storeInNewModel("Declaration.Form3.CapitalPropre.ReserveGeneraleICC", miReservesICCNew);
    }

    private void importReservesStatutaires() throws ImportException {
        Object reservesICC_obj;
        String RESERVES_STATUTAIRES_PERIODE_PRECEDENTE = "Declaration.Form3.UtilisationBenefice.AttributionRS";
        String RESERVES_STATUTAIRES_ICC = "Declaration.Form3.CapitalPropre.ReservesStatuairesICC";
        ModelItemDTO miReservesICC = (ModelItemDTO)this.getOldDataModel().get("Declaration.Form3.CapitalPropre.ReservesStatuairesICC");
        ModelItemDTO miReservesPeriodePrecedente = (ModelItemDTO)this.getOldDataModel().get("Declaration.Form3.UtilisationBenefice.AttributionRS");
        ModelItemDTO miReservesICCNew = (ModelItemDTO)this.getNewDataModel().get("Declaration.Form3.CapitalPropre.ReservesStatuairesICC");
        if (miReservesICC == null && miReservesPeriodePrecedente == null && miReservesICCNew == null) {
            return;
        }
        long newValue = 0L;
        if (miReservesICC != null && miReservesICC.getValue() != null && (reservesICC_obj = miReservesICC.getValue()) instanceof Long) {
            newValue = (Long)reservesICC_obj;
        }
        if (miReservesPeriodePrecedente != null && miReservesPeriodePrecedente.getValue() != null) {
            Object reservesPeriodePrecedente_obj = miReservesPeriodePrecedente.getValue();
            newValue += ((Long)reservesPeriodePrecedente_obj).longValue();
            miReservesPeriodePrecedente = miReservesPeriodePrecedente.clone(null);
            super.storeInNewModel("Declaration.Form3.UtilisationBenefice.AttributionRS", miReservesPeriodePrecedente);
        }
        miReservesICCNew = newValue != 0L ? miReservesICC.clone(new Long(newValue)) : miReservesICC.clone(null);
        super.storeInNewModel("Declaration.Form3.CapitalPropre.ReservesStatuairesICC", miReservesICCNew);
    }

    private void traitePertesFiscalesSA_ICC() throws ImportException {
        String RESULTAT_FISCAL = "Declaration.Form2.ResultatFiscalICC";
        String EXERCICE_MOINS_1 = "Declaration.Form4.PertesReportees.ExerciceNMoinsUnICC";
        String EXERCICE_MOINS_2 = "Declaration.Form4.PertesReportees.ExerciceNMoinsDeuxICC";
        String EXERCICE_MOINS_3 = "Declaration.Form4.PertesReportees.ExerciceNMoinsTroisICC";
        String EXERCICE_MOINS_4 = "Declaration.Form4.PertesReportees.ExerciceNMoinsQuatreICC";
        String EXERCICE_MOINS_5 = "Declaration.Form4.PertesReportees.ExerciceNMoinsCinqICC";
        String EXERCICE_MOINS_6 = "Declaration.Form4.PertesReportees.ExerciceNMoinsSixICC";
        String EXERCICE_MOINS_7 = "Declaration.Form4.PertesReportees.ExerciceNMoinsSeptICC";
        this.setPertesFiscales("Declaration.Form2.ResultatFiscalICC", "Declaration.Form4.PertesReportees.ExerciceNMoinsUnICC", "Declaration.Form4.PertesReportees.ExerciceNMoinsDeuxICC", "Declaration.Form4.PertesReportees.ExerciceNMoinsTroisICC", "Declaration.Form4.PertesReportees.ExerciceNMoinsQuatreICC", "Declaration.Form4.PertesReportees.ExerciceNMoinsCinqICC", "Declaration.Form4.PertesReportees.ExerciceNMoinsSixICC", "Declaration.Form4.PertesReportees.ExerciceNMoinsSeptICC");
    }

    private void traitePertesFiscalesSA_IFD() throws ImportException {
        String RESULTAT_FISCAL = "Declaration.Form2.ResultatFiscalIFD";
        String EXERCICE_MOINS_1 = "Declaration.Form4.PertesReportees.ExerciceNMoinsUnIFD";
        String EXERCICE_MOINS_2 = "Declaration.Form4.PertesReportees.ExerciceNMoinsDeuxIFD";
        String EXERCICE_MOINS_3 = "Declaration.Form4.PertesReportees.ExerciceNMoinsTroisIFD";
        String EXERCICE_MOINS_4 = "Declaration.Form4.PertesReportees.ExerciceNMoinsQuatreIFD";
        String EXERCICE_MOINS_5 = "Declaration.Form4.PertesReportees.ExerciceNMoinsCinqIFD";
        String EXERCICE_MOINS_6 = "Declaration.Form4.PertesReportees.ExerciceNMoinsSixIFD";
        String EXERCICE_MOINS_7 = "Declaration.Form4.PertesReportees.ExerciceNMoinsSeptIFD";
        this.setPertesFiscales("Declaration.Form2.ResultatFiscalIFD", "Declaration.Form4.PertesReportees.ExerciceNMoinsUnIFD", "Declaration.Form4.PertesReportees.ExerciceNMoinsDeuxIFD", "Declaration.Form4.PertesReportees.ExerciceNMoinsTroisIFD", "Declaration.Form4.PertesReportees.ExerciceNMoinsQuatreIFD", "Declaration.Form4.PertesReportees.ExerciceNMoinsCinqIFD", "Declaration.Form4.PertesReportees.ExerciceNMoinsSixIFD", "Declaration.Form4.PertesReportees.ExerciceNMoinsSeptIFD");
    }

    private void traitePertesFiscalesAF_ICC() throws ImportException {
        String RESULTAT_FISCAL = "Declaration_af.Form2_af.ResultatFiscal.ResultatFiscalICC";
        String EXERCICE_MOINS_1 = "Declaration_af.Form4_af.PertesReportees.ExerciceNMoinsUnICC";
        String EXERCICE_MOINS_2 = "Declaration_af.Form4_af.PertesReportees.ExerciceNMoinsDeuxICC";
        String EXERCICE_MOINS_3 = "Declaration_af.Form4_af.PertesReportees.ExerciceNMoinsTroisICC";
        String EXERCICE_MOINS_4 = "Declaration_af.Form4_af.PertesReportees.ExerciceNMoinsQuatreICC";
        String EXERCICE_MOINS_5 = "Declaration_af.Form4_af.PertesReportees.ExerciceNMoinsCinqICC";
        String EXERCICE_MOINS_6 = "Declaration_af.Form4_af.PertesReportees.ExerciceNMoinsSixICC";
        String EXERCICE_MOINS_7 = "Declaration_af.Form4_af.PertesReportees.ExerciceNMoinsSeptICC";
        this.setPertesFiscales("Declaration_af.Form2_af.ResultatFiscal.ResultatFiscalICC", "Declaration_af.Form4_af.PertesReportees.ExerciceNMoinsUnICC", "Declaration_af.Form4_af.PertesReportees.ExerciceNMoinsDeuxICC", "Declaration_af.Form4_af.PertesReportees.ExerciceNMoinsTroisICC", "Declaration_af.Form4_af.PertesReportees.ExerciceNMoinsQuatreICC", "Declaration_af.Form4_af.PertesReportees.ExerciceNMoinsCinqICC", "Declaration_af.Form4_af.PertesReportees.ExerciceNMoinsSixICC", "Declaration_af.Form4_af.PertesReportees.ExerciceNMoinsSeptICC");
    }

    private void traitePertesFiscalesAF_IFD() throws ImportException {
        String RESULTAT_FISCAL = "Declaration_af.Form2_af.ResultatFiscal.ResultatFiscalIFD";
        String EXERCICE_MOINS_1 = "Declaration_af.Form4_af.PertesReportees.ExerciceNMoinsUnIFD";
        String EXERCICE_MOINS_2 = "Declaration_af.Form4_af.PertesReportees.ExerciceNMoinsDeuxIFD";
        String EXERCICE_MOINS_3 = "Declaration_af.Form4_af.PertesReportees.ExerciceNMoinsTroisIFD";
        String EXERCICE_MOINS_4 = "Declaration_af.Form4_af.PertesReportees.ExerciceNMoinsQuatreIFD";
        String EXERCICE_MOINS_5 = "Declaration_af.Form4_af.PertesReportees.ExerciceNMoinsCinqIFD";
        String EXERCICE_MOINS_6 = "Declaration_af.Form4_af.PertesReportees.ExerciceNMoinsSixIFD";
        String EXERCICE_MOINS_7 = "Declaration_af.Form4_af.PertesReportees.ExerciceNMoinsSeptIFD";
        this.setPertesFiscales("Declaration_af.Form2_af.ResultatFiscal.ResultatFiscalIFD", "Declaration_af.Form4_af.PertesReportees.ExerciceNMoinsUnIFD", "Declaration_af.Form4_af.PertesReportees.ExerciceNMoinsDeuxIFD", "Declaration_af.Form4_af.PertesReportees.ExerciceNMoinsTroisIFD", "Declaration_af.Form4_af.PertesReportees.ExerciceNMoinsQuatreIFD", "Declaration_af.Form4_af.PertesReportees.ExerciceNMoinsCinqIFD", "Declaration_af.Form4_af.PertesReportees.ExerciceNMoinsSixIFD", "Declaration_af.Form4_af.PertesReportees.ExerciceNMoinsSeptIFD");
    }

    private void setPertesFiscales(String resultatFiscal, String m_1, String m_2, String m_3, String m_4, String m_5, String m_6, String m_7) throws ImportException {
        ModelItemDTO miResultatFiscal = (ModelItemDTO)this.getOldDataModel().get(resultatFiscal);
        ModelItemDTO miMoins_1 = (ModelItemDTO)this.getNewDataModel().get(m_1);
        ModelItemDTO miMoins_2 = (ModelItemDTO)this.getNewDataModel().get(m_2);
        ModelItemDTO miMoins_3 = (ModelItemDTO)this.getNewDataModel().get(m_3);
        ModelItemDTO miMoins_4 = (ModelItemDTO)this.getNewDataModel().get(m_4);
        ModelItemDTO miMoins_5 = (ModelItemDTO)this.getNewDataModel().get(m_5);
        ModelItemDTO miMoins_6 = (ModelItemDTO)this.getNewDataModel().get(m_6);
        ModelItemDTO miMoins_7 = (ModelItemDTO)this.getNewDataModel().get(m_7);
        ModelItemDTO miPertePerdue = (ModelItemDTO)this.getOldDataModel().get(m_7);
        long lResultatFiscal = 0L;
        long lPerteMoins_1 = 0L;
        long lPerteMoins_2 = 0L;
        long lPerteMoins_3 = 0L;
        long lPerteMoins_4 = 0L;
        long lPerteMoins_5 = 0L;
        long lPerteMoins_6 = 0L;
        long lPerteMoins_7 = 0L;
        long lPertePerdue = 0L;
        if (miResultatFiscal != null && miResultatFiscal.getValue() != null) {
            Object ResultatFiscal_obj = miResultatFiscal.getValue();
            if (ResultatFiscal_obj instanceof Long) {
                lResultatFiscal = (Long)ResultatFiscal_obj;
            }
            if (lResultatFiscal > 0L) {
                long solde;
                Object PertePerdue_obj;
                Object PerteMoins_7_obj;
                Object PerteMoins_6_obj;
                Object PerteMoins_5_obj;
                Object PerteMoins_4_obj;
                Object PerteMoins_3_obj;
                Object PerteMoins_2_obj;
                if (miMoins_1 != null) {
                    miMoins_1 = miMoins_1.clone(null);
                    super.storeInNewModel(m_1, miMoins_1);
                }
                if (miMoins_2 != null && miMoins_2.getValue() != null && (PerteMoins_2_obj = miMoins_2.getValue()) instanceof Long) {
                    lPerteMoins_2 = (Long)PerteMoins_2_obj;
                }
                if (miMoins_3 != null && miMoins_3.getValue() != null && (PerteMoins_3_obj = miMoins_3.getValue()) instanceof Long) {
                    lPerteMoins_3 = (Long)PerteMoins_3_obj;
                }
                if (miMoins_4 != null && miMoins_4.getValue() != null && (PerteMoins_4_obj = miMoins_4.getValue()) instanceof Long) {
                    lPerteMoins_4 = (Long)PerteMoins_4_obj;
                }
                if (miMoins_5 != null && miMoins_5.getValue() != null && (PerteMoins_5_obj = miMoins_5.getValue()) instanceof Long) {
                    lPerteMoins_5 = (Long)PerteMoins_5_obj;
                }
                if (miMoins_6 != null && miMoins_6.getValue() != null && (PerteMoins_6_obj = miMoins_6.getValue()) instanceof Long) {
                    lPerteMoins_6 = (Long)PerteMoins_6_obj;
                }
                if (miMoins_7 != null && miMoins_7.getValue() != null && (PerteMoins_7_obj = miMoins_7.getValue()) instanceof Long) {
                    lPerteMoins_7 = (Long)PerteMoins_7_obj;
                }
                if (miPertePerdue != null && miPertePerdue.getValue() != null && (PertePerdue_obj = miPertePerdue.getValue()) instanceof Long) {
                    lPertePerdue = (Long)PertePerdue_obj;
                }
                if ((solde = lResultatFiscal - lPertePerdue) > 0L) {
                    if ((solde -= lPerteMoins_7) >= 0L) {
                        if (miMoins_7 != null) {
                            miMoins_7 = miMoins_7.clone(null);
                            super.storeInNewModel(m_7, miMoins_7);
                        }
                        if ((solde -= lPerteMoins_6) >= 0L) {
                            if (miMoins_6 != null) {
                                miMoins_6 = miMoins_6.clone(null);
                                super.storeInNewModel(m_6, miMoins_6);
                            }
                            if ((solde -= lPerteMoins_5) >= 0L) {
                                if (miMoins_5 != null) {
                                    miMoins_5 = miMoins_5.clone(null);
                                    super.storeInNewModel(m_5, miMoins_5);
                                }
                                if ((solde -= lPerteMoins_4) >= 0L) {
                                    if (miMoins_4 != null) {
                                        miMoins_4 = miMoins_4.clone(null);
                                        super.storeInNewModel(m_4, miMoins_4);
                                    }
                                    if ((solde -= lPerteMoins_3) >= 0L) {
                                        if (miMoins_3 != null) {
                                            miMoins_3 = miMoins_3.clone(null);
                                            super.storeInNewModel(m_3, miMoins_3);
                                        }
                                        if ((solde -= lPerteMoins_2) >= 0L) {
                                            if (miMoins_2 != null) {
                                                miMoins_2 = miMoins_2.clone(null);
                                                super.storeInNewModel(m_2, miMoins_2);
                                            }
                                        } else if (miMoins_2 != null) {
                                            miMoins_2 = miMoins_2.clone(new Long(solde * -1L));
                                            super.storeInNewModel(m_2, miMoins_2);
                                        }
                                    } else if (miMoins_3 != null) {
                                        miMoins_3 = miMoins_3.clone(new Long(solde * -1L));
                                        super.storeInNewModel(m_3, miMoins_3);
                                    }
                                } else if (miMoins_4 != null) {
                                    miMoins_4 = miMoins_4.clone(new Long(solde * -1L));
                                    super.storeInNewModel(m_4, miMoins_4);
                                }
                            } else if (miMoins_5 != null) {
                                miMoins_5 = miMoins_5.clone(new Long(solde * -1L));
                                super.storeInNewModel(m_5, miMoins_5);
                            }
                        } else if (miMoins_6 != null) {
                            miMoins_6 = miMoins_6.clone(new Long(solde * -1L));
                            super.storeInNewModel(m_6, miMoins_6);
                        }
                    } else if (miMoins_7 != null) {
                        miMoins_7 = miMoins_7.clone(new Long(solde * -1L));
                        super.storeInNewModel(m_7, miMoins_7);
                    }
                }
            } else {
                Object PerteMoins_1_obj = miMoins_1.getValue();
                if (PerteMoins_1_obj instanceof Long) {
                    lPerteMoins_1 = (Long)PerteMoins_1_obj;
                    miMoins_1 = miMoins_1.clone(new Long(lPerteMoins_1 * -1L));
                    super.storeInNewModel(m_1, miMoins_1);
                }
            }
        }
    }

    private Date addYear(Date date, int nbreAnnee) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(1, nbreAnnee);
        return calendar.getTime();
    }

    private Date addDay(Date dateFinExercicePrecedent, int nbreJour) {
        GregorianCalendar calendarFinExercicePrecedent = new GregorianCalendar();
        calendarFinExercicePrecedent.setTime(dateFinExercicePrecedent);
        GregorianCalendar calFinPeriodePrecedente = new GregorianCalendar();
        calFinPeriodePrecedente.set(2008, 11, 31);
        calendarFinExercicePrecedent.setTime(dateFinExercicePrecedent);
        ((Calendar)calendarFinExercicePrecedent).add(6, nbreJour);
        if (calendarFinExercicePrecedent.get(1) != calFinPeriodePrecedente.get(1) || calendarFinExercicePrecedent.get(2) != calFinPeriodePrecedente.get(2) || calendarFinExercicePrecedent.get(5) != calFinPeriodePrecedente.get(5)) {
            dateFinExercicePrecedent = this.addYear(dateFinExercicePrecedent, 1);
        }
        return calendarFinExercicePrecedent.getTime();
    }

    static {
        HashMap<String, String> champscalcules = new HashMap<String, String>();
        champscalcules.put("Declaration.Form1.DateFin", "Declaration.Form1.DateFin");
        DECLA_PAGE_1 = Collections.unmodifiableMap(champscalcules);
        champscalcules = new HashMap();
        champscalcules.put("Declaration_af.Form1_af.DateFin", "Declaration_af.Form1_af.DateFin");
        DECLA_AF_PAGE_1 = Collections.unmodifiableMap(champscalcules);
        champscalcules = new HashMap();
        champscalcules.put("AnnexeF.ValeurFiscale.ImmLoueGeneve.TauxCapitalisation", "AnnexeF.ValeurFiscale.ImmLoueGeneve.TauxCapitalisation");
        champscalcules.put("AnnexeF.ValeurFiscale.ImmOccupeGeneve.TauxCapitalisation", "AnnexeF.ValeurFiscale.ImmOccupeGeneve.TauxCapitalisation");
        ANNEXE_F = Collections.unmodifiableMap(champscalcules);
        champscalcules = new HashMap();
        champscalcules.put("AnnexeF_af.ValeurFiscale.ImmLoueGeneve.TauxCapitalisation", "AnnexeF_af.ValeurFiscale.ImmLoueGeneve.TauxCapitalisation");
        champscalcules.put("AnnexeF_af.ValeurFiscale.ImmOccupeGeneve.TauxCapitalisation", "AnnexeF_af.ValeurFiscale.ImmOccupeGeneve.TauxCapitalisation");
        ANNEXE_F_AF = Collections.unmodifiableMap(champscalcules);
        champscalcules = new HashMap();
        champscalcules.put("AnnexeJ.AJ.Page1.ForPrincipal.DebutA", "AnnexeJ.AJ.Page1.ForPrincipal.DebutA");
        champscalcules.put("AnnexeJ.AJ.Page1.ForPrincipal.DebutB", "AnnexeJ.AJ.Page1.ForPrincipal.DebutB");
        champscalcules.put("AnnexeJ.AJ.Page1.ForPrincipal.DebutC", "AnnexeJ.AJ.Page1.ForPrincipal.DebutC");
        champscalcules.put("AnnexeJ.AJ.Page1.ForPrincipal.DebutD", "AnnexeJ.AJ.Page1.ForPrincipal.DebutD");
        champscalcules.put("AnnexeJ.AJ.Page1.ForPrincipal.DebutE", "AnnexeJ.AJ.Page1.ForPrincipal.DebutE");
        champscalcules.put("AnnexeJ.AJ.Page1.ForPrincipal.FinA", "AnnexeJ.AJ.Page1.ForPrincipal.FinA");
        champscalcules.put("AnnexeJ.AJ.Page1.ForPrincipal.FinB", "AnnexeJ.AJ.Page1.ForPrincipal.FinB");
        champscalcules.put("AnnexeJ.AJ.Page1.ForPrincipal.FinC", "AnnexeJ.AJ.Page1.ForPrincipal.FinC");
        champscalcules.put("AnnexeJ.AJ.Page1.ForPrincipal.FinD", "AnnexeJ.AJ.Page1.ForPrincipal.FinD");
        champscalcules.put("AnnexeJ.AJ.Page1.ForPrincipal.FinE", "AnnexeJ.AJ.Page1.ForPrincipal.FinE");
        champscalcules.put("AnnexeJ.AJ.Page1.ForsSecondaires.DebutA", "AnnexeJ.AJ.Page1.ForsSecondaires.DebutA");
        champscalcules.put("AnnexeJ.AJ.Page1.ForsSecondaires.DebutB", "AnnexeJ.AJ.Page1.ForsSecondaires.DebutB");
        champscalcules.put("AnnexeJ.AJ.Page1.ForsSecondaires.DebutC", "AnnexeJ.AJ.Page1.ForsSecondaires.DebutC");
        champscalcules.put("AnnexeJ.AJ.Page1.ForsSecondaires.DebutD", "AnnexeJ.AJ.Page1.ForsSecondaires.DebutD");
        champscalcules.put("AnnexeJ.AJ.Page1.ForsSecondaires.DebutE", "AnnexeJ.AJ.Page1.ForsSecondaires.DebutE");
        champscalcules.put("AnnexeJ.AJ.Page1.ForsSecondaires.FinA", "AnnexeJ.AJ.Page1.ForsSecondaires.FinA");
        champscalcules.put("AnnexeJ.AJ.Page1.ForsSecondaires.FinB", "AnnexeJ.AJ.Page1.ForsSecondaires.FinB");
        champscalcules.put("AnnexeJ.AJ.Page1.ForsSecondaires.FinC", "AnnexeJ.AJ.Page1.ForsSecondaires.FinC");
        champscalcules.put("AnnexeJ.AJ.Page1.ForsSecondaires.FinD", "AnnexeJ.AJ.Page1.ForsSecondaires.FinD");
        champscalcules.put("AnnexeJ.AJ.Page1.ForsSecondaires.FinE", "AnnexeJ.AJ.Page1.ForsSecondaires.FinE");
        champscalcules.put("AnnexeJ.AJ.Page1.ForsSpeciaux.DebutA", "AnnexeJ.AJ.Page1.ForsSpeciaux.DebutA");
        champscalcules.put("AnnexeJ.AJ.Page1.ForsSpeciaux.DebutB", "AnnexeJ.AJ.Page1.ForsSpeciaux.DebutB");
        champscalcules.put("AnnexeJ.AJ.Page1.ForsSpeciaux.DebutC", "AnnexeJ.AJ.Page1.ForsSpeciaux.DebutC");
        champscalcules.put("AnnexeJ.AJ.Page1.ForsSpeciaux.DebutD", "AnnexeJ.AJ.Page1.ForsSpeciaux.DebutD");
        champscalcules.put("AnnexeJ.AJ.Page1.ForsSpeciaux.DebutE", "AnnexeJ.AJ.Page1.ForsSpeciaux.DebutE");
        champscalcules.put("AnnexeJ.AJ.Page1.ForsSpeciaux.FinA", "AnnexeJ.AJ.Page1.ForsSpeciaux.FinA");
        champscalcules.put("AnnexeJ.AJ.Page1.ForsSpeciaux.FinB", "AnnexeJ.AJ.Page1.ForsSpeciaux.FinB");
        champscalcules.put("AnnexeJ.AJ.Page1.ForsSpeciaux.FinC", "AnnexeJ.AJ.Page1.ForsSpeciaux.FinC");
        champscalcules.put("AnnexeJ.AJ.Page1.ForsSpeciaux.FinD", "AnnexeJ.AJ.Page1.ForsSpeciaux.FinD");
        champscalcules.put("AnnexeJ.AJ.Page1.ForsSpeciaux.FinE", "AnnexeJ.AJ.Page1.ForsSpeciaux.FinE");
        ANNEXE_J = Collections.unmodifiableMap(champscalcules);
        champscalcules = new HashMap();
        champscalcules.put("AnnexeJ_af.AJ_af.Page1_af.ForPrincipal.DebutA", "AnnexeJ_af.AJ_af.Page1_af.ForPrincipal.DebutA");
        champscalcules.put("AnnexeJ_af.AJ_af.Page1_af.ForPrincipal.DebutB", "AnnexeJ_af.AJ_af.Page1_af.ForPrincipal.DebutB");
        champscalcules.put("AnnexeJ_af.AJ_af.Page1_af.ForPrincipal.DebutC", "AnnexeJ_af.AJ_af.Page1_af.ForPrincipal.DebutC");
        champscalcules.put("AnnexeJ_af.AJ_af.Page1_af.ForPrincipal.DebutD", "AnnexeJ_af.AJ_af.Page1_af.ForPrincipal.DebutD");
        champscalcules.put("AnnexeJ_af.AJ_af.Page1_af.ForPrincipal.DebutE", "AnnexeJ_af.AJ_af.Page1_af.ForPrincipal.DebutE");
        champscalcules.put("AnnexeJ_af.AJ_af.Page1_af.ForPrincipal.FinA", "AnnexeJ_af.AJ_af.Page1_af.ForPrincipal.FinA");
        champscalcules.put("AnnexeJ_af.AJ_af.Page1_af.ForPrincipal.FinB", "AnnexeJ_af.AJ_af.Page1_af.ForPrincipal.FinB");
        champscalcules.put("AnnexeJ_af.AJ_af.Page1_af.ForPrincipal.FinC", "AnnexeJ_af.AJ_af.Page1_af.ForPrincipal.FinC");
        champscalcules.put("AnnexeJ_af.AJ_af.Page1_af.ForPrincipal.FinD", "AnnexeJ_af.AJ_af.Page1_af.ForPrincipal.FinD");
        champscalcules.put("AnnexeJ_af.AJ_af.Page1_af.ForPrincipal.FinE", "AnnexeJ_af.AJ_af.Page1_af.ForPrincipal.FinE");
        champscalcules.put("AnnexeJ_af.AJ_af.Page1_af.ForsSecondaires.DebutA", "AnnexeJ_af.AJ_af.Page1_af.ForsSecondaires.DebutA");
        champscalcules.put("AnnexeJ_af.AJ_af.Page1_af.ForsSecondaires.DebutB", "AnnexeJ_af.AJ_af.Page1_af.ForsSecondaires.DebutB");
        champscalcules.put("AnnexeJ_af.AJ_af.Page1_af.ForsSecondaires.DebutC", "AnnexeJ_af.AJ_af.Page1_af.ForsSecondaires.DebutC");
        champscalcules.put("AnnexeJ_af.AJ_af.Page1_af.ForsSecondaires.DebutD", "AnnexeJ_af.AJ_af.Page1_af.ForsSecondaires.DebutD");
        champscalcules.put("AnnexeJ_af.AJ_af.Page1_af.ForsSecondaires.DebutE", "AnnexeJ_af.AJ_af.Page1_af.ForsSecondaires.DebutE");
        champscalcules.put("AnnexeJ_af.AJ_af.Page1_af.ForsSecondaires.FinA", "AnnexeJ_af.AJ_af.Page1_af.ForsSecondaires.FinA");
        champscalcules.put("AnnexeJ_af.AJ_af.Page1_af.ForsSecondaires.FinB", "AnnexeJ_af.AJ_af.Page1_af.ForsSecondaires.FinB");
        champscalcules.put("AnnexeJ_af.AJ_af.Page1_af.ForsSecondaires.FinC", "AnnexeJ_af.AJ_af.Page1_af.ForsSecondaires.FinC");
        champscalcules.put("AnnexeJ_af.AJ_af.Page1_af.ForsSecondaires.FinD", "AnnexeJ_af.AJ_af.Page1_af.ForsSecondaires.FinD");
        champscalcules.put("AnnexeJ_af.AJ_af.Page1_af.ForsSecondaires.FinE", "AnnexeJ_af.AJ_af.Page1_af.ForsSecondaires.FinE");
        champscalcules.put("AnnexeJ_af.AJ_af.Page1_af.ForsSpeciaux.DebutA", "AnnexeJ_af.AJ_af.Page1_af.ForsSpeciaux.DebutA");
        champscalcules.put("AnnexeJ_af.AJ_af.Page1_af.ForsSpeciaux.DebutB", "AnnexeJ_af.AJ_af.Page1_af.ForsSpeciaux.DebutB");
        champscalcules.put("AnnexeJ_af.AJ_af.Page1_af.ForsSpeciaux.DebutC", "AnnexeJ_af.AJ_af.Page1_af.ForsSpeciaux.DebutC");
        champscalcules.put("AnnexeJ_af.AJ_af.Page1_af.ForsSpeciaux.DebutD", "AnnexeJ_af.AJ_af.Page1_af.ForsSpeciaux.DebutD");
        champscalcules.put("AnnexeJ_af.AJ_af.Page1_af.ForsSpeciaux.DebutE", "AnnexeJ_af.AJ_af.Page1_af.ForsSpeciaux.DebutE");
        champscalcules.put("AnnexeJ_af.AJ_af.Page1_af.ForsSpeciaux.FinA", "AnnexeJ_af.AJ_af.Page1_af.ForsSpeciaux.FinA");
        champscalcules.put("AnnexeJ_af.AJ_af.Page1_af.ForsSpeciaux.FinB", "AnnexeJ_af.AJ_af.Page1_af.ForsSpeciaux.FinB");
        champscalcules.put("AnnexeJ_af.AJ_af.Page1_af.ForsSpeciaux.FinC", "AnnexeJ_af.AJ_af.Page1_af.ForsSpeciaux.FinC");
        champscalcules.put("AnnexeJ_af.AJ_af.Page1_af.ForsSpeciaux.FinD", "AnnexeJ_af.AJ_af.Page1_af.ForsSpeciaux.FinD");
        champscalcules.put("AnnexeJ_af.AJ_af.Page1_af.ForsSpeciaux.FinE", "AnnexeJ_af.AJ_af.Page1_af.ForsSpeciaux.FinE");
        ANNEXE_J_AF = Collections.unmodifiableMap(champscalcules);
        champscalcules = new HashMap();
        champscalcules.put("AnnexeK.AK.Page1.ForPrincipal.DebutA", "AnnexeK.AK.Page1.ForPrincipal.DebutA");
        champscalcules.put("AnnexeK.AK.Page1.ForPrincipal.DebutB", "AnnexeK.AK.Page1.ForPrincipal.DebutB");
        champscalcules.put("AnnexeK.AK.Page1.ForPrincipal.DebutC", "AnnexeK.AK.Page1.ForPrincipal.DebutC");
        champscalcules.put("AnnexeK.AK.Page1.ForPrincipal.DebutD", "AnnexeK.AK.Page1.ForPrincipal.DebutD");
        champscalcules.put("AnnexeK.AK.Page1.ForPrincipal.DebutE", "AnnexeK.AK.Page1.ForPrincipal.DebutE");
        champscalcules.put("AnnexeK.AK.Page1.ForPrincipal.FinA", "AnnexeK.AK.Page1.ForPrincipal.FinA");
        champscalcules.put("AnnexeK.AK.Page1.ForPrincipal.FinB", "AnnexeK.AK.Page1.ForPrincipal.FinB");
        champscalcules.put("AnnexeK.AK.Page1.ForPrincipal.FinC", "AnnexeK.AK.Page1.ForPrincipal.FinC");
        champscalcules.put("AnnexeK.AK.Page1.ForPrincipal.FinD", "AnnexeK.AK.Page1.ForPrincipal.FinD");
        champscalcules.put("AnnexeK.AK.Page1.ForPrincipal.FinE", "AnnexeK.AK.Page1.ForPrincipal.FinE");
        champscalcules.put("AnnexeK.AK.Page1.ForsSecondaires.DebutA", "AnnexeK.AK.Page1.ForsSecondaires.DebutA");
        champscalcules.put("AnnexeK.AK.Page1.ForsSecondaires.DebutB", "AnnexeK.AK.Page1.ForsSecondaires.DebutB");
        champscalcules.put("AnnexeK.AK.Page1.ForsSecondaires.DebutC", "AnnexeK.AK.Page1.ForsSecondaires.DebutC");
        champscalcules.put("AnnexeK.AK.Page1.ForsSecondaires.DebutD", "AnnexeK.AK.Page1.ForsSecondaires.DebutD");
        champscalcules.put("AnnexeK.AK.Page1.ForsSecondaires.DebutE", "AnnexeK.AK.Page1.ForsSecondaires.DebutE");
        champscalcules.put("AnnexeK.AK.Page1.ForsSecondaires.FinA", "AnnexeK.AK.Page1.ForsSecondaires.FinA");
        champscalcules.put("AnnexeK.AK.Page1.ForsSecondaires.FinB", "AnnexeK.AK.Page1.ForsSecondaires.FinB");
        champscalcules.put("AnnexeK.AK.Page1.ForsSecondaires.FinC", "AnnexeK.AK.Page1.ForsSecondaires.FinC");
        champscalcules.put("AnnexeK.AK.Page1.ForsSecondaires.FinD", "AnnexeK.AK.Page1.ForsSecondaires.FinD");
        champscalcules.put("AnnexeK.AK.Page1.ForsSecondaires.FinE", "AnnexeK.AK.Page1.ForsSecondaires.FinE");
        champscalcules.put("AnnexeK.AK.Page1.ForsSpeciaux.DebutA", "AnnexeK.AK.Page1.ForsSpeciaux.DebutA");
        champscalcules.put("AnnexeK.AK.Page1.ForsSpeciaux.DebutB", "AnnexeK.AK.Page1.ForsSpeciaux.DebutB");
        champscalcules.put("AnnexeK.AK.Page1.ForsSpeciaux.DebutC", "AnnexeK.AK.Page1.ForsSpeciaux.DebutC");
        champscalcules.put("AnnexeK.AK.Page1.ForsSpeciaux.DebutD", "AnnexeK.AK.Page1.ForsSpeciaux.DebutD");
        champscalcules.put("AnnexeK.AK.Page1.ForsSpeciaux.DebutE", "AnnexeK.AK.Page1.ForsSpeciaux.DebutE");
        champscalcules.put("AnnexeK.AK.Page1.ForsSpeciaux.FinA", "AnnexeK.AK.Page1.ForsSpeciaux.FinA");
        champscalcules.put("AnnexeK.AK.Page1.ForsSpeciaux.FinB", "AnnexeK.AK.Page1.ForsSpeciaux.FinB");
        champscalcules.put("AnnexeK.AK.Page1.ForsSpeciaux.FinC", "AnnexeK.AK.Page1.ForsSpeciaux.FinC");
        champscalcules.put("AnnexeK.AK.Page1.ForsSpeciaux.FinD", "AnnexeK.AK.Page1.ForsSpeciaux.FinD");
        champscalcules.put("AnnexeK.AK.Page1.ForsSpeciaux.FinE", "AnnexeK.AK.Page1.ForsSpeciaux.FinE");
        ANNEXE_K = Collections.unmodifiableMap(champscalcules);
        champscalcules = new HashMap();
        champscalcules.put("AnnexeK_af.AK_af.Page1_af.ForPrincipal.DebutA", "AnnexeK_af.AK_af.Page1_af.ForPrincipal.DebutA");
        champscalcules.put("AnnexeK_af.AK_af.Page1_af.ForPrincipal.DebutB", "AnnexeK_af.AK_af.Page1_af.ForPrincipal.DebutB");
        champscalcules.put("AnnexeK_af.AK_af.Page1_af.ForPrincipal.DebutC", "AnnexeK_af.AK_af.Page1_af.ForPrincipal.DebutC");
        champscalcules.put("AnnexeK_af.AK_af.Page1_af.ForPrincipal.DebutD", "AnnexeK_af.AK_af.Page1_af.ForPrincipal.DebutD");
        champscalcules.put("AnnexeK_af.AK_af.Page1_af.ForPrincipal.DebutE", "AnnexeK_af.AK_af.Page1_af.ForPrincipal.DebutE");
        champscalcules.put("AnnexeK_af.AK_af.Page1_af.ForPrincipal.FinA", "AnnexeK_af.AK_af.Page1_af.ForPrincipal.FinA");
        champscalcules.put("AnnexeK_af.AK_af.Page1_af.ForPrincipal.FinB", "AnnexeK_af.AK_af.Page1_af.ForPrincipal.FinB");
        champscalcules.put("AnnexeK_af.AK_af.Page1_af.ForPrincipal.FinC", "AnnexeK_af.AK_af.Page1_af.ForPrincipal.FinC");
        champscalcules.put("AnnexeK_af.AK_af.Page1_af.ForPrincipal.FinD", "AnnexeK_af.AK_af.Page1_af.ForPrincipal.FinD");
        champscalcules.put("AnnexeK_af.AK_af.Page1_af.ForPrincipal.FinE", "AnnexeK_af.AK_af.Page1_af.ForPrincipal.FinE");
        champscalcules.put("AnnexeK_af.AK_af.Page1_af.ForsSecondaires.DebutA", "AnnexeK_af.AK_af.Page1_af.ForsSecondaires.DebutA");
        champscalcules.put("AnnexeK_af.AK_af.Page1_af.ForsSecondaires.DebutB", "AnnexeK_af.AK_af.Page1_af.ForsSecondaires.DebutB");
        champscalcules.put("AnnexeK_af.AK_af.Page1_af.ForsSecondaires.DebutC", "AnnexeK_af.AK_af.Page1_af.ForsSecondaires.DebutC");
        champscalcules.put("AnnexeK_af.AK_af.Page1_af.ForsSecondaires.DebutD", "AnnexeK_af.AK_af.Page1_af.ForsSecondaires.DebutD");
        champscalcules.put("AnnexeK_af.AK_af.Page1_af.ForsSecondaires.DebutE", "AnnexeK_af.AK_af.Page1_af.ForsSecondaires.DebutE");
        champscalcules.put("AnnexeK_af.AK_af.Page1_af.ForsSecondaires.FinA", "AnnexeK_af.AK_af.Page1_af.ForsSecondaires.FinA");
        champscalcules.put("AnnexeK_af.AK_af.Page1_af.ForsSecondaires.FinB", "AnnexeK_af.AK_af.Page1_af.ForsSecondaires.FinB");
        champscalcules.put("AnnexeK_af.AK_af.Page1_af.ForsSecondaires.FinC", "AnnexeK_af.AK_af.Page1_af.ForsSecondaires.FinC");
        champscalcules.put("AnnexeK_af.AK_af.Page1_af.ForsSecondaires.FinD", "AnnexeK_af.AK_af.Page1_af.ForsSecondaires.FinD");
        champscalcules.put("AnnexeK_af.AK_af.Page1_af.ForsSecondaires.FinE", "AnnexeK_af.AK_af.Page1_af.ForsSecondaires.FinE");
        champscalcules.put("AnnexeK_af.AK_af.Page1_af.ForsSpeciaux.DebutA", "AnnexeK_af.AK_af.Page1_af.ForsSpeciaux.DebutA");
        champscalcules.put("AnnexeK_af.AK_af.Page1_af.ForsSpeciaux.DebutB", "AnnexeK_af.AK_af.Page1_af.ForsSpeciaux.DebutB");
        champscalcules.put("AnnexeK_af.AK_af.Page1_af.ForsSpeciaux.DebutC", "AnnexeK_af.AK_af.Page1_af.ForsSpeciaux.DebutC");
        champscalcules.put("AnnexeK_af.AK_af.Page1_af.ForsSpeciaux.DebutD", "AnnexeK_af.AK_af.Page1_af.ForsSpeciaux.DebutD");
        champscalcules.put("AnnexeK_af.AK_af.Page1_af.ForsSpeciaux.DebutE", "AnnexeK_af.AK_af.Page1_af.ForsSpeciaux.DebutE");
        champscalcules.put("AnnexeK_af.AK_af.Page1_af.ForsSpeciaux.FinA", "AnnexeK_af.AK_af.Page1_af.ForsSpeciaux.FinA");
        champscalcules.put("AnnexeK_af.AK_af.Page1_af.ForsSpeciaux.FinB", "AnnexeK_af.AK_af.Page1_af.ForsSpeciaux.FinB");
        champscalcules.put("AnnexeK_af.AK_af.Page1_af.ForsSpeciaux.FinC", "AnnexeK_af.AK_af.Page1_af.ForsSpeciaux.FinC");
        champscalcules.put("AnnexeK_af.AK_af.Page1_af.ForsSpeciaux.FinD", "AnnexeK_af.AK_af.Page1_af.ForsSpeciaux.FinD");
        champscalcules.put("AnnexeK_af.AK_af.Page1_af.ForsSpeciaux.FinE", "AnnexeK_af.AK_af.Page1_af.ForsSpeciaux.FinE");
        ANNEXE_K_AF = Collections.unmodifiableMap(champscalcules);
    }
}

