/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.presentation.common.imports;

import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class AnnexeHImporter {
    private static final Logger log = Logger.getLogger(AnnexeHImporter.class);
    private Map importedValues = new HashMap();

    public ModelItemDTO convert(String dmk, ModelItemDTO mi) {
        String keyWithTableIndex = this.convertDmk(dmk);
        HashMap<String, ModelItemDTO> elementWithSameKey = (HashMap<String, ModelItemDTO>)this.importedValues.get(keyWithTableIndex);
        if (elementWithSameKey == null) {
            elementWithSameKey = new HashMap<String, ModelItemDTO>();
            this.importedValues.put(keyWithTableIndex, elementWithSameKey);
        }
        elementWithSameKey.put(dmk, mi);
        return mi;
    }

    private String convertDmk(String dmk) {
        String key = dmk;
        while (!EngineUtil.endsWithTableIndex(key)) {
            key = EngineUtil.removeLastKeyPart(key);
        }
        return key;
    }

    public Map getFieldsToImport() {
        HashMap<String, ModelItemDTO> changedValues = new HashMap<String, ModelItemDTO>();
        ArrayList keys = new ArrayList();
        keys.addAll(this.importedValues.keySet());
        Collections.sort(keys);
        int index = 0;
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String tableIndex = String.valueOf(90000 + index / 5);
            int fieldIndex = index % 5;
            Map modelItemDtOs = (Map)this.importedValues.get(key);
            Iterator iterator = modelItemDtOs.keySet().iterator();
            while (iterator.hasNext()) {
                String oldDmk = (String)iterator.next();
                ModelItemDTO modelItemDTO = (ModelItemDTO)modelItemDtOs.get(oldDmk);
                String newDmk = oldDmk.replaceFirst("[0-9]+", tableIndex);
                newDmk = newDmk + fieldIndex;
                log.debug(oldDmk + " -> " + newDmk);
                changedValues.put(newDmk, modelItemDTO);
            }
            ++index;
        }
        return changedValues;
    }
}

