/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.presentation.cd.dialog;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.dialog.TitleAreaDialog;
import ch.dvbern.tax.common.presentation.cd.util.DialogUtil;
import ch.dvbern.tax.common.presentation.cd.util.GuiUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class InfoTreuhaenderDialog
extends TitleAreaDialog {
    private Text textNom;
    private Text textTelephone;
    private Label labelNom;
    private Label labelTelephone;
    private Pattern pattern = Pattern.compile("[0-9|+]{0,4}[. '/-]{0,3}[0-9]{2,3}[. '/-]{0,3}[0-9]{3}[. '/-]{0,3}[0-9]{2}[. '/-]{0,3}[0-9]{2}");

    public InfoTreuhaenderDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.getString("title.shell.info.treuhaender"));
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.getString("title.info.treuhaender"));
        this.setMessage(Messages.getString("label.info.treuhaender"));
        return this.createContent(parent);
    }

    private void refresh() {
        this.textNom.setEnabled(true);
        this.textTelephone.setEnabled(true);
        this.textNom.setBackground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_WHITE));
        this.textTelephone.setBackground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_WHITE));
    }

    private Composite createContent(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData(1808));
        panel.setFont(parent.getFont());
        this.labelNom = new Label(panel, 64);
        this.labelNom.setText(Messages.getString("label.mandataire.nom", (Control)this.labelNom));
        GridData gdLabelNom = new GridData(768);
        gdLabelNom.horizontalSpan = 1;
        this.labelNom.setLayoutData((Object)gdLabelNom);
        this.textNom = new Text(panel, 2048);
        this.textNom.setTextLimit(30);
        GridData gdTextNom = new GridData(768);
        gdTextNom.horizontalSpan = 1;
        this.textNom.setLayoutData((Object)gdTextNom);
        this.labelTelephone = new Label(panel, 64);
        this.labelTelephone.setText(Messages.getString("label.mandataire.tel", (Control)this.labelTelephone));
        GridData gdLabelTelephone = new GridData(768);
        gdLabelTelephone.horizontalSpan = 1;
        this.labelTelephone.setLayoutData((Object)gdLabelTelephone);
        this.textTelephone = new Text(panel, 2048);
        this.textTelephone.setTextLimit(25);
        GridData gdTextTelephone = new GridData();
        gdTextTelephone.horizontalSpan = 1;
        gdTextTelephone.widthHint = 100;
        this.textTelephone.setLayoutData((Object)gdTextTelephone);
        this.setValuesFromConfig();
        this.refresh();
        return panel;
    }

    private void setValuesFromConfig() {
        this.textNom.setText(TaxmeConfig.getString("Declaration_af.Form1_af.RenseignementRaisonSociale") != null ? TaxmeConfig.getString("Declaration_af.Form1_af.RenseignementRaisonSociale") : "");
        this.textTelephone.setText(TaxmeConfig.getString("Declaration_af.Form1_af.RenseignementNumTel") != null ? TaxmeConfig.getString("Declaration_af.Form1_af.RenseignementNumTel") : "");
    }

    private void setValuesToConfig() {
        TaxmeConfig.setValue("Declaration_af.Form1_af.RenseignementRaisonSociale", this.textNom.getText());
        TaxmeConfig.setValue("Declaration_af.Form1_af.RenseignementNumTel", this.textTelephone.getText());
        TaxmeConfig.setValue("Declaration.Form1.RenseignementRaisonSociale", this.textNom.getText());
        TaxmeConfig.setValue("Declaration.Form1.RenseignementNumTel", this.textTelephone.getText());
    }

    protected void okPressed() {
        Matcher m;
        String s;
        StringBuffer message = new StringBuffer();
        if (this.textNom.getText().length() <= 0) {
            message.append("\n" + Messages.getString("error.missing.data.mandataire.nom"));
            this.textNom.setBackground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_RED));
        }
        if ((s = this.textTelephone.getText()) != null && s.length() > 0 && !(m = this.pattern.matcher(s)).matches()) {
            message.append("\n" + Messages.getString("error.format.tel"));
        }
        if (message.length() > 0) {
            DialogUtil.showErrorDialog(message.toString());
            return;
        }
        this.setValuesToConfig();
        super.okPressed();
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }
}

