/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.presentation.cd;

import ch.dvbern.tax.common.engine.DataResource;
import ch.dvbern.tax.common.transfer.dto.BaremeImpotDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemDTO;
import ch.dvbern.tax.common.transfer.dto.ValorDTO;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class DataResourceImpl
implements DataResource {
    private static final int MAX_INPUT_FILE_LINES = 50000;
    private static final SimpleDateFormat SDF = new SimpleDateFormat("dd.MM.yyyy");
    private static final String ENCODING = "ISO-8859-1";
    private static Map communesGeneve;
    private static Map communesGeneveForAnnexeF;
    private static Map cantons;
    private static Map allCantons;
    private static Map pays;
    private static Map cantonsEtPays;
    private static Map cantonsEtPaysForAnnexeF;
    private static Map communesGeneveEtCantons;
    private static Map communesCantonsPays;
    private static Map communesCantonsPaysChoix;
    private static Map centimesAdditionnels;
    private static Map communesToDisplay;
    private static Map mutations;
    private static Map genreRendement;
    private static Map monnaies;
    private static Map actifsSiegeOuLocalises;
    private static Map actifsMobiles;
    private static Map capitalDotation;
    private static Map selonTotalOuAppreciation;
    private static Map fileContents;
    private static Map valoren;
    private static Map modelConfigThisYear;
    private static Map modelConfigYearBefore;
    private static Map valeurFiscaleImmeuble;
    private static Map baremeImpotBenefice;
    private static Map baremeImpotCapital;
    private static String fileDelimiter;
    private static String fileDir;
    private static String fileValoren;
    private static String fileMutations;
    private static String fileGenreRendement;
    private static String fileCommunesCantonsPaysChoix;
    private static String fileCommunesCantonsPays;
    private static String fileMonnaies;
    private static String fileActifsSiegeOuLocalises;
    private static String fileActifsMobiles;
    private static String fileCapitalDotation;
    private static String fileSelonTotalOuAppreciation;
    private static String fileModelConfigThisYear;
    private static String fileModelConfigYearBefore;
    private static String fileBaremeImpotBenefice;
    private static String fileBaremeImpotCapital;
    private static final String TYPE_LIEU_COMMUNE = "1";
    private static final String TYPE_LIEU_CANTON = "2";
    private static final String TYPE_LIEU_PAYS = "3";
    private static final String CANTON_DE_GENEVE = "9025";
    private static final String PAYS_SUISSE = "8100";
    public static final String COMMUNES_GENEVE = "communesGeneve";
    public static final String CANTONS = "cantons";
    public static final String ALL_CANTONS = "allCantons";
    public static final String PAYS = "pays";
    public static final String CANTONS_ET_PAYS = "cantonsEtPays";
    public static final String COMMUNES_GENEVE_ET_CANTONS = "communesGeneveEtCantons";
    public static final String COMMUNESCANTONSPAYS = "communesCantonsPays";
    public static final String COMMUNESCANTONSPAYSCHOIX = "communesCantonsPaysChoix";
    public static final String COMMUNES_TO_DISPLAY = "communesToDisplay";
    public static final String VALEUR = "valor";
    public static final String MUTATIONS = "mutations";
    public static final String GENRE_RENDEMENT = "genreRendement";
    public static final String MONNAIES = "monnaies";
    public static final String ACTIFS_SIEGEOULOCALISES = "actifsSiegeOuLocalises";
    public static final String ACTIFS_MOBILES = "actifsMobiles";
    public static final String CAPITAL_DOTATION = "capitalDotation";
    public static final String SELON_TOTALOUAPPRECIATION = "selonTotalOuAppreciation";
    public static final String MODEL_CONFIG = "modelConfig";
    public static final String MODEL_CONFIG_BEFORE = "modelConfigBefore";
    public static final String CENTIMES_ADDITIONNELS = "centimesAdditionnels";
    public static final String COMMUNES_GENEVE_FOR_ANNEXE_F = "communesGeneveForAnnexeF";
    public static final String CANTONS_ET_PAYS_FOR_ANNEXE_F = "cantonsEtPaysForAnnexeF";
    public static final String BAREME_IMPOT_BENEFICE = "baremeImpotBenefice";
    public static final String BAREME_IMPOT_CAPITAL = "baremeImpotCapital";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map get(String code, Object arg1, Object arg2) {
        if (code.equals(COMMUNES_GENEVE)) {
            if (communesGeneve == null) {
                this.readCommunesGeneve();
            }
            return communesGeneve;
        }
        if (code.equals(COMMUNES_GENEVE_FOR_ANNEXE_F)) {
            if (communesGeneveForAnnexeF == null) {
                this.readCommunesGeneve();
            }
            return communesGeneveForAnnexeF;
        }
        if (code.equals(CANTONS)) {
            if (cantons == null) {
                this.readCantons();
            }
            return cantons;
        }
        if (code.equals(ALL_CANTONS)) {
            if (allCantons == null) {
                this.readAllCantons();
            }
            return allCantons;
        }
        if (code.equals(PAYS)) {
            if (pays == null) {
                this.readPays();
            }
            return pays;
        }
        if (code.equals(CANTONS_ET_PAYS)) {
            if (cantonsEtPays == null) {
                this.readCantonsEtPays();
            }
            return cantonsEtPays;
        }
        if (code.equals(CANTONS_ET_PAYS_FOR_ANNEXE_F)) {
            if (cantonsEtPaysForAnnexeF == null) {
                this.readCantonsEtPays();
            }
            return cantonsEtPaysForAnnexeF;
        }
        if (code.equals(COMMUNES_GENEVE_ET_CANTONS)) {
            if (communesGeneveEtCantons == null) {
                this.readCommunesGeneveEtCantons();
            }
            return communesGeneveEtCantons;
        }
        if (code.equals(COMMUNESCANTONSPAYSCHOIX)) {
            if (communesCantonsPaysChoix == null) {
                this.readCommunesCantonsPaysChoix();
            }
            return communesCantonsPaysChoix;
        }
        if (code.equals(COMMUNESCANTONSPAYS)) {
            Map m;
            if (communesCantonsPays == null) {
                this.readCommunesCantonsPays();
            }
            if ((m = (Map)communesCantonsPays.get(arg1)) != null) {
                return m;
            }
            return new HashMap();
        }
        if (code.equals(COMMUNES_TO_DISPLAY)) {
            if (communesToDisplay == null) {
                this.readCommunesCantonsPays();
            }
            return communesToDisplay;
        }
        if (code.equals(CENTIMES_ADDITIONNELS)) {
            if (centimesAdditionnels == null) {
                this.readCommunesGeneve();
            }
            return centimesAdditionnels;
        }
        if (code.equals(MONNAIES)) {
            if (monnaies == null) {
                this.readMonnaies();
            }
            return monnaies;
        }
        if (code.equals(ACTIFS_SIEGEOULOCALISES)) {
            if (actifsSiegeOuLocalises == null) {
                this.readActifSiegeOuLocalises();
            }
            return actifsSiegeOuLocalises;
        }
        if (code.equals(ACTIFS_MOBILES)) {
            if (actifsMobiles == null) {
                this.readActifsMobiles();
            }
            return actifsMobiles;
        }
        if (code.equals(CAPITAL_DOTATION)) {
            if (capitalDotation == null) {
                this.readCapitalDotation();
            }
            return capitalDotation;
        }
        if (code.equals(SELON_TOTALOUAPPRECIATION)) {
            if (selonTotalOuAppreciation == null) {
                this.readSelonTotalOuAppreciation();
            }
            return selonTotalOuAppreciation;
        }
        if (code.equals(MUTATIONS)) {
            if (mutations == null) {
                this.readMutations();
            }
            return mutations;
        }
        if (code.equals(GENRE_RENDEMENT)) {
            if (genreRendement == null) {
                this.readGenreRendement();
            }
            return genreRendement;
        }
        if (code.equals(VALEUR)) {
            String string = VALEUR;
            synchronized (VALEUR) {
                if (valoren == null) {
                    this.readValoren();
                }
                // ** MonitorExit[var4_5] (shouldn't be in output)
                return valoren;
            }
        }
        if (code.equals(MODEL_CONFIG)) {
            if (modelConfigThisYear == null) {
                this.readModelConfig();
            }
            return modelConfigThisYear;
        }
        if (code.equals(MODEL_CONFIG_BEFORE)) {
            if (modelConfigYearBefore == null) {
                this.readModelConfigBefore();
            }
            return modelConfigYearBefore;
        }
        if (code.equals(BAREME_IMPOT_BENEFICE)) {
            if (baremeImpotBenefice == null) {
                this.readBaremeImpotBenefice();
            }
            return baremeImpotBenefice;
        }
        if (code.equals(BAREME_IMPOT_CAPITAL)) {
            if (baremeImpotCapital == null) {
                this.readBaremeImpotCapital();
            }
            return baremeImpotCapital;
        }
        Map map = fileContents;
        synchronized (map) {
            Map m = (Map)fileContents.get(code);
            if (m == null) {
                m = this.readFile(code);
                fileContents.put(code, m);
            }
            return m;
        }
    }

    private Map readFile(String code) {
        LinkedHashMap<String, OptionItemDTO> result = new LinkedHashMap<String, OptionItemDTO>();
        try {
            BufferedReader in = DataResourceImpl.getReader(fileDir + code + ".txt");
            String line = in.readLine();
            while (line != null) {
                if (!line.startsWith("#")) {
                    StringTokenizer tokenizer = new StringTokenizer(line, fileDelimiter);
                    String key = tokenizer.nextToken();
                    String value = tokenizer.nextToken();
                    result.put(key, new OptionItemDTO(key, null, value, false));
                }
                line = in.readLine();
            }
            in.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getLocalized(String code, Object arg1, Object arg2) {
        Map map = fileContents;
        synchronized (map) {
            Map m = (Map)fileContents.get(code);
            if (m == null) {
                m = this.readLocalizedFile(code);
                fileContents.put(code, m);
            }
            return m;
        }
    }

    private void readCommunesGeneve() {
        try {
            LinkedHashMap<String, OptionItemDTO> myMap = new LinkedHashMap<String, OptionItemDTO>();
            LinkedHashMap<Long, Double> mapForCA = new LinkedHashMap<Long, Double>();
            LinkedHashMap<String, OptionItemDTO> mapForAnnexeF = new LinkedHashMap<String, OptionItemDTO>();
            BufferedReader in = DataResourceImpl.getReader(fileCommunesCantonsPays);
            String line = in.readLine();
            while (line != null) {
                StringTokenizer tokenizer = new StringTokenizer(line, fileDelimiter);
                String sCodeLieu = tokenizer.nextToken();
                Long codeLieu = Long.valueOf(sCodeLieu);
                String lieu = tokenizer.nextToken();
                String tauxCentimesAdditionnels = tokenizer.nextToken();
                String typeLieu = tokenizer.nextToken();
                String codeEtLieu = tokenizer.nextToken();
                if (typeLieu.equals(TYPE_LIEU_COMMUNE)) {
                    OptionItemDTO optionItemDTO = new OptionItemDTO(codeLieu, sCodeLieu, lieu, false);
                    myMap.put(codeLieu.toString(), optionItemDTO);
                    mapForCA.put(codeLieu, new Double(tauxCentimesAdditionnels));
                    OptionItemDTO optionItemDTOforAnnexeF = new OptionItemDTO(codeLieu, sCodeLieu, codeEtLieu, false);
                    mapForAnnexeF.put(codeLieu.toString(), optionItemDTOforAnnexeF);
                    line = in.readLine();
                    continue;
                }
                line = in.readLine();
            }
            communesGeneve = myMap;
            centimesAdditionnels = mapForCA;
            communesGeneveForAnnexeF = mapForAnnexeF;
            in.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void readCantons() {
        try {
            LinkedHashMap<String, OptionItemDTO> myMap = new LinkedHashMap<String, OptionItemDTO>();
            BufferedReader in = DataResourceImpl.getReader(fileCommunesCantonsPays);
            String line = in.readLine();
            while (line != null) {
                StringTokenizer tokenizer = new StringTokenizer(line, fileDelimiter);
                String sCodeLieu = tokenizer.nextToken();
                Long codeLieu = Long.valueOf(sCodeLieu);
                String lieu = tokenizer.nextToken();
                String tauxCentimesAdditionnels = tokenizer.nextToken();
                String typeLieu = tokenizer.nextToken();
                String codeEtLieu = tokenizer.nextToken();
                if (typeLieu.equals(TYPE_LIEU_CANTON) && !sCodeLieu.equalsIgnoreCase(CANTON_DE_GENEVE)) {
                    OptionItemDTO optionItemDTO = new OptionItemDTO(codeLieu, sCodeLieu, lieu, false);
                    myMap.put(codeLieu.toString(), optionItemDTO);
                    line = in.readLine();
                    continue;
                }
                line = in.readLine();
            }
            cantons = myMap;
            in.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void readAllCantons() {
        try {
            LinkedHashMap<String, OptionItemDTO> myMap = new LinkedHashMap<String, OptionItemDTO>();
            BufferedReader in = DataResourceImpl.getReader(fileCommunesCantonsPays);
            String line = in.readLine();
            while (line != null) {
                StringTokenizer tokenizer = new StringTokenizer(line, fileDelimiter);
                String sCodeLieu = tokenizer.nextToken();
                Long codeLieu = Long.valueOf(sCodeLieu);
                String lieu = tokenizer.nextToken();
                String tauxCentimesAdditionnels = tokenizer.nextToken();
                String typeLieu = tokenizer.nextToken();
                String codeEtLieu = tokenizer.nextToken();
                if (typeLieu.equals(TYPE_LIEU_CANTON)) {
                    OptionItemDTO optionItemDTO = new OptionItemDTO(codeLieu, sCodeLieu, lieu, false);
                    myMap.put(codeLieu.toString(), optionItemDTO);
                    line = in.readLine();
                    continue;
                }
                line = in.readLine();
            }
            allCantons = myMap;
            in.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void readPays() {
        try {
            LinkedHashMap<String, OptionItemDTO> myPays = new LinkedHashMap<String, OptionItemDTO>();
            BufferedReader in = DataResourceImpl.getReader(fileCommunesCantonsPays);
            String line = in.readLine();
            while (line != null) {
                StringTokenizer tokenizer = new StringTokenizer(line, fileDelimiter);
                String sCodeLieu = tokenizer.nextToken();
                Long codeLieu = Long.valueOf(sCodeLieu);
                String lieu = tokenizer.nextToken();
                String tauxCentimesAdditionnels = tokenizer.nextToken();
                String typeLieu = tokenizer.nextToken();
                String codeEtLieu = tokenizer.nextToken();
                if (typeLieu.equals(TYPE_LIEU_PAYS) && !sCodeLieu.equalsIgnoreCase(PAYS_SUISSE)) {
                    OptionItemDTO optionItemDTO = new OptionItemDTO(codeLieu, sCodeLieu, lieu, false);
                    myPays.put(codeLieu.toString(), optionItemDTO);
                    line = in.readLine();
                    continue;
                }
                line = in.readLine();
            }
            pays = myPays;
            in.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void readCantonsEtPays() {
        try {
            LinkedHashMap<String, OptionItemDTO> myMap = new LinkedHashMap<String, OptionItemDTO>();
            LinkedHashMap<String, OptionItemDTO> mapForAnnexeF = new LinkedHashMap<String, OptionItemDTO>();
            BufferedReader in = DataResourceImpl.getReader(fileCommunesCantonsPays);
            String line = in.readLine();
            while (line != null) {
                StringTokenizer tokenizer = new StringTokenizer(line, fileDelimiter);
                String sCodeLieu = tokenizer.nextToken();
                Long codeLieu = Long.valueOf(sCodeLieu);
                String lieu = tokenizer.nextToken();
                String tauxCentimesAdditionnels = tokenizer.nextToken();
                String typeLieu = tokenizer.nextToken();
                String codeEtLieu = tokenizer.nextToken();
                if ((typeLieu.equals(TYPE_LIEU_CANTON) || typeLieu.equals(TYPE_LIEU_PAYS)) && !sCodeLieu.equalsIgnoreCase(CANTON_DE_GENEVE) && !sCodeLieu.equalsIgnoreCase(PAYS_SUISSE)) {
                    OptionItemDTO optionItemDTO = new OptionItemDTO(codeLieu, " ", lieu, false);
                    myMap.put(codeLieu.toString(), optionItemDTO);
                    OptionItemDTO optionItemDTOforAnnexeF = new OptionItemDTO(codeLieu, sCodeLieu, codeEtLieu, false);
                    mapForAnnexeF.put(codeLieu.toString(), optionItemDTOforAnnexeF);
                    line = in.readLine();
                    continue;
                }
                line = in.readLine();
            }
            cantonsEtPays = myMap;
            cantonsEtPaysForAnnexeF = mapForAnnexeF;
            in.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void readCommunesCantonsPaysChoix() {
        try {
            LinkedHashMap<String, OptionItemDTO> m = new LinkedHashMap<String, OptionItemDTO>();
            BufferedReader in = DataResourceImpl.getReader(fileCommunesCantonsPaysChoix);
            String line = in.readLine();
            while (line != null) {
                StringTokenizer tokenizer = new StringTokenizer(line, fileDelimiter);
                Long id = Long.valueOf(tokenizer.nextToken());
                String communesCantonsPays = tokenizer.nextToken();
                OptionItemDTO optionItemDTO = new OptionItemDTO(id, " ", communesCantonsPays, false);
                m.put(id.toString(), optionItemDTO);
                line = in.readLine();
            }
            communesCantonsPaysChoix = m;
            in.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void readCommunesCantonsPays() {
        try {
            LinkedHashMap<Long, LinkedHashMap<String, OptionItemDTO>> communesCantonsPaysChoix = new LinkedHashMap<Long, LinkedHashMap<String, OptionItemDTO>>();
            LinkedHashMap<Long, String> mapForCommunesToDisplay = new LinkedHashMap<Long, String>();
            BufferedReader in = DataResourceImpl.getReader(fileCommunesCantonsPays);
            String line = in.readLine();
            while (line != null) {
                StringTokenizer tokenizer = new StringTokenizer(line, fileDelimiter);
                String sCodeLieu = tokenizer.nextToken();
                Long codeLieu = Long.valueOf(sCodeLieu);
                String lieu = tokenizer.nextToken();
                String tauxCentimesAdditionnels = tokenizer.nextToken();
                String typeLieu = tokenizer.nextToken();
                Long lTypeLieu = Long.valueOf(typeLieu);
                String codeEtLieu = tokenizer.nextToken();
                if (!sCodeLieu.equalsIgnoreCase(CANTON_DE_GENEVE) && !sCodeLieu.equalsIgnoreCase(PAYS_SUISSE)) {
                    OptionItemDTO optionItemDTO = new OptionItemDTO(codeLieu, sCodeLieu, lieu, false);
                    LinkedHashMap<String, OptionItemDTO> j = (LinkedHashMap<String, OptionItemDTO>)communesCantonsPaysChoix.get(lTypeLieu);
                    if (j == null) {
                        j = new LinkedHashMap<String, OptionItemDTO>();
                        communesCantonsPaysChoix.put(lTypeLieu, j);
                        mapForCommunesToDisplay.put(codeLieu, lieu);
                    }
                    j.put(codeLieu.toString(), optionItemDTO);
                }
                line = in.readLine();
            }
            communesCantonsPays = communesCantonsPaysChoix;
            communesToDisplay = mapForCommunesToDisplay;
            in.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void readCommunesGeneveEtCantons() {
        try {
            LinkedHashMap<String, OptionItemDTO> myMap = new LinkedHashMap<String, OptionItemDTO>();
            BufferedReader in = DataResourceImpl.getReader(fileCommunesCantonsPays);
            String line = in.readLine();
            while (line != null) {
                StringTokenizer tokenizer = new StringTokenizer(line, fileDelimiter);
                String sCodeLieu = tokenizer.nextToken();
                Long codeLieu = Long.valueOf(sCodeLieu);
                String lieu = tokenizer.nextToken();
                String tauxCentimesAdditionnels = tokenizer.nextToken();
                String typeLieu = tokenizer.nextToken();
                String codeEtLieu = tokenizer.nextToken();
                if (typeLieu.equals(TYPE_LIEU_COMMUNE) || typeLieu.equals(TYPE_LIEU_CANTON)) {
                    OptionItemDTO optionItemDTO = new OptionItemDTO(codeLieu, sCodeLieu, lieu, false);
                    myMap.put(codeLieu.toString(), optionItemDTO);
                    line = in.readLine();
                    continue;
                }
                line = in.readLine();
            }
            communesGeneveEtCantons = myMap;
            in.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void readMonnaies() {
        try {
            LinkedHashMap<String, OptionItemDTO> kt = new LinkedHashMap<String, OptionItemDTO>();
            BufferedReader in = DataResourceImpl.getReader(fileMonnaies);
            String line = in.readLine();
            while (line != null) {
                if (!line.startsWith("#")) {
                    StringTokenizer tokenizer = new StringTokenizer(line, fileDelimiter);
                    Long id = Long.valueOf(tokenizer.nextToken());
                    String monnaiesShort = tokenizer.nextToken();
                    String monnaies = tokenizer.nextToken();
                    OptionItemDTO optionItemDTO = new OptionItemDTO(id, monnaiesShort, monnaies, false);
                    kt.put(id.toString(), optionItemDTO);
                }
                line = in.readLine();
            }
            monnaies = kt;
            in.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void readActifSiegeOuLocalises() {
        try {
            LinkedHashMap<String, OptionItemDTO> myMap = new LinkedHashMap<String, OptionItemDTO>();
            BufferedReader in = DataResourceImpl.getReader(fileActifsSiegeOuLocalises);
            String line = in.readLine();
            while (line != null) {
                if (!line.startsWith("#")) {
                    StringTokenizer tokenizer = new StringTokenizer(line, fileDelimiter);
                    Long id = Long.valueOf(tokenizer.nextToken());
                    String actifsSiegeOuLocalises = tokenizer.nextToken();
                    OptionItemDTO optionItemDTO = new OptionItemDTO(id, " ", actifsSiegeOuLocalises, false);
                    myMap.put(id.toString(), optionItemDTO);
                }
                line = in.readLine();
            }
            actifsSiegeOuLocalises = myMap;
            in.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void readActifsMobiles() {
        try {
            LinkedHashMap<String, OptionItemDTO> myMap = new LinkedHashMap<String, OptionItemDTO>();
            BufferedReader in = DataResourceImpl.getReader(fileActifsMobiles);
            String line = in.readLine();
            while (line != null) {
                if (!line.startsWith("#")) {
                    StringTokenizer tokenizer = new StringTokenizer(line, fileDelimiter);
                    Long id = Long.valueOf(tokenizer.nextToken());
                    String actifsMobiles = tokenizer.nextToken();
                    OptionItemDTO optionItemDTO = new OptionItemDTO(id, " ", actifsMobiles, false);
                    myMap.put(id.toString(), optionItemDTO);
                }
                line = in.readLine();
            }
            actifsMobiles = myMap;
            in.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void readCapitalDotation() {
        try {
            LinkedHashMap<String, OptionItemDTO> myMap = new LinkedHashMap<String, OptionItemDTO>();
            BufferedReader in = DataResourceImpl.getReader(fileCapitalDotation);
            String line = in.readLine();
            while (line != null) {
                if (!line.startsWith("#")) {
                    StringTokenizer tokenizer = new StringTokenizer(line, fileDelimiter);
                    Long id = Long.valueOf(tokenizer.nextToken());
                    String capitalDotation = tokenizer.nextToken();
                    OptionItemDTO optionItemDTO = new OptionItemDTO(id, " ", capitalDotation, false);
                    myMap.put(id.toString(), optionItemDTO);
                }
                line = in.readLine();
            }
            capitalDotation = myMap;
            in.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void readSelonTotalOuAppreciation() {
        try {
            LinkedHashMap<String, OptionItemDTO> myMap = new LinkedHashMap<String, OptionItemDTO>();
            BufferedReader in = DataResourceImpl.getReader(fileSelonTotalOuAppreciation);
            String line = in.readLine();
            while (line != null) {
                if (!line.startsWith("#")) {
                    StringTokenizer tokenizer = new StringTokenizer(line, fileDelimiter);
                    Long id = Long.valueOf(tokenizer.nextToken());
                    String selonTotalOuAppreciation = tokenizer.nextToken();
                    OptionItemDTO optionItemDTO = new OptionItemDTO(id, " ", selonTotalOuAppreciation, false);
                    myMap.put(id.toString(), optionItemDTO);
                }
                line = in.readLine();
            }
            selonTotalOuAppreciation = myMap;
            in.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void readMutations() {
        try {
            LinkedHashMap<String, OptionItemDTO> m = new LinkedHashMap<String, OptionItemDTO>();
            BufferedReader in = DataResourceImpl.getReader(fileMutations);
            String line = in.readLine();
            while (line != null) {
                if (!line.startsWith("#")) {
                    StringTokenizer tokenizer = new StringTokenizer(line, fileDelimiter);
                    Long id = Long.valueOf(tokenizer.nextToken());
                    String bezeichnung = tokenizer.nextToken();
                    String kurzBezeichnung = tokenizer.nextToken();
                    OptionItemDTO optionItemDTO = new OptionItemDTO(id, kurzBezeichnung, bezeichnung, false);
                    m.put(id.toString(), optionItemDTO);
                }
                line = in.readLine();
            }
            mutations = m;
            in.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void readGenreRendement() {
        try {
            LinkedHashMap<String, OptionItemDTO> m = new LinkedHashMap<String, OptionItemDTO>();
            BufferedReader in = DataResourceImpl.getReader(fileGenreRendement);
            String line = in.readLine();
            while (line != null) {
                if (!line.startsWith("#")) {
                    StringTokenizer tokenizer = new StringTokenizer(line, fileDelimiter);
                    Long id = Long.valueOf(tokenizer.nextToken());
                    String bezeichnung = tokenizer.nextToken();
                    String kurzBezeichnung = tokenizer.nextToken();
                    OptionItemDTO optionItemDTO = new OptionItemDTO(id, kurzBezeichnung, bezeichnung, false);
                    m.put(id.toString(), optionItemDTO);
                }
                line = in.readLine();
            }
            genreRendement = m;
            in.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void readValoren() {
        try {
            ValorDTO vDTO;
            ArrayList<ValorDTO> vDTOs = new ArrayList<ValorDTO>();
            BufferedReader br = DataResourceImpl.getReader(fileValoren);
            br.readLine();
            int line = 0;
            String cur = br.readLine();
            while (cur != null && line++ < 50000) {
                vDTO = this.extractDTO(cur);
                vDTOs.add(vDTO);
                cur = br.readLine();
            }
            br.close();
            Collections.sort(vDTOs, new Comparator(){

                public int compare(Object left, Object right) {
                    return ((ValorDTO)left).getBezeichnung().compareToIgnoreCase(((ValorDTO)right).getBezeichnung());
                }
            });
            valoren = new LinkedHashMap();
            Iterator i = vDTOs.iterator();
            while (i.hasNext()) {
                vDTO = (ValorDTO)i.next();
                if (!vDTO.getAnwendbar().booleanValue() || valoren.containsKey(vDTO.getNummer())) {
                    vDTO = DataResourceImpl.getValueLessValorDTO(vDTO);
                }
                valoren.put(vDTO.getNummer(), vDTO);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void readModelConfig() {
        LinkedHashMap<String, Double> result = new LinkedHashMap<String, Double>();
        try {
            BufferedReader br = DataResourceImpl.getReader(fileModelConfigThisYear);
            String line = br.readLine();
            while (line != null) {
                if (!line.startsWith("#")) {
                    StringTokenizer tokenizer = new StringTokenizer(line, "=");
                    String key = tokenizer.nextToken();
                    String value = tokenizer.nextToken();
                    Double numVal = Double.valueOf(value);
                    result.put(key, numVal);
                }
                line = br.readLine();
            }
            br.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        modelConfigThisYear = result;
    }

    private void readModelConfigBefore() {
        LinkedHashMap<String, Double> result = new LinkedHashMap<String, Double>();
        try {
            BufferedReader br = DataResourceImpl.getReader(fileModelConfigYearBefore);
            String line = br.readLine();
            while (line != null) {
                if (!line.startsWith("#") && line.indexOf(61) != -1) {
                    StringTokenizer tokenizer = new StringTokenizer(line, "=");
                    String key = tokenizer.nextToken();
                    String value = tokenizer.nextToken();
                    Double numVal = Double.valueOf(value);
                    result.put(key, numVal);
                }
                line = br.readLine();
            }
            br.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        modelConfigYearBefore = result;
    }

    private void readBaremeImpotBenefice() {
        baremeImpotBenefice = this.readBaremeImpot(fileBaremeImpotBenefice);
    }

    private void readBaremeImpotCapital() {
        baremeImpotCapital = this.readBaremeImpot(fileBaremeImpotCapital);
    }

    private Map readBaremeImpot(String filename) {
        LinkedHashMap<Double, BaremeImpotDTO> result = new LinkedHashMap<Double, BaremeImpotDTO>();
        try {
            BufferedReader br = DataResourceImpl.getReader(filename);
            String line = br.readLine();
            while (line != null) {
                if (!line.startsWith("#") && line.indexOf(59) != -1) {
                    StringTokenizer tokenizer = new StringTokenizer(line, ";");
                    double startTranche = Double.parseDouble(tokenizer.nextToken());
                    String endTrancheString = tokenizer.nextToken();
                    double endTranche = endTrancheString.trim().length() == 0 ? 9.223372036854776E18 : Double.parseDouble(endTrancheString);
                    double taux = Double.parseDouble(tokenizer.nextToken());
                    double maxTranche = Double.parseDouble(tokenizer.nextToken());
                    double impot = Double.parseDouble(tokenizer.nextToken());
                    BaremeImpotDTO dto = new BaremeImpotDTO(startTranche, endTranche, taux, maxTranche, impot);
                    result.put(new Double(startTranche), dto);
                }
                line = br.readLine();
            }
            br.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static ValorDTO getValueLessValorDTO(ValorDTO template) {
        ValorDTO result = new ValorDTO();
        result.setNummer(template.getNummer());
        result.setType(template.getType());
        result.setBezeichnung(template.getBezeichnung());
        result.setWaehrungscode(template.getWaehrungscode());
        return result;
    }

    private ValorDTO extractDTO(String line) throws Exception {
        ValorDTO result = new ValorDTO();
        String[] props = this.getStringsBetweenTabs(line);
        if (props.length > 0) {
            result.setNummer(this.asLong(props[0]));
        }
        if (props.length > 1) {
            result.setType(this.asInteger(props[1]));
        }
        if (props.length > 2) {
            result.setBezeichnung(this.asString(props[2]));
        }
        if (props.length > 3) {
            result.setSteuerwert(this.asDouble(props[3]));
        }
        if (props.length > 4) {
            result.setZins(this.asDouble(props[4]));
        }
        if (props.length > 5) {
            result.setWaehrungscode(this.asString(props[5]));
        }
        if (props.length > 6) {
            result.setEmissionsjahr(this.asInteger(props[6]));
        }
        if (props.length > 7) {
            result.setRueckzahlung(this.asDate(props[7]));
        }
        if (props.length > 8) {
            result.setTermin(this.asDate(props[8]));
        }
        if (props.length > 9) {
            result.setErtrag(this.asDouble(props[9]));
        }
        if (props.length > 10) {
            result.setSicavb(Boolean.valueOf(props[10]));
        }
        if (props.length > 11) {
            result.setAnwendbar(Boolean.valueOf(props[11]));
        }
        if (props.length > 12) {
            result.setVstUnterliegend(Boolean.valueOf(props[12]));
        }
        return result;
    }

    private Map readLocalizedFile(String code) {
        HashMap result = new HashMap();
        try {
            String value;
            String key;
            StringTokenizer tokenizer;
            BufferedReader in = DataResourceImpl.getReader(fileDir + code + "_de.txt");
            String line = in.readLine();
            LinkedHashMap<String, OptionItemDTO> properties = new LinkedHashMap<String, OptionItemDTO>();
            while (line != null) {
                if (!line.startsWith("#")) {
                    tokenizer = new StringTokenizer(line, fileDelimiter);
                    key = tokenizer.nextToken();
                    value = tokenizer.nextToken();
                    properties.put(key, new OptionItemDTO(key, null, value, false));
                }
                result.put("de", properties);
                line = in.readLine();
            }
            properties = new LinkedHashMap();
            in = DataResourceImpl.getReader(fileDir + code + "_fr.txt");
            line = in.readLine();
            while (line != null) {
                if (!line.startsWith("#")) {
                    tokenizer = new StringTokenizer(line, fileDelimiter);
                    key = tokenizer.nextToken();
                    value = tokenizer.nextToken();
                    properties.put(key, new OptionItemDTO(key, null, value, false));
                }
                result.put("fr", properties);
                line = in.readLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    private String[] getStringsBetweenTabs(String line) {
        ArrayList<String> result = new ArrayList<String>();
        int begin = 0;
        int end = line.indexOf(9);
        while (end >= 0) {
            result.add(line.substring(begin, end));
            begin = ++end;
            end = line.indexOf(9, begin);
        }
        result.add(line.substring(begin));
        return result.toArray(new String[0]);
    }

    private Integer asInteger(String prop) {
        Integer result = null;
        String s = this.formatPropertyString(prop);
        if (s.length() > 0) {
            result = new Integer(s);
        }
        return result;
    }

    private Long asLong(String prop) {
        Long result = null;
        String s = this.formatPropertyString(prop);
        if (s.length() > 0) {
            result = new Long(s);
        }
        return result;
    }

    private Double asDouble(String prop) {
        Double result = null;
        String s = this.formatPropertyString(prop);
        if (s.length() > 0) {
            result = new Double(s);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Date asDate(String prop) throws Exception {
        Date result = null;
        String s = this.formatPropertyString(prop);
        if (s.length() > 0) {
            SimpleDateFormat simpleDateFormat = SDF;
            synchronized (simpleDateFormat) {
                result = SDF.parse(s);
            }
        }
        return result;
    }

    private String asString(String prop) {
        return this.formatPropertyString(prop);
    }

    private String formatPropertyString(String prop) {
        if (prop == null) {
            return "";
        }
        String s = prop.trim();
        if (s.length() > 1 && s.charAt(0) == '\"' && s.charAt(s.length() - 1) == '\"') {
            s = s.substring(1, s.length() - 1);
        }
        return s.trim();
    }

    private static BufferedReader getReader(String fileName) throws IOException {
        BufferedInputStream fis = new BufferedInputStream(new FileInputStream(fileName));
        InputStreamReader isr = new InputStreamReader((InputStream)fis, ENCODING);
        BufferedReader br = new BufferedReader(isr);
        return br;
    }

    static {
        fileContents = new HashMap();
        fileDelimiter = "\t";
        fileDir = (System.getProperty("project.base.dir") != null ? System.getProperty("project.base.dir") + "/" : "") + "config/cd/resources/";
        fileValoren = fileDir + "valoren.txt";
        fileMutations = fileDir + "mutations.txt";
        fileGenreRendement = fileDir + "genreRendement.txt";
        fileCommunesCantonsPaysChoix = fileDir + "communesCantonsPaysChoix.txt";
        fileCommunesCantonsPays = fileDir + "communesCantonsPays.txt";
        fileMonnaies = fileDir + "monnaies.txt";
        fileActifsSiegeOuLocalises = fileDir + "actifsSiegeOuLocalises.txt";
        fileActifsMobiles = fileDir + "actifsMobiles.txt";
        fileCapitalDotation = fileDir + "capitalDotation.txt";
        fileSelonTotalOuAppreciation = fileDir + "selonTotalOuAppreciation.txt";
        fileModelConfigThisYear = fileDir + "modelConfig.txt";
        fileModelConfigYearBefore = fileDir + "modelConfigBefore.txt";
        fileBaremeImpotBenefice = fileDir + "baremeImpotBenefice.txt";
        fileBaremeImpotCapital = fileDir + "baremeImpotCapital.txt";
    }
}

