/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.engine.validators;

import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.Map;

public class ValeurFiscaleSelonCapitalisation
implements Validator {
    private Reference valeurLocative;
    private Reference tauxCapitalisation;
    private LogicModelItem thisItem;

    public ValeurFiscaleSelonCapitalisation(Reference valeurLocative, Reference tauxCapitalisation) {
        this.valeurLocative = valeurLocative;
        this.tauxCapitalisation = tauxCapitalisation;
    }

    public void initializeReferences(Map logicModel, LogicModelItem logicModelItem) throws InvalidModelException {
        this.valeurLocative.registerListenerOnReference(logicModel, logicModelItem, false);
        this.tauxCapitalisation.registerListenerOnReference(logicModel, logicModelItem, false);
        this.thisItem = logicModelItem;
    }

    public ModelItemDTO validate(LogicModelItem.ProtectedMap dataModel, String dataModelKey, ModelItemDTO modelItemDTO) {
        ModelItemDTO valeurLocativeDTO;
        if (EngineUtil.removeTableIndices(dataModelKey).equals(this.thisItem.getName())) {
            // empty if block
        }
        if ((valeurLocativeDTO = dataModel.get(EngineUtil.mergeModelKey(this.valeurLocative.getName(), dataModelKey))) == null || !(valeurLocativeDTO.getValue() instanceof Number)) {
            return modelItemDTO.clone(null);
        }
        ModelItemDTO tauxCapitalisationDTO = dataModel.get(EngineUtil.mergeModelKey(this.tauxCapitalisation.getName(), dataModelKey));
        if (tauxCapitalisationDTO == null || !(tauxCapitalisationDTO.getValue() instanceof Number)) {
            return modelItemDTO.clone(null);
        }
        long result = 0L;
        if (((Number)tauxCapitalisationDTO.getValue()).longValue() != 0L) {
            result = ((Number)valeurLocativeDTO.getValue()).longValue() / ((Number)tauxCapitalisationDTO.getValue()).longValue() * 100L;
        }
        if (dataModel.allowActiveValidations()) {
            modelItemDTO = modelItemDTO.clone(new Long(result));
        } else {
            long manualValue = 0L;
            if (modelItemDTO.getValue() != null && modelItemDTO.getValue() instanceof Number) {
                manualValue = ((Number)modelItemDTO.getValue()).longValue();
            }
            if (manualValue != result) {
                modelItemDTO = modelItemDTO.clone(2, "warning.valeur.fiscal.capitalisation.manual", null, 2);
            }
        }
        return modelItemDTO;
    }
}

