/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.engine.validators;

import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ExtractColumnFromOtherTable
implements Validator {
    Reference destinationTable;
    Reference sourceTable;
    Reference indexItem;
    Reference sourceItem;

    public ExtractColumnFromOtherTable(Reference destinationTable, Reference sourceTable, Reference indexItem, Reference sourceItem) {
        this.destinationTable = destinationTable;
        this.sourceTable = sourceTable;
        this.indexItem = indexItem;
        this.sourceItem = sourceItem;
    }

    public void initializeReferences(Map logicModel, LogicModelItem logicModelItem) throws InvalidModelException {
        this.destinationTable.registerListenerOnReference(logicModel, logicModelItem, true);
        this.sourceTable.registerListenerOnReference(logicModel, logicModelItem, true);
        this.indexItem.registerListenerOnReference(logicModel, logicModelItem, true);
        this.sourceItem.registerListenerOnReference(logicModel, logicModelItem, true);
    }

    public ModelItemDTO validate(LogicModelItem.ProtectedMap dataModel, String dataModelKey, ModelItemDTO modelItemDTO) {
        Set sourceTableIndices;
        long result = 0L;
        String destTableDMK = EngineUtil.mergeModelKey(this.destinationTable.getName(), dataModelKey);
        String destTableEntryIndex = EngineUtil.getLastKeyPart(destTableDMK);
        String sourceTableDMK = EngineUtil.mergeModelKey(this.sourceTable.getName(), dataModelKey);
        ModelItemDTO sourceTableDTO = dataModel.get(sourceTableDMK);
        Set set = sourceTableIndices = sourceTableDTO != null ? (Set)sourceTableDTO.getValue() : null;
        if (sourceTableIndices != null) {
            Iterator i = sourceTableIndices.iterator();
            while (i.hasNext()) {
                Object value;
                ModelItemDTO sourceDTO;
                String index = i.next().toString();
                String dmk = EngineUtil.mergeModelKey(this.indexItem.getName(), sourceTableDMK + "." + index);
                ModelItemDTO indexDTO = dataModel.get(dmk);
                if (indexDTO == null || !destTableEntryIndex.equals(indexDTO.getValue()) || (sourceDTO = dataModel.get(dmk = EngineUtil.mergeModelKey(this.sourceItem.getName(), sourceTableDMK + "." + index))) == null || !((value = sourceDTO.getValue()) instanceof Number)) continue;
                result += ((Number)value).longValue();
            }
        }
        return modelItemDTO.clone(new Long(result));
    }
}

