/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.engine.validators;

import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CopyValueFromFormWithComboSelection
implements Validator {
    Reference formTable;
    Reference comboItem;
    Reference selectionItem;
    Reference sourceItem;

    public CopyValueFromFormWithComboSelection(Reference formTable, Reference comboItem, Reference selectionItem, Reference sourceItem) {
        this.formTable = formTable;
        this.comboItem = comboItem;
        this.selectionItem = selectionItem;
        this.sourceItem = sourceItem;
    }

    public void initializeReferences(Map logicModel, LogicModelItem logicModelItem) throws InvalidModelException {
        this.formTable.registerListenerOnReference(logicModel, logicModelItem, false);
        this.comboItem.registerListenerOnReference(logicModel, logicModelItem, true);
        this.selectionItem.registerListenerOnReference(logicModel, logicModelItem, false);
        this.sourceItem.registerListenerOnReference(logicModel, logicModelItem, true);
    }

    public ModelItemDTO validate(LogicModelItem.ProtectedMap dataModel, String dataModelKey, ModelItemDTO modelItemDTO) {
        Set formTableIndices;
        ModelItemDTO result = null;
        String formTableDMK = EngineUtil.mergeModelKey(this.formTable.getName(), dataModelKey);
        ModelItemDTO formTableDTO = dataModel.get(formTableDMK);
        Set set = formTableIndices = formTableDTO != null ? (Set)formTableDTO.getValue() : null;
        if (formTableIndices != null) {
            Iterator i = formTableIndices.iterator();
            while (i.hasNext()) {
                String selectionItemDMK;
                ModelItemDTO selectionItemDTO;
                String formTableEntryDMK = formTableDMK + "." + i.next();
                String comboItemDMK = EngineUtil.mergeModelKey(this.comboItem.getName(), formTableEntryDMK);
                ModelItemDTO comboItemDTO = dataModel.get(comboItemDMK);
                if (comboItemDTO == null || comboItemDTO.getValue() == null || (selectionItemDTO = dataModel.get(selectionItemDMK = EngineUtil.mergeModelKey(this.selectionItem.getName(), dataModelKey))) == null || selectionItemDTO.getValue() == null || !comboItemDTO.getValue().equals(selectionItemDTO.getValue())) continue;
                String sourceItemDMK = EngineUtil.mergeModelKey(this.sourceItem.getName(), formTableEntryDMK);
                result = dataModel.get(sourceItemDMK);
            }
        }
        return result != null ? result : new ModelItemDTO(null);
    }
}

