/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.engine.validators;

import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ChoixCommunesRepartitionIntercommunaleValidator
implements Validator {
    private Reference formTable;
    private Reference communeA;
    private Reference communeB;
    private Reference communeC;
    private Reference communeD;
    private Reference communeE;
    LogicModelItem thisItem;

    public ChoixCommunesRepartitionIntercommunaleValidator(Reference formTable, Reference communeA, Reference communeB, Reference communeC, Reference communeD, Reference communeE) {
        this.formTable = formTable;
        this.communeA = communeA;
        this.communeB = communeB;
        this.communeC = communeC;
        this.communeD = communeD;
        this.communeE = communeE;
    }

    public void initializeReferences(Map logicModel, LogicModelItem logicModelItem) throws InvalidModelException {
        this.thisItem = logicModelItem;
        if (this.communeA == null) {
            throw new InvalidModelException(this.getClass().getName() + ": reference must not be null");
        }
        this.communeA.registerListenerOnReference(logicModel, logicModelItem, true);
        if (this.communeB == null) {
            throw new InvalidModelException(this.getClass().getName() + ": reference must not be null");
        }
        this.communeB.registerListenerOnReference(logicModel, logicModelItem, true);
        if (this.communeC == null) {
            throw new InvalidModelException(this.getClass().getName() + ": reference must not be null");
        }
        this.communeC.registerListenerOnReference(logicModel, logicModelItem, true);
        if (this.communeD == null) {
            throw new InvalidModelException(this.getClass().getName() + ": reference must not be null");
        }
        this.communeD.registerListenerOnReference(logicModel, logicModelItem, true);
        if (this.communeE == null) {
            throw new InvalidModelException(this.getClass().getName() + ": reference must not be null");
        }
        this.communeE.registerListenerOnReference(logicModel, logicModelItem, true);
    }

    public ModelItemDTO validate(LogicModelItem.ProtectedMap dataModel, String dataModelKey, ModelItemDTO modelItemDTO) {
        Long curentValueKanton = (Long)modelItemDTO.getValue();
        ModelItemDTO result = modelItemDTO;
        ModelItemDTO miDTO = dataModel.get(this.formTable.getName());
        if (miDTO == null || miDTO.getValue() == null) {
            return result;
        }
        Set annexeJSet = (Set)miDTO.getValue();
        String annexeJKey = null;
        String annexeJKeyMin = null;
        String keyCommuneA = null;
        Long valueCommuneA = null;
        String keyCommuneB = null;
        Long valueCommuneB = null;
        String keyCommuneC = null;
        Long valueCommuneC = null;
        String keyCommuneD = null;
        Long valueCommuneD = null;
        String keyCommuneE = null;
        Long valueCommuneE = null;
        Iterator i = annexeJSet.iterator();
        while (i.hasNext()) {
            annexeJKey = i.next().toString();
            if (annexeJKeyMin == null || Long.parseLong(annexeJKey) < Long.parseLong(annexeJKeyMin)) {
                annexeJKeyMin = annexeJKey;
            }
            if (curentValueKanton == null) continue;
            keyCommuneA = EngineUtil.mergeModelKey(this.communeA.getName(), this.formTable.getName() + "." + annexeJKey);
            ModelItemDTO kantonA_DTO = dataModel.get(keyCommuneA);
            Long l = valueCommuneA = kantonA_DTO != null ? (Long)kantonA_DTO.getValue() : null;
            if (valueCommuneA != null && !keyCommuneA.equals(dataModelKey) && valueCommuneA.equals(curentValueKanton)) {
                result = result.clone(4, "error.AnnexeK.AK.doubleInsertionCommune", null, 4);
                return result;
            }
            keyCommuneB = EngineUtil.mergeModelKey(this.communeB.getName(), this.formTable.getName() + "." + annexeJKey);
            ModelItemDTO kantonB_DTO = dataModel.get(keyCommuneB);
            Long l2 = valueCommuneB = kantonB_DTO != null ? (Long)kantonB_DTO.getValue() : null;
            if (valueCommuneB != null && !keyCommuneB.equals(dataModelKey) && valueCommuneB.equals(curentValueKanton)) {
                result = result.clone(4, "error.AnnexeK.AK.doubleInsertionCommune", null, 4);
                return result;
            }
            keyCommuneC = EngineUtil.mergeModelKey(this.communeC.getName(), this.formTable.getName() + "." + annexeJKey);
            ModelItemDTO kantonC_DTO = dataModel.get(keyCommuneC);
            Long l3 = valueCommuneC = kantonC_DTO != null ? (Long)kantonC_DTO.getValue() : null;
            if (valueCommuneC != null && !keyCommuneC.equals(dataModelKey) && valueCommuneC.equals(curentValueKanton)) {
                result = result.clone(4, "error.AnnexeK.AK.doubleInsertionCommune", null, 4);
                return result;
            }
            keyCommuneD = EngineUtil.mergeModelKey(this.communeD.getName(), this.formTable.getName() + "." + annexeJKey);
            ModelItemDTO kantonD_DTO = dataModel.get(keyCommuneD);
            Long l4 = valueCommuneD = kantonD_DTO != null ? (Long)kantonD_DTO.getValue() : null;
            if (valueCommuneD != null && !keyCommuneD.equals(dataModelKey) && valueCommuneD.equals(curentValueKanton)) {
                result = result.clone(4, "error.AnnexeK.AK.doubleInsertionCommune", null, 4);
                return result;
            }
            keyCommuneE = EngineUtil.mergeModelKey(this.communeE.getName(), this.formTable.getName() + "." + annexeJKey);
            ModelItemDTO kantonE_DTO = dataModel.get(keyCommuneE);
            valueCommuneE = kantonE_DTO != null ? (Long)kantonE_DTO.getValue() : null;
            if (valueCommuneE == null || keyCommuneE.equals(dataModelKey) || !valueCommuneE.equals(curentValueKanton)) continue;
            result = result.clone(4, "error.AnnexeK.AK.doubleInsertionCommune", null, 4);
            return result;
        }
        return result;
    }
}

