/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.engine.modelitems;

import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class TableEntryItemSummarizer
extends LogicModelItem
implements LogicModelItem.TableItem.TableEventListener {
    private Reference tableWithTheItems;
    private Reference[] theItems;
    private Map mapWithTheItems = new HashMap();

    public TableEntryItemSummarizer(String name, String pKey, Reference tableWithTheItems, Reference[] theItems) {
        super(name, null, pKey, true, "false", true);
        this.tableWithTheItems = tableWithTheItems;
        this.theItems = theItems;
    }

    protected void additionalInitializeReferences(Map logicModel) throws InvalidModelException {
        super.additionalInitializeReferences(logicModel);
        this.tableWithTheItems.initializeReference(logicModel, this, false);
        ((LogicModelItem.TableItem)((Object)this.tableWithTheItems.getReference())).addTableEventListener(this);
        for (int i = 0; i < this.theItems.length; ++i) {
            this.theItems[i].registerListenerOnReference(logicModel, this, false);
            this.mapWithTheItems.put(this.theItems[i].getName(), this.theItems[i]);
        }
    }

    public void onTableEntryAdd(LogicModelItem source, LogicModelItem.ProtectedMap dataModel, String tableDMK, String index) {
        Map.Entry me;
        HashMap newItems = new HashMap();
        Iterator<Object> i = dataModel.entrySet().iterator();
        while (i.hasNext()) {
            me = (Map.Entry)i.next();
            String dmk = me.getKey().toString();
            if (!this.getName().equals(EngineUtil.removeTableIndices(dmk))) continue;
            String newDMK = this.replaceTableEntryIndex(dmk, tableDMK, index);
            newItems.put(newDMK, me.getValue());
        }
        i = newItems.entrySet().iterator();
        while (i.hasNext()) {
            me = (Map.Entry)i.next();
            super.setValue(dataModel, me.getKey().toString(), (ModelItemDTO)me.getValue(), null);
        }
    }

    public void onTableEntryRemove(LogicModelItem source, LogicModelItem.ProtectedMap dataModel, String tableDMK, String index) {
    }

    public void setValue(LogicModelItem.ProtectedMap dataModel, String dataModelKey, ModelItemDTO modelItemDTO, String changedEventsOnlyOutsideOfThisTable) {
    }

    public void dataChanged(LogicModelItem.ProtectedMap dataModel, String dataModelKey, ModelItemDTO oldValue, ModelItemDTO newValue, String changedEventsOnlyOutsideOfThisTable) {
        if (newValue == null && oldValue == null) {
            return;
        }
        String tableDMK = EngineUtil.mergeModelKey(this.tableWithTheItems.getName(), dataModelKey);
        tableDMK = EngineUtil.removeLastKeyPart(tableDMK);
        Set tableIndices = (Set)dataModel.get(tableDMK).getValue();
        Iterator i = tableIndices.iterator();
        while (i.hasNext()) {
            ModelItemDTO result;
            boolean isLong;
            String index = i.next().toString();
            String summandDMK = this.replaceTableEntryIndex(dataModelKey, tableDMK, index);
            String summeDMK = EngineUtil.mergeModelKey(this.getName(), summandDMK);
            if (changedEventsOnlyOutsideOfThisTable != null && summeDMK.startsWith(changedEventsOnlyOutsideOfThisTable)) continue;
            ModelItemDTO summeDTO = dataModel.get(summeDMK);
            Number value = summeDTO != null ? (Number)((Number)summeDTO.getValue()) : (Number)null;
            boolean bl = isLong = !(value != null && !(value instanceof Long) || oldValue != null && !(oldValue.getValue() instanceof Long) || newValue != null && !(newValue.getValue() instanceof Long));
            if (isLong) {
                long l = 0L;
                if (value instanceof Long) {
                    l = (Long)value;
                }
                if (oldValue != null && oldValue.getValue() instanceof Long) {
                    l -= ((Long)oldValue.getValue()).longValue();
                }
                if (newValue != null && newValue.getValue() instanceof Long) {
                    l += ((Long)newValue.getValue()).longValue();
                }
                result = new ModelItemDTO(new Long(l));
            } else {
                double d = 0.0;
                if (value instanceof Number) {
                    d = value.doubleValue();
                }
                if (oldValue != null && oldValue.getValue() instanceof Long) {
                    d -= ((Number)oldValue.getValue()).doubleValue();
                }
                if (newValue != null && newValue.getValue() instanceof Long) {
                    d += ((Number)newValue.getValue()).doubleValue();
                }
                result = new ModelItemDTO(new Double(d));
            }
            super.setValue(dataModel, summeDMK, result, changedEventsOnlyOutsideOfThisTable);
        }
    }

    private String replaceTableEntryIndex(String dataModelKey, String tableDMK, String index) {
        String subDMK = dataModelKey.substring(tableDMK.length() + 1);
        subDMK = subDMK.substring(subDMK.indexOf(46));
        return tableDMK + "." + index + subDMK;
    }
}

