/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.engine.expertdisplay;

import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.Barcode2DGenerator;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModel;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.util.ZipHelper;
import ch.dvbern.tax.ge.pm.engine.expertdisplay.BarcodeHelper;
import ch.dvbern.tax.ge.pm.engine.expertdisplay.BarcodeItem;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;

public class GeBarcodeGenerator
implements Barcode2DGenerator {
    private static final String ENCODING = "ISO-8859-15";
    private Random random = new Random();
    private Map result = null;

    public byte[] generateId(ExpertDisplayModel.RequestContext req) {
        byte[] id = new byte[4];
        id[0] = 3;
        id[1] = 1;
        byte[] rand = new byte[2];
        this.random.nextBytes(rand);
        id[2] = rand[0];
        id[3] = rand[1];
        return id;
    }

    public byte getContentType() {
        return 0;
    }

    public byte[] generateData(ExpertDisplayModel.RequestContext requestContext) {
        ExpertDisplayModel.ProtectedMap dataModel = requestContext.getDataModel();
        Map logicModel = requestContext.getLogicModelItems();
        this.result = new HashMap();
        Iterator iter = dataModel.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            String dmk = (String)entry.getKey();
            ModelItemDTO modelItemDTO = (ModelItemDTO)entry.getValue();
            LogicModelItem logicModelItem = (LogicModelItem)logicModel.get(EngineUtil.removeTableIndices(dmk));
            if (logicModelItem == null) continue;
            List pkts = logicModelItem.getPersistenceKeyTemplates();
            BarcodeItem item = null;
            Long index = null;
            Iterator iterator = pkts.iterator();
            while (iterator.hasNext()) {
                boolean isWarning;
                String persistenceKey = (String)iterator.next();
                String key = (String)entry.getKey();
                Object value = ((ModelItemDTO)entry.getValue()).getValue();
                persistenceKey = EngineUtil.convertPersistenceKey(persistenceKey, dmk);
                StringTokenizer tokenizer2 = new StringTokenizer(persistenceKey, ";");
                String isToWrite = tokenizer2.nextToken();
                String formular = tokenizer2.nextToken();
                String code = tokenizer2.nextToken();
                String format = tokenizer2.nextToken();
                boolean bIsToWrite = true;
                boolean bl = isWarning = modelItemDTO.getState() == 2;
                if (tokenizer2.hasMoreTokens()) {
                    String next = tokenizer2.nextToken();
                    if (next.length() == 10) {
                        String poidsFort = next.substring(0, 5);
                        String poidsFaible = next.substring(5);
                        next = poidsFaible + poidsFort;
                    }
                    index = Long.valueOf(next);
                }
                if (modelItemDTO == null || modelItemDTO.getValue() == null || value == null || value == null || value.equals("0")) continue;
                item = new BarcodeItem(formular, code, format, value, key, index, isWarning, bIsToWrite);
                this.addToResult(item);
            }
        }
        try {
            byte[] data = this.generateBarcodeContent(dataModel, this.result);
            return data;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void addToResult(BarcodeItem item) {
        StringBuffer buf = new StringBuffer(item.getFormular() + ";" + item.getCode());
        if (item.getIndex() != null) {
            buf.append(";" + item.getIndex().toString());
        }
        this.result.put(buf.toString(), item);
    }

    private byte[] generateBarcodeContent(ExpertDisplayModel.ProtectedMap dataModel, Map result) throws IOException {
        ModelItemDTO selection_af;
        String anneeTaxation = "2008";
        String name = "";
        String addr = "";
        String zip = "";
        String city = "";
        ModelItemDTO selection_sa = dataModel.get("Selection.SA");
        String noContribuable = null;
        if (selection_sa != null && selection_sa.getValue() != null && ((Boolean)selection_sa.getValue()).booleanValue()) {
            ModelItemDTO raisonSociale = dataModel.get("Declaration.Form1.RaisonSociale");
            ModelItemDTO adresse = dataModel.get("Declaration.Form1.Adresse");
            ModelItemDTO cp = dataModel.get("Declaration.Form1.CP");
            ModelItemDTO ville = dataModel.get("Declaration.Form1.Ville");
            if (raisonSociale != null && raisonSociale.getValue() != null) {
                name = dataModel.get("Declaration.Form1.RaisonSociale").getValue().toString();
            }
            if (adresse != null && adresse.getValue() != null) {
                addr = dataModel.get("Declaration.Form1.Adresse").getValue().toString();
            }
            if (dataModel.get("Declaration.Form1.RaisonSoc") != null && cp != null && cp.getValue() != null) {
                zip = dataModel.get("Declaration.Form1.CP").getValue().toString();
            }
            if (ville != null && ville.getValue() != null) {
                city = dataModel.get("Declaration.Form1.Ville").getValue().toString();
            }
            noContribuable = dataModel.get("Declaration.Form1.NumeroContribuableBareCode").getValue().toString();
        }
        if ((selection_af = dataModel.get("Selection.AF")) != null && selection_af.getValue() != null && ((Boolean)selection_af.getValue()).booleanValue()) {
            ModelItemDTO raisonSociale = dataModel.get("Declaration_af.Form1_af.RaisonSociale");
            ModelItemDTO adresse = dataModel.get("Declaration_af.Form1_af.Adresse");
            ModelItemDTO cp = dataModel.get("Declaration_af.Form1_af.CP");
            ModelItemDTO ville = dataModel.get("Declaration_af.Form1_af.Ville");
            if (raisonSociale != null && raisonSociale.getValue() != null) {
                name = dataModel.get("Declaration_af.Form1_af.RaisonSociale").getValue().toString();
            }
            if (adresse != null && adresse.getValue() != null) {
                addr = dataModel.get("Declaration_af.Form1_af.Adresse").getValue().toString();
            }
            if (dataModel.get("Declaration_af.Form1_af.RaisonSoc") != null && cp != null && cp.getValue() != null) {
                zip = dataModel.get("Declaration_af.Form1_af.CP").getValue().toString();
            }
            if (ville != null && ville.getValue() != null) {
                city = dataModel.get("Declaration_af.Form1_af.Ville").getValue().toString();
            }
            noContribuable = dataModel.get("Declaration_af.Form1_af.NumeroContribuableBareCode").getValue().toString();
        }
        name = BarcodeItem.encode(name);
        addr = BarcodeItem.encode(addr);
        zip = BarcodeItem.encode(zip);
        city = BarcodeItem.encode(city);
        String content = BarcodeHelper.generate(result, anneeTaxation, name, addr, zip, city, noContribuable, selection_sa, selection_af);
        System.out.println("BARCODE");
        System.out.println(content);
        byte[] data = content.getBytes(ENCODING);
        String sDebugEnabled = TaxmeConfig.getString("DebugEnabled");
        if (sDebugEnabled != null && sDebugEnabled.equals("true")) {
            this.createAsciiFile(noContribuable, data);
        }
        return ZipHelper.zip(data, "TaxMe.xml");
    }

    private void createAsciiFile(String zpv, byte[] content) {
        try {
            System.out.println("generiere " + zpv + ".xml");
            FileOutputStream os = new FileOutputStream(zpv + ".xml");
            os.write(content);
            os.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private byte[] getIntToByteArray(int v) {
        byte[] b = new byte[4];
        int i = 0;
        int shift = 24;
        while (i < 4) {
            b[i] = (byte)(0xFF & v >> shift);
            ++i;
            shift -= 8;
        }
        return b;
    }
}

