/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.engine.expertdisplay;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.StringTokenizer;

public class BarcodeItem
implements Comparable {
    private String formular;
    private String code;
    private String format;
    private Object value;
    private String key;
    private boolean isWarning;
    private boolean isToWrite;
    private Long index;

    public BarcodeItem(String formular, String code, String format, Object val, String key, Long index, boolean isWarning, boolean isToWrite) {
        this.code = code;
        this.format = format;
        this.formular = formular;
        this.key = key;
        this.index = index;
        this.isWarning = isWarning;
        this.isToWrite = isToWrite;
        this.value = this.convertValue(val);
    }

    public BarcodeItem(String formular, String code, String format, Object val, String key, Long index) {
        this.code = code;
        this.format = format;
        this.formular = formular;
        this.value = this.convertValue(val);
        this.key = key;
        this.index = index;
        this.isWarning = false;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getFormular() {
        return this.formular;
    }

    public void setFormular(String formular) {
        this.formular = formular;
    }

    public String getValue() {
        return (String)this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isWarning() {
        return this.isWarning;
    }

    public boolean isToWrite() {
        return this.isToWrite;
    }

    private String convertValue(Object val) {
        if (this.getFormat().equals("A")) {
            return BarcodeItem.encode(val.toString());
        }
        if (this.getFormat().startsWith("F")) {
            int numberAfterComa = Integer.parseInt(this.getFormat().substring(1));
            StringBuffer buf = new StringBuffer("0.");
            for (int i = 0; i < numberAfterComa; ++i) {
                buf.append("0");
            }
            DecimalFormatSymbols symbol = new DecimalFormatSymbols();
            symbol.setDecimalSeparator('.');
            DecimalFormat df = new DecimalFormat(buf.toString(), symbol);
            return df.format(((Number)val).doubleValue());
        }
        if (this.getFormat().equals("N")) {
            return val.toString();
        }
        if (this.getFormat().equals("D")) {
            Date dateToDisplay = (Date)val;
            return new SimpleDateFormat("yyyyMMdd").format(dateToDisplay);
        }
        if (this.getFormat().equals("C")) {
            System.out.println("this.getCode() = " + this.getCode());
            if (this.getCode().equals("2.1.1_1")) {
                if (val instanceof Long) {
                    long longValue = (Long)val;
                    if (longValue == 1L) {
                        return "AS";
                    }
                    if (longValue == 2L) {
                        return "AL";
                    }
                    return BarcodeItem.encode(val.toString());
                }
                return "";
            }
            if (this.getCode().equals("2.1.2_1")) {
                if (val instanceof Long) {
                    long longValue = (Long)val;
                    if (longValue == 1L) {
                        return "A";
                    }
                    if (longValue == 2L) {
                        return "%";
                    }
                    if (longValue == 3L) {
                        return "S";
                    }
                    return BarcodeItem.encode(val.toString());
                }
                return "";
            }
            return "";
        }
        return BarcodeItem.encode(val.toString());
    }

    public String getCodeF() {
        StringTokenizer token;
        String code = this.getCode();
        if (code.indexOf("-") != -1) {
            token = new StringTokenizer(code, "-");
        } else if (code.indexOf("_") != -1) {
            token = new StringTokenizer(code, "_");
        } else if (code.indexOf("*") != -1) {
            token = new StringTokenizer(code, "*");
        } else {
            return code;
        }
        return token.nextToken();
    }

    public String getCodeC() {
        StringTokenizer token;
        String code = this.getCode();
        if (code.indexOf("-") != -1) {
            token = new StringTokenizer(code, "-");
        } else if (code.indexOf("_") != -1) {
            token = new StringTokenizer(code, "_");
        } else if (code.indexOf("*") != -1) {
            token = new StringTokenizer(code, "*");
        } else {
            return code;
        }
        token.nextToken();
        return token.nextToken();
    }

    public int compareTo(Object toCompare) {
        if (this.getIndex() != null && ((BarcodeItem)toCompare).getIndex() != null) {
            return this.getIndex().compareTo(((BarcodeItem)toCompare).getIndex());
        }
        return 0;
    }

    private Integer getSortableElement(BarcodeItem anItem) {
        char dot = '-';
        char score = '.';
        StringBuffer buffer = new StringBuffer();
        buffer.append(anItem.getFormular());
        buffer.append(anItem.getCode());
        for (int i = 0; i < buffer.length(); ++i) {
            if (buffer.charAt(i) != dot && buffer.charAt(i) != score) continue;
            buffer.deleteCharAt(i);
        }
        return Integer.valueOf(buffer.toString());
    }

    private int compareKeys(String thisKey, String toCompareKey) {
        StringTokenizer thisTokenizer = new StringTokenizer(thisKey, ".");
        StringTokenizer toCompareTokenizer = new StringTokenizer(toCompareKey, ".");
        while (thisTokenizer.hasMoreTokens() && toCompareTokenizer.hasMoreTokens()) {
            String toComparePart;
            String thisPart = thisTokenizer.nextToken();
            if (thisPart.equals(toComparePart = toCompareTokenizer.nextToken())) continue;
            Integer thisIndex = Integer.valueOf(thisPart);
            Integer toCompareIndex = Integer.valueOf(toComparePart);
            return thisIndex.compareTo(toCompareIndex);
        }
        return 0;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Long getIndex() {
        return this.index;
    }

    public void setIndex(Long index) {
        this.index = index;
    }

    public String getFormularDescription(String formularId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("3", "Annexe A");
        map.put("4", "Annexe B");
        map.put("5", "Annexe C");
        map.put("6", "Annexe D");
        map.put("7", "Annexe E");
        map.put("8", "Annexe F");
        map.put("9", "Annexe G");
        map.put("10", "Annexe H");
        map.put("11", "Annexe I");
        map.put("12", "Annexe J");
        map.put("13", "Annexe K");
        map.put("14", "Annexe L");
        map.put("15", "Annexe M");
        map.put("PG1", "Page de garde 1");
        map.put("PG2", "Page de garde 2");
        map.put("PG3", "Page de garde 3");
        map.put("PG4", "Page de garde 4");
        return (String)map.get(formularId);
    }

    public static String encode(String parm) {
        StringBuffer buffer = new StringBuffer(parm);
        int index = 0;
        for (int i = 0; i < buffer.length(); ++i) {
            if (buffer.toString().indexOf("&", index) == -1) continue;
            buffer.replace(buffer.toString().indexOf("&", index), buffer.toString().indexOf("&", index) + 1, "&amp;");
            index = buffer.toString().indexOf("&", index) + 1;
        }
        while (buffer.toString().indexOf("'") != -1) {
            buffer.replace(buffer.toString().indexOf("'"), buffer.toString().indexOf("'") + 1, "&apos;");
            index = buffer.toString().indexOf("'") + 1;
        }
        while (buffer.toString().indexOf("<") != -1) {
            buffer.replace(buffer.toString().indexOf("<"), buffer.toString().indexOf("<") + 1, "&lt;");
            index = buffer.toString().indexOf("<") + 1;
        }
        while (buffer.toString().indexOf(">") != -1) {
            buffer.replace(buffer.toString().indexOf(">"), buffer.toString().indexOf(">") + 1, "&gt;");
            index = buffer.toString().indexOf(">") + 1;
        }
        while (buffer.toString().indexOf("\"") != -1) {
            buffer.replace(buffer.toString().indexOf("\""), buffer.toString().indexOf("\"") + 1, "&quot;");
            index = buffer.toString().indexOf("\"") + 1;
        }
        return buffer.toString();
    }

    public String toString() {
        return this.code + " " + this.format + " " + this.formular + " " + this.index + " " + this.isToWrite + " " + this.isWarning + " " + this.key + " " + this.value;
    }
}

