/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.engine.expertdisplay;

import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.ge.pm.engine.expertdisplay.BarcodeItem;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;

class BarcodeHelper {
    private static Map barcodeModel = null;
    protected static final char SPACE = ' ';
    protected static final String CRLF = "\r\n";
    protected static final String QUOTE = "\"";
    protected static final String XML_VERSION = "<?xml version=\"1.0\" encoding=\"ISO-8859-15\" ?>";
    protected static final String BEGIN_DOC = "<doc>";
    protected static final String END_DOC = "</doc>";
    protected static final String INTERFACE_HEADER = "ii";
    protected static final String INTERFACE_DEF = "id";
    protected static final String BEGIN_FORMULAR_HEADER = "<fh id=";
    protected static final String END_FORMULAR_HEADER = "</fh>";
    protected static final String FORMULAR_DESC = "desc=";
    protected static final String BEGIN_FORMULAR_DATA = "<fd>";
    protected static final String END_FORMULAR_DATA = "</fd>";
    protected static final String BEGIN_TABLE = "<tb>";
    protected static final String END_TABLE = "</tb>";
    protected static final String BEGIN_TABLE_ROW = "<td>";
    protected static final String END_TABLE_ROW = "</td>";
    protected static final String BEGIN_TAG = "<";
    protected static final String END_TAG = "/>";
    protected static final String END_LINE_TAG = ">";
    protected static final String BEGIN_FILE_ID = "<file ";
    protected static final String END_FILE_ID = "</file> ";
    protected static final String PERIOD = "period=";
    protected static final String DATE_NOW = "date=";
    protected static final String PROVIDER = "provider=";
    protected static final String VERSION = "version=";
    protected static final String NAME = "name=";
    protected static final String ADDRESS = "addr=";
    protected static final String ZIP = "zip=";
    protected static final String CITY = "city=";
    protected static final String NO_CONTRIBUABLE = "sno=";
    protected static final String TYPE_APP = "type=";
    protected static final String TYPE_APP_SA = "SA";
    protected static final String TYPE_APP_AF = "AF";
    protected static final String BEGIN_FIELD = "<dr f=";
    protected static final String CODE = "c=";
    protected static final String TYPE = "t=";
    protected static final String VALUE = "v=";
    protected static final String MODIFIED = "m=";
    protected static final String TAX_DATA_BEGIN = "<tax no=";
    protected static final String TAX_DATA_END = "</tax>";

    private BarcodeHelper() {
    }

    public static String generate(Map result, String anneeTaxation, String name, String addr, String zip, String city, String noContribuable, ModelItemDTO selection_sa, ModelItemDTO selection_af) throws IOException {
        String now = new SimpleDateFormat("yyyyMMdd").format(new Date());
        String provider = "GeTaxPM";
        String version = TaxmeConfig.getApplicationVersion();
        StringBuffer buf = new StringBuffer();
        buf.append(BarcodeHelper.generateBeginDoc());
        buf.append(BarcodeHelper.generateBeginFile(anneeTaxation, now, provider, version));
        barcodeModel = result;
        File barcodeFormular = null;
        if (selection_sa != null && selection_sa.getValue() != null && ((Boolean)selection_sa.getValue()).booleanValue()) {
            buf.append(BarcodeHelper.generateTaxInformation(noContribuable, city, name, addr, zip, TYPE_APP_SA));
            barcodeFormular = new File("config/cd/resources/barcode.txt");
        } else if (selection_af != null && selection_af.getValue() != null && ((Boolean)selection_af.getValue()).booleanValue()) {
            buf.append(BarcodeHelper.generateTaxInformation(noContribuable, city, name, addr, zip, TYPE_APP_AF));
            barcodeFormular = new File("config/cd/resources/barcode_af.txt");
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(new BufferedInputStream(new FileInputStream(barcodeFormular))));
        String line = reader.readLine();
        boolean overread = false;
        while (line != null) {
            if (!line.startsWith("#")) {
                BarcodeItem item;
                if (line.startsWith("<Form")) {
                    StringTokenizer sk = new StringTokenizer(line, ";");
                    sk.nextToken();
                    String formId = sk.nextToken();
                    String formName = sk.nextToken();
                    buf.append(BarcodeHelper.generateBeginFormular(formId, formName));
                } else if (line.equals("</Form>")) {
                    buf.append(BarcodeHelper.generateEndFormular());
                } else if (line.equals("<tr-1>")) {
                    BarcodeHelper.generateTable(buf, reader);
                } else if (line.startsWith("12") || line.startsWith("13")) {
                    if (line.indexOf("-") != -1) {
                        ArrayList allItemsForId = new ArrayList();
                        StringTokenizer token = new StringTokenizer(line, "-");
                        String id = token.nextToken();
                        int maxNumberOfInput = Integer.parseInt(token.nextToken());
                        for (int i = 0; i < maxNumberOfInput; ++i) {
                            allItemsForId.addAll(BarcodeHelper.getAllItemsForId(id + "-" + (i + 1)));
                        }
                        Collections.sort(allItemsForId);
                        if (line.endsWith("3.1.5.0-0")) {
                            BarcodeItem item2 = (BarcodeItem)barcodeModel.get(line);
                            if (item2 != null) {
                                buf.append(BarcodeHelper.generateField(item2));
                            }
                        } else {
                            Iterator iter = allItemsForId.iterator();
                            while (iter.hasNext()) {
                                BarcodeItem item3 = (BarcodeItem)iter.next();
                                buf.append(BarcodeHelper.generateFieldAnnexeJK(item3));
                            }
                        }
                    } else if (line.indexOf("*") != -1 && (item = (BarcodeItem)barcodeModel.get(line)) != null) {
                        buf.append(BarcodeHelper.generateField(item));
                    }
                } else if (line.startsWith("10")) {
                    if (!overread && line.indexOf("-") != -1) {
                        buf.append(BarcodeHelper.generateAnnexeH());
                        overread = true;
                    }
                } else if (line.startsWith("table")) {
                    StringTokenizer tokenizer = new StringTokenizer(line, ":");
                    tokenizer.nextToken();
                    String idTableDefinition = tokenizer.nextToken();
                    StringTokenizer token = new StringTokenizer(idTableDefinition, "_");
                    String id = token.nextToken();
                    int maxNumberOfInput = Integer.parseInt(token.nextToken());
                    ArrayList allItemsForIdDefinition = new ArrayList();
                    for (int i = -1; i < maxNumberOfInput; ++i) {
                        List items = BarcodeHelper.getAllItemsForIdTableDefinitition(id + "_" + (i + 1));
                        if (items.isEmpty()) continue;
                        allItemsForIdDefinition.addAll(items);
                    }
                    Collections.sort(allItemsForIdDefinition);
                    ArrayList<String> ids = new ArrayList<String>();
                    String lineInTable = reader.readLine();
                    String endTable = "</table>";
                    while (!lineInTable.equals(endTable)) {
                        ids.add(lineInTable);
                        lineInTable = reader.readLine();
                    }
                    Map barcodeTableItems = BarcodeHelper.getSortedTableItemsForIdsAnnexeJ(ids);
                    if (!allItemsForIdDefinition.isEmpty()) {
                        buf.append(BarcodeHelper.generateTableBegin());
                        int numberOfLine = allItemsForIdDefinition.size() / (maxNumberOfInput + 1);
                        if (allItemsForIdDefinition.size() % (maxNumberOfInput + 1) > 0) {
                            ++numberOfLine;
                        }
                        for (int i = 0; i < numberOfLine; ++i) {
                            buf.append(BarcodeHelper.generateTableLineBegin());
                            BarcodeHelper.generateDefinition(i, maxNumberOfInput + 1, allItemsForIdDefinition, buf);
                            if (!barcodeTableItems.isEmpty()) {
                                BarcodeHelper.generateEntries(i, barcodeTableItems, buf);
                            }
                            buf.append(BarcodeHelper.generateTableLineEnd());
                        }
                        buf.append(BarcodeHelper.generateTableEnd());
                    }
                } else {
                    item = (BarcodeItem)barcodeModel.get(line);
                    if (item != null) {
                        buf.append(BarcodeHelper.generateField(item));
                    }
                }
            }
            line = reader.readLine();
        }
        reader.close();
        buf.append(BarcodeHelper.generateEndDoc());
        return buf.toString();
    }

    private static Map getAllAnnexeHItems() {
        TreeMap allAnnexeH = new TreeMap(new Comparator(){

            public int compare(Object arg0, Object arg1) {
                return ((String)arg0).compareTo((String)arg1);
            }
        });
        Iterator keys = barcodeModel.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (!key.startsWith("10;")) continue;
            BarcodeItem item = (BarcodeItem)barcodeModel.get(key);
            String mapKey = item.getIndex() + ";" + item.getCodeC();
            if (!allAnnexeH.containsKey(mapKey)) {
                allAnnexeH.put(mapKey, new TreeSet(new Comparator(){

                    public int compare(Object arg0, Object arg1) {
                        BarcodeItem item0 = (BarcodeItem)arg0;
                        BarcodeItem item1 = (BarcodeItem)arg1;
                        return item0.getCode().compareTo(item1.getCode());
                    }
                }));
            }
            Set listForKey = (Set)allAnnexeH.get(mapKey);
            listForKey.add(item);
        }
        return allAnnexeH;
    }

    private static String generateAnnexeH() {
        StringBuffer buf = new StringBuffer();
        Map allAnnexeH = BarcodeHelper.getAllAnnexeHItems();
        buf.append(BarcodeHelper.generateTableBegin());
        Iterator iterator = allAnnexeH.keySet().iterator();
        while (iterator.hasNext()) {
            String mapKey = (String)iterator.next();
            Set barcodeItems = (Set)allAnnexeH.get(mapKey);
            buf.append(BarcodeHelper.generateTableLineBegin());
            Iterator iterator2 = barcodeItems.iterator();
            while (iterator2.hasNext()) {
                BarcodeItem barcodeItem = (BarcodeItem)iterator2.next();
                barcodeItem.setCode(barcodeItem.getCodeF() + "-0");
                buf.append(BarcodeHelper.generateFieldAnnexeH(barcodeItem));
            }
            buf.append(BarcodeHelper.generateTableLineEnd());
        }
        buf.append(BarcodeHelper.generateTableEnd());
        return buf.toString();
    }

    private static Map getSortedTableItemsForIdsAnnexeJ(List ids) {
        String id;
        ArrayList toReturn = new ArrayList();
        HashMap<Integer, List> map = new HashMap<Integer, List>();
        Iterator iter = ids.iterator();
        while (iter.hasNext()) {
            id = (String)iter.next();
            toReturn.addAll(BarcodeHelper.getAllItemsForId(id));
        }
        for (int i = 0; i == ids.size(); ++i) {
            id = (String)ids.get(i - 1);
            map.put(new Integer(i + 1), BarcodeHelper.getAllItemsForId(id));
        }
        int index = -1;
        long currentIndex = -1L;
        Collections.sort(toReturn);
        ArrayList<BarcodeItem> line = null;
        Iterator iter2 = toReturn.iterator();
        while (iter2.hasNext()) {
            BarcodeItem item = (BarcodeItem)iter2.next();
            if (item.getIndex() / 100000L != currentIndex) {
                currentIndex = item.getIndex() / 100000L;
                if (line != null) {
                    map.put(new Integer(++index), line);
                }
                line = new ArrayList<BarcodeItem>();
            }
            line.add(item);
        }
        if (line != null) {
            map.put(new Integer(++index), line);
        }
        return map;
    }

    private static Map getSortedTableItemsForIds(List ids) {
        String id;
        ArrayList toReturn = new ArrayList();
        HashMap<Integer, List> map = new HashMap<Integer, List>();
        Iterator iter = ids.iterator();
        while (iter.hasNext()) {
            id = (String)iter.next();
            toReturn.addAll(BarcodeHelper.getAllItemsForId(id));
        }
        for (int i = 0; i == ids.size(); ++i) {
            id = (String)ids.get(i - 1);
            map.put(new Integer(i + 1), BarcodeHelper.getAllItemsForId(id));
        }
        int index = -1;
        int currentIndex = -1;
        Collections.sort(toReturn);
        ArrayList<BarcodeItem> line = null;
        Iterator iter2 = toReturn.iterator();
        while (iter2.hasNext()) {
            BarcodeItem item = (BarcodeItem)iter2.next();
            if (item.getIndex().intValue() != currentIndex) {
                currentIndex = item.getIndex().intValue();
                if (line != null) {
                    map.put(new Integer(++index), line);
                }
                line = new ArrayList<BarcodeItem>();
            }
            line.add(item);
        }
        if (line != null) {
            map.put(new Integer(++index), line);
        }
        return map;
    }

    private static List getAllItemsForId(String id) {
        ArrayList items = new ArrayList();
        Iterator keys = barcodeModel.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (!key.startsWith(id)) continue;
            items.add(barcodeModel.get(key));
        }
        return items;
    }

    private static List getAllItemsForIdTableDefinitition(String id) {
        ArrayList items = new ArrayList();
        Iterator keys = barcodeModel.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            System.out.println("Key = " + key);
            StringTokenizer token = new StringTokenizer(key, ";");
            token.nextToken();
            if (!key.startsWith(id) || !token.hasMoreTokens()) continue;
            token.nextToken();
            String index = token.nextToken();
            if (!index.endsWith("90000")) continue;
            items.add(barcodeModel.get(key));
        }
        return items;
    }

    public static String generateBeginDoc() {
        StringBuffer buf = new StringBuffer();
        buf.append(XML_VERSION);
        buf.append(CRLF);
        return buf.toString();
    }

    public static String generateBeginFile(String period, String date, String provider, String version) {
        StringBuffer buf = new StringBuffer();
        buf.append(BEGIN_DOC);
        buf.append(CRLF);
        buf.append(BEGIN_TAG);
        buf.append(INTERFACE_HEADER);
        buf.append(' ');
        buf.append(PERIOD);
        buf.append(QUOTE + period + QUOTE);
        buf.append(' ');
        buf.append(DATE_NOW);
        buf.append(QUOTE + date + QUOTE);
        buf.append(' ');
        buf.append(PROVIDER);
        buf.append(QUOTE + provider + QUOTE);
        buf.append(' ');
        buf.append(VERSION);
        buf.append(QUOTE + version + QUOTE);
        buf.append(END_TAG);
        buf.append(CRLF);
        return buf.toString();
    }

    public static String generateTaxInformation(String noContribuable, String city, String name, String addr, String zip, String typeApp) {
        StringBuffer buf = new StringBuffer();
        buf.append(BEGIN_TAG);
        buf.append(INTERFACE_DEF);
        buf.append(' ');
        buf.append("type=\"" + typeApp + QUOTE + ' ');
        buf.append(NAME);
        buf.append(QUOTE + name + QUOTE + ' ');
        buf.append(ADDRESS);
        buf.append(QUOTE + addr + QUOTE + ' ');
        buf.append(ZIP);
        buf.append(QUOTE + zip + QUOTE + ' ');
        buf.append(CITY);
        buf.append(QUOTE + city + QUOTE + ' ');
        buf.append(NO_CONTRIBUABLE);
        buf.append(QUOTE + noContribuable + QUOTE);
        buf.append(END_TAG);
        buf.append(CRLF);
        return buf.toString();
    }

    public static String generateEndDoc() {
        StringBuffer buf = new StringBuffer();
        buf.append(END_DOC);
        return buf.toString();
    }

    private static String generateBeginFormular(String formularId, String formularDesc) {
        StringBuffer buf = new StringBuffer();
        buf.append(BEGIN_FORMULAR_HEADER);
        buf.append(QUOTE + formularId + QUOTE + ' ');
        buf.append(FORMULAR_DESC);
        buf.append(QUOTE + formularDesc + QUOTE);
        buf.append(END_LINE_TAG);
        buf.append(CRLF);
        buf.append(BEGIN_FORMULAR_DATA);
        buf.append(CRLF);
        return buf.toString();
    }

    private static String generateEndFormular() {
        StringBuffer buf = new StringBuffer();
        buf.append(END_FORMULAR_DATA);
        buf.append(CRLF);
        buf.append(END_FORMULAR_HEADER);
        buf.append(CRLF);
        return buf.toString();
    }

    private static String generateTableBegin() {
        StringBuffer buf = new StringBuffer();
        buf.append(BEGIN_TABLE);
        buf.append(CRLF);
        return buf.toString();
    }

    private static String generateTableEnd() {
        StringBuffer buf = new StringBuffer();
        buf.append(END_TABLE);
        buf.append(CRLF);
        return buf.toString();
    }

    private static String generateTableLineBegin() {
        StringBuffer buf = new StringBuffer();
        buf.append(BEGIN_TABLE_ROW);
        buf.append(CRLF);
        return buf.toString();
    }

    private static String generateTableLineEnd() {
        StringBuffer buf = new StringBuffer();
        buf.append(END_TABLE_ROW);
        buf.append(CRLF);
        return buf.toString();
    }

    private static String generateField(BarcodeItem item) {
        StringBuffer buf = new StringBuffer();
        String modified = null;
        if (item.isToWrite()) {
            buf.append(BEGIN_FIELD);
            buf.append(QUOTE + item.getCodeF() + QUOTE);
            buf.append(' ');
            buf.append(CODE);
            buf.append(QUOTE + item.getCodeC() + QUOTE);
            buf.append(' ');
            buf.append(MODIFIED);
            modified = item.isWarning() ? "1" : "0";
            buf.append(QUOTE + modified + QUOTE);
            buf.append(' ');
            buf.append(VALUE);
            buf.append(QUOTE + item.getValue() + QUOTE);
            buf.append(END_TAG);
            buf.append(CRLF);
        }
        return buf.toString();
    }

    private static String generateFieldAnnexeH(BarcodeItem item) {
        int codeC = Integer.parseInt(item.getCodeC());
        StringBuffer buf = new StringBuffer();
        String modified = null;
        if (item.isToWrite()) {
            buf.append(BEGIN_FIELD);
            buf.append(QUOTE + item.getCodeF() + QUOTE);
            buf.append(' ');
            buf.append(CODE);
            buf.append(QUOTE + codeC + QUOTE);
            buf.append(' ');
            buf.append(MODIFIED);
            modified = item.isWarning() ? "1" : "0";
            buf.append(QUOTE + modified + QUOTE);
            buf.append(' ');
            buf.append(VALUE);
            buf.append(QUOTE + item.getValue() + QUOTE);
            buf.append(END_TAG);
            buf.append(CRLF);
        }
        return buf.toString();
    }

    private static String generateFieldAnnexeJK(BarcodeItem item) {
        String indexStr = String.valueOf(item.getIndex());
        int codeC = Integer.parseInt(item.getCodeC());
        int length = indexStr.length();
        int indexCanton = Integer.parseInt(indexStr.substring(length - 1, length)) * 5;
        codeC += indexCanton;
        StringBuffer buf = new StringBuffer();
        String modified = null;
        if (item.isToWrite()) {
            buf.append(BEGIN_FIELD);
            buf.append(QUOTE + item.getCodeF() + QUOTE);
            buf.append(' ');
            buf.append(CODE);
            buf.append(QUOTE + codeC + QUOTE);
            buf.append(' ');
            buf.append(MODIFIED);
            modified = item.isWarning() ? "1" : "0";
            buf.append(QUOTE + modified + QUOTE);
            buf.append(' ');
            buf.append(VALUE);
            buf.append(QUOTE + item.getValue() + QUOTE);
            buf.append(END_TAG);
            buf.append(CRLF);
        }
        return buf.toString();
    }

    private static void generateTable(StringBuffer buf, BufferedReader reader) throws IOException {
        ArrayList<String> ids = new ArrayList<String>();
        String lineInTable = reader.readLine();
        while (!lineInTable.equals("</tr-1>")) {
            ids.add(lineInTable);
            lineInTable = reader.readLine();
        }
        Map barcodeTableItems = BarcodeHelper.getSortedTableItemsForIds(ids);
        if (!barcodeTableItems.isEmpty()) {
            buf.append(BarcodeHelper.generateTableBegin());
            int numberOfLine = barcodeTableItems.keySet().size();
            for (int j = 0; j < numberOfLine; ++j) {
                buf.append(BarcodeHelper.generateTableLineBegin());
                List itemsForThisLine = (List)barcodeTableItems.get(new Integer(j));
                Iterator iter = itemsForThisLine.iterator();
                while (iter.hasNext()) {
                    BarcodeItem item = (BarcodeItem)iter.next();
                    buf.append(BarcodeHelper.generateField(item));
                }
                buf.append(BarcodeHelper.generateTableLineEnd());
            }
            buf.append(BarcodeHelper.generateTableEnd());
        }
    }

    private static void generateEntries(int indexLine, Map barcodeTableItems, StringBuffer buf) {
        List itemsForThisLine = (List)barcodeTableItems.get(new Integer(indexLine));
        Iterator iter = itemsForThisLine.iterator();
        while (iter.hasNext()) {
            BarcodeItem item = (BarcodeItem)iter.next();
            buf.append(BarcodeHelper.generateFieldAnnexeJK(item));
        }
    }

    private static void generateDefinition(int indexLine, int maxNumberOfInput, List allItemsForIdDefinition, StringBuffer buf) {
        for (int i = 0; i < maxNumberOfInput; ++i) {
            int index = indexLine * maxNumberOfInput + i;
            if (allItemsForIdDefinition.size() <= index) continue;
            BarcodeItem item = (BarcodeItem)allItemsForIdDefinition.get(index);
            buf.append(BarcodeHelper.generateFieldAnnexeJK(item));
        }
    }
}

