/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.engine.calcitems;

import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.DataResource;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.transfer.dto.BaremeImpotDTO;
import java.util.Iterator;
import java.util.Map;

public class CFBaremeImpot
implements CalcItem {
    private DataResource dataResource;

    public CFBaremeImpot(DataResource dataResource) {
        this.dataResource = dataResource;
    }

    public void evaluate(LogicModelItem.ProtectedMap model, FastStack stack, String dataModelKey) {
        double montant = 0.0;
        Object montantObj = stack.pop();
        if (montantObj != null && montantObj instanceof Number) {
            montant = ((Number)montantObj).doubleValue();
        }
        String filename = stack.pop().toString();
        double impot = this.getImpotPourMontant(montant, filename);
        stack.push(new Double(impot));
    }

    private double getImpotPourMontant(double montant, String filename) {
        double totalImpot = 0.0;
        Map baremes = this.dataResource.get(filename, null, null);
        BaremeImpotDTO hauptTranche = null;
        BaremeImpotDTO restTranche = null;
        Iterator iter = baremes.values().iterator();
        while (iter.hasNext()) {
            BaremeImpotDTO tranche = (BaremeImpotDTO)iter.next();
            if (tranche.getEndTranche() > montant) {
                restTranche = tranche;
                break;
            }
            hauptTranche = tranche;
            restTranche = tranche;
        }
        double anteilRestTranche = montant - restTranche.getStartTranche();
        if (hauptTranche != null) {
            totalImpot = hauptTranche.getImpot();
        }
        if (anteilRestTranche > 0.0) {
            totalImpot += anteilRestTranche * restTranche.getTaux();
        }
        return totalImpot;
    }
}

