/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Dimension;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.peer.ScrollbarPeer;
import sun.awt.windows.WComponentPeer;
import sun.awt.windows.WToolkit;

class WScrollbarPeer
extends WComponentPeer
implements ScrollbarPeer {
    private boolean dragInProgress = false;

    void initialize() {
        Scrollbar scrollbar = (Scrollbar)this.target;
        this.setValues(scrollbar.getValue(), scrollbar.getVisibleAmount(), scrollbar.getMinimum(), scrollbar.getMaximum());
        super.initialize();
    }

    public boolean shouldClearRectBeforePaint() {
        return false;
    }

    void drag(int n2) {
        if (!this.dragInProgress) {
            this.dragInProgress = true;
        }
        this.postAdjustmentEvent(5, n2, true);
    }

    void dragEnd(int n2) {
        Scrollbar scrollbar = (Scrollbar)this.target;
        if (!this.dragInProgress) {
            return;
        }
        this.dragInProgress = false;
        WToolkit.executeOnEventHandlerThread(scrollbar, new Runnable(this, scrollbar, n2){
            private final Scrollbar val$sb;
            private final int val$value;
            private final WScrollbarPeer this$0;

            public void run() {
                this.val$sb.setValueIsAdjusting(false);
                this.this$0.postEvent(new AdjustmentEvent(this.val$sb, 601, 5, this.val$value, false));
            }
            {
                this.this$0 = wScrollbarPeer;
                this.val$sb = scrollbar;
                this.val$value = n2;
            }
        });
    }

    void lineDown(int n2) {
        this.postAdjustmentEvent(1, n2, false);
    }

    void lineUp(int n2) {
        this.postAdjustmentEvent(2, n2, false);
    }

    void pageDown(int n2) {
        this.postAdjustmentEvent(4, n2, false);
    }

    void pageUp(int n2) {
        this.postAdjustmentEvent(3, n2, false);
    }

    public native void setLineIncrement(int var1);

    public native void setPageIncrement(int var1);

    void warp(int n2) {
        this.postAdjustmentEvent(5, n2, false);
    }

    public native void setValues(int var1, int var2, int var3, int var4);

    private void postAdjustmentEvent(int n2, int n3, boolean bl2) {
        Scrollbar scrollbar = (Scrollbar)this.target;
        WToolkit.executeOnEventHandlerThread(scrollbar, new Runnable(this, scrollbar, bl2, n3, n2){
            private final Scrollbar val$sb;
            private final boolean val$isAdjusting;
            private final int val$value;
            private final int val$type;
            private final WScrollbarPeer this$0;

            public void run() {
                this.val$sb.setValueIsAdjusting(this.val$isAdjusting);
                this.val$sb.setValue(this.val$value);
                this.this$0.postEvent(new AdjustmentEvent(this.val$sb, 601, this.val$type, this.val$value, this.val$isAdjusting));
            }
            {
                this.this$0 = wScrollbarPeer;
                this.val$sb = scrollbar;
                this.val$isAdjusting = bl2;
                this.val$value = n2;
                this.val$type = n3;
            }
        });
    }

    public Dimension getMinimumSize() {
        if (((Scrollbar)this.target).getOrientation() == 1) {
            return new Dimension(15, 50);
        }
        return new Dimension(50, 15);
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    WScrollbarPeer(Scrollbar scrollbar) {
        super(scrollbar);
    }

    native void create(WComponentPeer var1);
}

