/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.tree;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;

public class TreePath
implements Serializable {
    private TreePath parentPath;
    private transient Object lastPathComponent;

    public int getPathCount() {
        int n2 = 0;
        TreePath treePath = this;
        while (treePath != null) {
            ++n2;
            treePath = treePath.parentPath;
        }
        return n2;
    }

    public int hashCode() {
        return this.lastPathComponent.hashCode();
    }

    protected TreePath() {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Vector vector = (Vector)objectInputStream.readObject();
        int n2 = 0;
        int n3 = vector.size();
        if (n2 < n3 && vector.elementAt(n2).equals("lastPathComponent")) {
            this.lastPathComponent = vector.elementAt(++n2);
            ++n2;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Vector vector = new Vector();
        boolean bl2 = true;
        if (this.lastPathComponent != null && this.lastPathComponent instanceof Serializable) {
            vector.addElement("lastPathComponent");
            vector.addElement(this.lastPathComponent);
        }
        objectOutputStream.writeObject(vector);
    }

    public Object getLastPathComponent() {
        return this.lastPathComponent;
    }

    public Object[] getPath() {
        int n2 = this.getPathCount();
        Object[] objectArray = new Object[n2--];
        TreePath treePath = this;
        while (treePath != null) {
            objectArray[n2--] = treePath.lastPathComponent;
            treePath = treePath.parentPath;
        }
        return objectArray;
    }

    public Object getPathComponent(int n2) {
        int n3 = this.getPathCount();
        if (n2 < 0 || n2 >= n3) {
            throw new IllegalArgumentException("Index " + n2 + " is out of the specified range");
        }
        TreePath treePath = this;
        for (int i2 = n3 - 1; i2 != n2; --i2) {
            treePath = treePath.parentPath;
        }
        return treePath.lastPathComponent;
    }

    public TreePath(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("path in TreePath must be non null.");
        }
        this.lastPathComponent = object;
        this.parentPath = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof TreePath) {
            TreePath treePath = (TreePath)object;
            if (this.getPathCount() != treePath.getPathCount()) {
                return false;
            }
            TreePath treePath2 = this;
            while (treePath2 != null) {
                if (!treePath2.lastPathComponent.equals(treePath.lastPathComponent)) {
                    return false;
                }
                treePath = treePath.parentPath;
                treePath2 = treePath2.parentPath;
            }
            return true;
        }
        return false;
    }

    public TreePath(Object[] objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            throw new IllegalArgumentException("path in TreePath must be non null and not empty.");
        }
        this.lastPathComponent = objectArray[objectArray.length - 1];
        if (objectArray.length > 1) {
            this.parentPath = new TreePath(objectArray, objectArray.length - 1);
        }
    }

    protected TreePath(Object[] objectArray, int n2) {
        this.lastPathComponent = objectArray[n2 - 1];
        if (n2 > 1) {
            this.parentPath = new TreePath(objectArray, n2 - 1);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[");
        int n2 = this.getPathCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.getPathComponent(i2));
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public TreePath getParentPath() {
        return this.parentPath;
    }

    public boolean isDescendant(TreePath treePath) {
        if (treePath == this) {
            return true;
        }
        if (treePath != null) {
            int n2 = this.getPathCount();
            int n3 = treePath.getPathCount();
            if (n3 < n2) {
                return false;
            }
            while (n3-- > n2) {
                treePath = treePath.getParentPath();
            }
            return this.equals(treePath);
        }
        return false;
    }

    protected TreePath(TreePath treePath, Object object) {
        if (object == null) {
            throw new IllegalArgumentException("path in TreePath must be non null.");
        }
        this.parentPath = treePath;
        this.lastPathComponent = object;
    }

    public TreePath pathByAddingChild(Object object) {
        if (object == null) {
            throw new NullPointerException("Null child not allowed");
        }
        return new TreePath(this, object);
    }
}

