/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Vector;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.spi.AudioFileReader;
import javax.sound.sampled.spi.AudioFileWriter;
import javax.sound.sampled.spi.FormatConversionProvider;
import javax.sound.sampled.spi.MixerProvider;

public class AudioSystem {
    public static final int NOT_SPECIFIED = -1;
    private static final String defaultServicesClassName = "com.sun.media.sound.DefaultServices";
    private static final String jdk13ServicesClassName = "com.sun.media.sound.JDK13Services";
    private static final String servicesMethodName = "getProviders";
    private static final Class[] servicesParamTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = AudioSystem.class$("java.lang.String")) : class$java$lang$String};
    private static final boolean DEBUG = false;
    static Class class$java$lang$String;

    private AudioSystem() {
    }

    private static Vector getMixerProviders() {
        Vector vector = null;
        try {
            Class.forName("sun.misc.Service");
            vector = AudioSystem.getJDK13Services("javax.sound.sampled.spi.MixerProvider");
        }
        catch (Exception exception) {
            vector = AudioSystem.getDefaultServices("javax.sound.sampled.spi.MixerProvider");
        }
        return vector;
    }

    public static AudioFileFormat.Type[] getAudioFileTypes() {
        int n2;
        AudioFileWriter[] audioFileWriterArray = AudioSystem.getAudioFileWriters();
        AudioFileFormat.Type[][] typeArrayArray = new AudioFileFormat.Type[audioFileWriterArray.length][];
        AudioFileFormat.Type[] typeArray = null;
        int n3 = 0;
        int n4 = 0;
        for (n2 = 0; n2 < audioFileWriterArray.length; ++n2) {
            typeArrayArray[n2] = audioFileWriterArray[n2].getAudioFileTypes();
            n3 += typeArrayArray[n2].length;
        }
        typeArray = new AudioFileFormat.Type[n3];
        for (n2 = 0; n2 < audioFileWriterArray.length; ++n2) {
            for (int i2 = 0; i2 < typeArrayArray[n2].length; ++i2) {
                typeArray[n4] = typeArrayArray[n2][i2];
                ++n4;
            }
        }
        return typeArray;
    }

    public static boolean isFileTypeSupported(AudioFileFormat.Type type) {
        AudioFileWriter[] audioFileWriterArray = AudioSystem.getAudioFileWriters();
        boolean bl2 = false;
        for (int i2 = 0; i2 < audioFileWriterArray.length; ++i2) {
            bl2 = audioFileWriterArray[i2].isFileTypeSupported(type);
            if (!bl2) continue;
            return bl2;
        }
        return bl2;
    }

    public static boolean isLineSupported(Line.Info info) {
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        for (int i2 = 0; i2 < infoArray.length; ++i2) {
            Mixer mixer;
            if (infoArray[i2] == null || !(mixer = AudioSystem.getMixer(infoArray[i2])).isLineSupported(info)) continue;
            return true;
        }
        return false;
    }

    public static Mixer.Info[] getMixerInfo() {
        int n2;
        Vector vector = AudioSystem.getMixerProviders();
        Vector vector2 = new Vector();
        for (n2 = vector.size() - 1; n2 >= 0; --n2) {
            Mixer.Info[] infoArray = ((MixerProvider)vector.elementAt(n2)).getMixerInfo();
            for (int i2 = 0; i2 < infoArray.length; ++i2) {
                vector2.addElement(infoArray[i2]);
            }
        }
        Mixer.Info[] infoArray = new Mixer.Info[vector2.size()];
        for (n2 = 0; n2 < infoArray.length; ++n2) {
            infoArray[n2] = (Mixer.Info)vector2.elementAt(n2);
        }
        return infoArray;
    }

    private static AudioFileReader[] getAudioFileReaders() {
        Vector vector = new Vector();
        try {
            Class.forName("sun.misc.Service");
            vector = AudioSystem.getJDK13Services("javax.sound.sampled.spi.AudioFileReader");
        }
        catch (Exception exception) {
            vector = AudioSystem.getDefaultServices("javax.sound.sampled.spi.AudioFileReader");
        }
        AudioFileReader[] audioFileReaderArray = new AudioFileReader[vector.size()];
        for (int i2 = 0; i2 < audioFileReaderArray.length; ++i2) {
            audioFileReaderArray[i2] = (AudioFileReader)vector.elementAt(i2);
        }
        return audioFileReaderArray;
    }

    private static AudioFileWriter[] getAudioFileWriters() {
        Vector vector = new Vector();
        try {
            Class.forName("sun.misc.Service");
            vector = AudioSystem.getJDK13Services("javax.sound.sampled.spi.AudioFileWriter");
        }
        catch (Exception exception) {
            vector = AudioSystem.getDefaultServices("javax.sound.sampled.spi.AudioFileWriter");
        }
        AudioFileWriter[] audioFileWriterArray = new AudioFileWriter[vector.size()];
        for (int i2 = 0; i2 < audioFileWriterArray.length; ++i2) {
            audioFileWriterArray[i2] = (AudioFileWriter)vector.elementAt(i2);
        }
        return audioFileWriterArray;
    }

    private static FormatConversionProvider[] getFormatConversionProviders() {
        Vector vector = new Vector();
        try {
            Class.forName("sun.misc.Service");
            vector = AudioSystem.getJDK13Services("javax.sound.sampled.spi.FormatConversionProvider");
        }
        catch (Exception exception) {
            vector = AudioSystem.getDefaultServices("javax.sound.sampled.spi.FormatConversionProvider");
        }
        FormatConversionProvider[] formatConversionProviderArray = new FormatConversionProvider[vector.size()];
        for (int i2 = 0; i2 < formatConversionProviderArray.length; ++i2) {
            formatConversionProviderArray[i2] = (FormatConversionProvider)vector.elementAt(i2);
        }
        return formatConversionProviderArray;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private static Vector getDefaultServices(String string) {
        Vector vector = null;
        try {
            Class clazz = Class.forName(defaultServicesClassName);
            Method method = clazz.getMethod(servicesMethodName, servicesParamTypes);
            Object[] objectArray = new Object[]{string};
            vector = (Vector)method.invoke(clazz, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            vector = new Vector();
        }
        catch (ClassNotFoundException classNotFoundException) {
            vector = new Vector();
        }
        catch (IllegalAccessException illegalAccessException) {
            vector = new Vector();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            vector = new Vector();
        }
        return vector;
    }

    private static Vector getJDK13Services(String string) {
        Vector vector = null;
        try {
            Class clazz = Class.forName(jdk13ServicesClassName);
            Method method = clazz.getMethod(servicesMethodName, servicesParamTypes);
            Object[] objectArray = new Object[]{string};
            vector = (Vector)method.invoke(clazz, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            vector = new Vector();
        }
        catch (ClassNotFoundException classNotFoundException) {
            vector = new Vector();
        }
        catch (IllegalAccessException illegalAccessException) {
            vector = new Vector();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            vector = new Vector();
        }
        return vector;
    }

    public static AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        AudioFileReader[] audioFileReaderArray = AudioSystem.getAudioFileReaders();
        AudioFileFormat audioFileFormat = null;
        for (int i2 = audioFileReaderArray.length - 1; i2 >= 0; --i2) {
            try {
                audioFileFormat = audioFileReaderArray[i2].getAudioFileFormat(file);
                break;
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                continue;
            }
        }
        if (audioFileFormat == null) {
            throw new UnsupportedAudioFileException("file is not a supported file type");
        }
        return audioFileFormat;
    }

    public static AudioFileFormat getAudioFileFormat(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        AudioFileReader[] audioFileReaderArray = AudioSystem.getAudioFileReaders();
        AudioFileFormat audioFileFormat = null;
        for (int i2 = audioFileReaderArray.length - 1; i2 >= 0; --i2) {
            try {
                audioFileFormat = audioFileReaderArray[i2].getAudioFileFormat(inputStream);
                break;
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                continue;
            }
        }
        if (audioFileFormat == null) {
            throw new UnsupportedAudioFileException("file is not a supported file type");
        }
        return audioFileFormat;
    }

    public static AudioFileFormat getAudioFileFormat(URL uRL) throws UnsupportedAudioFileException, IOException {
        AudioFileReader[] audioFileReaderArray = AudioSystem.getAudioFileReaders();
        AudioFileFormat audioFileFormat = null;
        for (int i2 = audioFileReaderArray.length - 1; i2 >= 0; --i2) {
            try {
                audioFileFormat = audioFileReaderArray[i2].getAudioFileFormat(uRL);
                break;
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                continue;
            }
        }
        if (audioFileFormat == null) {
            throw new UnsupportedAudioFileException("file is not a supported file type");
        }
        return audioFileFormat;
    }

    public static AudioFileFormat.Type[] getAudioFileTypes(AudioInputStream audioInputStream) {
        int n2;
        AudioFileWriter[] audioFileWriterArray = AudioSystem.getAudioFileWriters();
        AudioFileFormat.Type[][] typeArrayArray = new AudioFileFormat.Type[audioFileWriterArray.length][];
        AudioFileFormat.Type[] typeArray = null;
        int n3 = 0;
        int n4 = 0;
        for (n2 = 0; n2 < audioFileWriterArray.length; ++n2) {
            typeArrayArray[n2] = audioFileWriterArray[n2].getAudioFileTypes(audioInputStream);
            n3 += typeArrayArray[n2].length;
        }
        typeArray = new AudioFileFormat.Type[n3];
        for (n2 = 0; n2 < audioFileWriterArray.length; ++n2) {
            for (int i2 = 0; i2 < typeArrayArray[n2].length; ++i2) {
                typeArray[n4] = typeArrayArray[n2][i2];
                ++n4;
            }
        }
        return typeArray;
    }

    public static boolean isConversionSupported(AudioFormat audioFormat, AudioFormat audioFormat2) {
        FormatConversionProvider[] formatConversionProviderArray = AudioSystem.getFormatConversionProviders();
        for (int i2 = 0; i2 < formatConversionProviderArray.length; ++i2) {
            if (!formatConversionProviderArray[i2].isConversionSupported(audioFormat, audioFormat2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isConversionSupported(AudioFormat.Encoding encoding, AudioFormat audioFormat) {
        FormatConversionProvider[] formatConversionProviderArray = AudioSystem.getFormatConversionProviders();
        for (int i2 = 0; i2 < formatConversionProviderArray.length; ++i2) {
            if (!formatConversionProviderArray[i2].isConversionSupported(encoding, audioFormat)) continue;
            return true;
        }
        return false;
    }

    public static AudioFormat.Encoding[] getTargetEncodings(AudioFormat audioFormat) {
        FormatConversionProvider[] formatConversionProviderArray = AudioSystem.getFormatConversionProviders();
        Vector vector = new Vector();
        int n2 = 0;
        int n3 = 0;
        AudioFormat.Encoding[] encodingArray = null;
        for (int i2 = 0; i2 < formatConversionProviderArray.length; ++i2) {
            encodingArray = formatConversionProviderArray[i2].getTargetEncodings(audioFormat);
            n2 += encodingArray.length;
            vector.addElement(encodingArray);
        }
        AudioFormat.Encoding[] encodingArray2 = new AudioFormat.Encoding[n2];
        for (int i3 = 0; i3 < vector.size(); ++i3) {
            encodingArray = (AudioFormat.Encoding[])vector.elementAt(i3);
            for (int i4 = 0; i4 < encodingArray.length; ++i4) {
                encodingArray2[n3++] = encodingArray[i4];
            }
        }
        return encodingArray2;
    }

    public static AudioFormat.Encoding[] getTargetEncodings(AudioFormat.Encoding encoding) {
        FormatConversionProvider[] formatConversionProviderArray = AudioSystem.getFormatConversionProviders();
        Vector vector = new Vector();
        int n2 = 0;
        int n3 = 0;
        AudioFormat.Encoding[] encodingArray = null;
        for (int i2 = 0; i2 < formatConversionProviderArray.length; ++i2) {
            if (!formatConversionProviderArray[i2].isSourceEncodingSupported(encoding)) continue;
            encodingArray = formatConversionProviderArray[i2].getTargetEncodings();
            n2 += encodingArray.length;
            vector.addElement(encodingArray);
        }
        AudioFormat.Encoding[] encodingArray2 = new AudioFormat.Encoding[n2];
        for (int i3 = 0; i3 < vector.size(); ++i3) {
            encodingArray = (AudioFormat.Encoding[])vector.elementAt(i3);
            for (int i4 = 0; i4 < encodingArray.length; ++i4) {
                encodingArray2[n3++] = encodingArray[i4];
            }
        }
        return encodingArray2;
    }

    public static AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        AudioFileReader[] audioFileReaderArray = AudioSystem.getAudioFileReaders();
        AudioInputStream audioInputStream = null;
        for (int i2 = audioFileReaderArray.length - 1; i2 >= 0; --i2) {
            try {
                audioInputStream = audioFileReaderArray[i2].getAudioInputStream(file);
                break;
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                continue;
            }
        }
        if (audioInputStream == null) {
            throw new UnsupportedAudioFileException("could not get audio input stream from input file");
        }
        return audioInputStream;
    }

    public static AudioInputStream getAudioInputStream(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        AudioFileReader[] audioFileReaderArray = AudioSystem.getAudioFileReaders();
        AudioInputStream audioInputStream = null;
        for (int i2 = audioFileReaderArray.length - 1; i2 >= 0; --i2) {
            try {
                audioInputStream = audioFileReaderArray[i2].getAudioInputStream(inputStream);
                break;
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                continue;
            }
        }
        if (audioInputStream == null) {
            throw new UnsupportedAudioFileException("could not get audio input stream from input stream");
        }
        return audioInputStream;
    }

    public static AudioInputStream getAudioInputStream(URL uRL) throws UnsupportedAudioFileException, IOException {
        AudioFileReader[] audioFileReaderArray = AudioSystem.getAudioFileReaders();
        AudioInputStream audioInputStream = null;
        for (int i2 = audioFileReaderArray.length - 1; i2 >= 0; --i2) {
            try {
                audioInputStream = audioFileReaderArray[i2].getAudioInputStream(uRL);
                break;
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                continue;
            }
        }
        if (audioInputStream == null) {
            throw new UnsupportedAudioFileException("could not get audio input stream from input URL");
        }
        return audioInputStream;
    }

    public static boolean isFileTypeSupported(AudioFileFormat.Type type, AudioInputStream audioInputStream) {
        AudioFileWriter[] audioFileWriterArray = AudioSystem.getAudioFileWriters();
        boolean bl2 = false;
        for (int i2 = 0; i2 < audioFileWriterArray.length; ++i2) {
            bl2 = audioFileWriterArray[i2].isFileTypeSupported(type, audioInputStream);
            if (!bl2) continue;
            return bl2;
        }
        return bl2;
    }

    public static Line getLine(Line.Info info) throws LineUnavailableException {
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        LineUnavailableException lineUnavailableException = null;
        for (int i2 = 0; i2 < infoArray.length; ++i2) {
            Mixer mixer = AudioSystem.getMixer(infoArray[i2]);
            if (!mixer.isLineSupported(info)) continue;
            try {
                return mixer.getLine(info);
            }
            catch (LineUnavailableException lineUnavailableException2) {
                lineUnavailableException = lineUnavailableException2;
            }
        }
        if (lineUnavailableException != null) {
            throw lineUnavailableException;
        }
        throw new IllegalArgumentException("No line matching " + info.toString() + " is supported.");
    }

    public static Line.Info[] getSourceLineInfo(Line.Info info) {
        int n2;
        Vector vector = new Vector();
        Object var4_2 = null;
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        for (int i2 = 0; i2 < infoArray.length; ++i2) {
            Mixer mixer = AudioSystem.getMixer(infoArray[i2]);
            Line.Info[] infoArray2 = mixer.getSourceLineInfo(info);
            for (n2 = 0; n2 < infoArray2.length; ++n2) {
                vector.addElement(infoArray2[n2]);
            }
        }
        Line.Info[] infoArray3 = new Line.Info[vector.size()];
        for (n2 = 0; n2 < infoArray3.length; ++n2) {
            infoArray3[n2] = (Line.Info)vector.elementAt(n2);
        }
        return infoArray3;
    }

    public static Line.Info[] getTargetLineInfo(Line.Info info) {
        int n2;
        Vector vector = new Vector();
        Object var4_2 = null;
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        for (int i2 = 0; i2 < infoArray.length; ++i2) {
            Mixer mixer = AudioSystem.getMixer(infoArray[i2]);
            Line.Info[] infoArray2 = mixer.getTargetLineInfo(info);
            for (n2 = 0; n2 < infoArray2.length; ++n2) {
                vector.addElement(infoArray2[n2]);
            }
        }
        Line.Info[] infoArray3 = new Line.Info[vector.size()];
        for (n2 = 0; n2 < infoArray3.length; ++n2) {
            infoArray3[n2] = (Line.Info)vector.elementAt(n2);
        }
        return infoArray3;
    }

    public static Mixer getMixer(Mixer.Info info) {
        int n2;
        Object var1_1 = null;
        Vector vector = AudioSystem.getMixerProviders();
        for (n2 = vector.size() - 1; n2 >= 0; --n2) {
            try {
                return ((MixerProvider)vector.elementAt(n2)).getMixer(info);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        if (info == null) {
            for (n2 = vector.size() - 1; n2 >= 0; --n2) {
                try {
                    MixerProvider mixerProvider = (MixerProvider)vector.elementAt(n2);
                    Mixer.Info[] infoArray = mixerProvider.getMixerInfo();
                    for (int i2 = 0; i2 < infoArray.length; ++i2) {
                        try {
                            return mixerProvider.getMixer(infoArray[i2]);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            continue;
                        }
                    }
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
        throw new IllegalArgumentException("Mixer not supported: " + (info != null ? info.toString() : "null"));
    }

    public static int write(AudioInputStream audioInputStream, AudioFileFormat.Type type, File file) throws IOException {
        AudioFileWriter[] audioFileWriterArray = AudioSystem.getAudioFileWriters();
        int n2 = 0;
        boolean bl2 = false;
        for (int i2 = audioFileWriterArray.length - 1; i2 >= 0; --i2) {
            try {
                n2 = audioFileWriterArray[i2].write(audioInputStream, type, file);
                bl2 = true;
                break;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
        }
        if (!bl2) {
            throw new IllegalArgumentException("could not write audio file: file type not supported: " + type);
        }
        return n2;
    }

    public static int write(AudioInputStream audioInputStream, AudioFileFormat.Type type, OutputStream outputStream) throws IOException {
        AudioFileWriter[] audioFileWriterArray = AudioSystem.getAudioFileWriters();
        int n2 = 0;
        boolean bl2 = false;
        for (int i2 = audioFileWriterArray.length - 1; i2 >= 0; --i2) {
            try {
                n2 = audioFileWriterArray[i2].write(audioInputStream, type, outputStream);
                bl2 = true;
                break;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
        }
        if (!bl2) {
            throw new IllegalArgumentException("could not write audio file: file type not supported: " + type);
        }
        return n2;
    }

    public static AudioFormat[] getTargetFormats(AudioFormat.Encoding encoding, AudioFormat audioFormat) {
        FormatConversionProvider[] formatConversionProviderArray = AudioSystem.getFormatConversionProviders();
        Vector vector = new Vector();
        int n2 = 0;
        int n3 = 0;
        AudioFormat[] audioFormatArray = null;
        for (int i2 = 0; i2 < formatConversionProviderArray.length; ++i2) {
            audioFormatArray = formatConversionProviderArray[i2].getTargetFormats(encoding, audioFormat);
            n2 += audioFormatArray.length;
            vector.addElement(audioFormatArray);
        }
        AudioFormat[] audioFormatArray2 = new AudioFormat[n2];
        for (int i3 = 0; i3 < vector.size(); ++i3) {
            audioFormatArray = (AudioFormat[])vector.elementAt(i3);
            for (int i4 = 0; i4 < audioFormatArray.length; ++i4) {
                audioFormatArray2[n3++] = audioFormatArray[i4];
            }
        }
        return audioFormatArray2;
    }

    public static AudioInputStream getAudioInputStream(AudioFormat audioFormat, AudioInputStream audioInputStream) {
        if (audioInputStream.getFormat().matches(audioFormat)) {
            return audioInputStream;
        }
        FormatConversionProvider[] formatConversionProviderArray = AudioSystem.getFormatConversionProviders();
        for (int i2 = formatConversionProviderArray.length - 1; i2 >= 0; --i2) {
            if (!formatConversionProviderArray[i2].isConversionSupported(audioFormat, audioInputStream.getFormat())) continue;
            return formatConversionProviderArray[i2].getAudioInputStream(audioFormat, audioInputStream);
        }
        throw new IllegalArgumentException("Unsupported conversion: " + audioFormat + " from " + audioInputStream.getFormat());
    }

    public static AudioInputStream getAudioInputStream(AudioFormat.Encoding encoding, AudioInputStream audioInputStream) {
        FormatConversionProvider[] formatConversionProviderArray = AudioSystem.getFormatConversionProviders();
        for (int i2 = formatConversionProviderArray.length - 1; i2 >= 0; --i2) {
            if (!formatConversionProviderArray[i2].isConversionSupported(encoding, audioInputStream.getFormat())) continue;
            return formatConversionProviderArray[i2].getAudioInputStream(encoding, audioInputStream);
        }
        throw new IllegalArgumentException("Unsupported conversion: " + encoding + " from " + audioInputStream.getFormat());
    }
}

