/*
 * Decompiled with CFR 0.152.
 */
package javax.naming;

import com.sun.naming.internal.ResourceManager;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.spi.NamingManager;

public class InitialContext
implements Context {
    protected Hashtable myProps = null;
    protected Context defaultInitCtx = null;
    protected boolean gotDefault = false;

    public InitialContext() throws NamingException {
        this.init(null);
    }

    public void close() throws NamingException {
        this.myProps = null;
        if (this.defaultInitCtx != null) {
            this.defaultInitCtx.close();
            this.defaultInitCtx = null;
        }
        this.gotDefault = false;
    }

    protected InitialContext(boolean bl2) throws NamingException {
        if (!bl2) {
            this.init(null);
        }
    }

    public String getNameInNamespace() throws NamingException {
        return this.getDefaultInitCtx().getNameInNamespace();
    }

    public void destroySubcontext(String string) throws NamingException {
        this.getURLOrDefaultInitCtx(string).destroySubcontext(string);
    }

    public void unbind(String string) throws NamingException {
        this.getURLOrDefaultInitCtx(string).unbind(string);
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.getDefaultInitCtx().getEnvironment();
    }

    public InitialContext(Hashtable hashtable) throws NamingException {
        if (hashtable != null) {
            hashtable = (Hashtable)hashtable.clone();
        }
        this.init(hashtable);
    }

    protected void init(Hashtable hashtable) throws NamingException {
        this.myProps = ResourceManager.getInitialEnvironment(hashtable);
        if (this.myProps.get("java.naming.factory.initial") != null) {
            this.getDefaultInitCtx();
        }
    }

    protected Context getDefaultInitCtx() throws NamingException {
        if (!this.gotDefault) {
            this.defaultInitCtx = NamingManager.getInitialContext(this.myProps);
            this.gotDefault = true;
        }
        if (this.defaultInitCtx == null) {
            throw new NoInitialContextException();
        }
        return this.defaultInitCtx;
    }

    public void destroySubcontext(Name name) throws NamingException {
        this.getURLOrDefaultInitCtx(name).destroySubcontext(name);
    }

    public void unbind(Name name) throws NamingException {
        this.getURLOrDefaultInitCtx(name).unbind(name);
    }

    public Object lookup(String string) throws NamingException {
        return this.getURLOrDefaultInitCtx(string).lookup(string);
    }

    public Object lookupLink(String string) throws NamingException {
        return this.getURLOrDefaultInitCtx(string).lookupLink(string);
    }

    public Object removeFromEnvironment(String string) throws NamingException {
        this.myProps.remove(string);
        return this.getDefaultInitCtx().removeFromEnvironment(string);
    }

    public void bind(String string, Object object) throws NamingException {
        this.getURLOrDefaultInitCtx(string).bind(string, object);
    }

    public void rebind(String string, Object object) throws NamingException {
        this.getURLOrDefaultInitCtx(string).rebind(string, object);
    }

    public Object lookup(Name name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).lookup(name);
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).lookupLink(name);
    }

    public void bind(Name name, Object object) throws NamingException {
        this.getURLOrDefaultInitCtx(name).bind(name, object);
    }

    public void rebind(Name name, Object object) throws NamingException {
        this.getURLOrDefaultInitCtx(name).rebind(name, object);
    }

    private static String getURLScheme(String string) {
        int n2 = string.indexOf(58);
        int n3 = string.indexOf(47);
        if (n2 > 0 && (n3 == -1 || n2 < n3)) {
            return string.substring(0, n2);
        }
        return null;
    }

    public void rename(String string, String string2) throws NamingException {
        this.getURLOrDefaultInitCtx(string).rename(string, string2);
    }

    public Context createSubcontext(String string) throws NamingException {
        return this.getURLOrDefaultInitCtx(string).createSubcontext(string);
    }

    protected Context getURLOrDefaultInitCtx(String string) throws NamingException {
        Context context;
        if (NamingManager.hasInitialContextFactoryBuilder()) {
            return this.getDefaultInitCtx();
        }
        String string2 = InitialContext.getURLScheme(string);
        if (string2 != null && (context = NamingManager.getURLContext(string2, this.myProps)) != null) {
            return context;
        }
        return this.getDefaultInitCtx();
    }

    public Context createSubcontext(Name name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).createSubcontext(name);
    }

    protected Context getURLOrDefaultInitCtx(Name name) throws NamingException {
        Context context;
        String string;
        String string2;
        if (NamingManager.hasInitialContextFactoryBuilder()) {
            return this.getDefaultInitCtx();
        }
        if (name.size() > 0 && (string2 = InitialContext.getURLScheme(string = name.get(0))) != null && (context = NamingManager.getURLContext(string2, this.myProps)) != null) {
            return context;
        }
        return this.getDefaultInitCtx();
    }

    public void rename(Name name, Name name2) throws NamingException {
        this.getURLOrDefaultInitCtx(name).rename(name, name2);
    }

    public NameParser getNameParser(String string) throws NamingException {
        return this.getURLOrDefaultInitCtx(string).getNameParser(string);
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).getNameParser(name);
    }

    public NamingEnumeration list(String string) throws NamingException {
        return this.getURLOrDefaultInitCtx(string).list(string);
    }

    public NamingEnumeration listBindings(String string) throws NamingException {
        return this.getURLOrDefaultInitCtx(string).listBindings(string);
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).list(name);
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).listBindings(name);
    }

    public Object addToEnvironment(String string, Object object) throws NamingException {
        this.myProps.put(string, object);
        return this.getDefaultInitCtx().addToEnvironment(string, object);
    }

    public String composeName(String string, String string2) throws NamingException {
        return string;
    }

    public Name composeName(Name name, Name name2) throws NamingException {
        return (Name)name.clone();
    }
}

