/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.motif;

import com.sun.java.swing.plaf.motif.MotifGraphicsUtils;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuUI;

public class MotifMenuUI
extends BasicMenuUI {
    public void paint(Graphics graphics, JComponent jComponent) {
        MotifGraphicsUtils.paintMenuItem(graphics, jComponent, this.checkIcon, this.arrowIcon, this.selectionBackground, this.selectionForeground, this.defaultTextIconGap);
    }

    private boolean popupIsOpen(JMenu jMenu, MenuElement[] menuElementArray) {
        JPopupMenu jPopupMenu = jMenu.getPopupMenu();
        for (int i2 = menuElementArray.length - 1; i2 >= 0; --i2) {
            if (menuElementArray[i2].getComponent() != jPopupMenu) continue;
            return true;
        }
        return false;
    }

    protected ChangeListener createChangeListener(JComponent jComponent) {
        return new MotifChangeHandler(this, (JMenu)jComponent, this);
    }

    protected MouseInputListener createMouseInputListener(JComponent jComponent) {
        return new MouseInputHandler(this);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new MotifMenuUI();
    }

    public class MotifChangeHandler
    extends BasicMenuUI.ChangeHandler {
        private final MotifMenuUI this$0;

        public void stateChanged(ChangeEvent changeEvent) {
            JMenuItem jMenuItem = (JMenuItem)changeEvent.getSource();
            if (jMenuItem.isArmed() || jMenuItem.isSelected()) {
                jMenuItem.setBorderPainted(true);
            } else {
                jMenuItem.setBorderPainted(false);
            }
            super.stateChanged(changeEvent);
        }

        public MotifChangeHandler(MotifMenuUI motifMenuUI, JMenu jMenu, MotifMenuUI motifMenuUI2) {
            this.this$0 = motifMenuUI;
            super(motifMenuUI, jMenu, motifMenuUI2);
        }
    }

    protected class MouseInputHandler
    implements MouseInputListener {
        private final MotifMenuUI this$0;

        protected MouseInputHandler(MotifMenuUI motifMenuUI) {
            this.this$0 = motifMenuUI;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            JMenu jMenu = (JMenu)mouseEvent.getComponent();
            if (jMenu.isEnabled()) {
                MenuElement[] menuElementArray;
                Object object;
                if (jMenu.isTopLevelMenu()) {
                    if (jMenu.isSelected()) {
                        menuSelectionManager.clearSelectedPath();
                    } else {
                        object = jMenu.getParent();
                        if (object != null && object instanceof JMenuBar) {
                            menuElementArray = new MenuElement[]{(MenuElement)object, jMenu};
                            menuSelectionManager.setSelectedPath(menuElementArray);
                        }
                    }
                }
                if (((MenuElement[])(object = this.this$0.getPath())).length > 0) {
                    menuElementArray = new MenuElement[((MenuElement[])object).length + 1];
                    System.arraycopy(object, 0, menuElementArray, 0, ((MenuElement[])object).length);
                    menuElementArray[((MenuElement[])object).length] = jMenu.getPopupMenu();
                    menuSelectionManager.setSelectedPath(menuElementArray);
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            JMenuItem jMenuItem = (JMenuItem)mouseEvent.getComponent();
            Point point = mouseEvent.getPoint();
            if (point.x < 0 || point.x >= jMenuItem.getWidth() || point.y < 0 || point.y >= jMenuItem.getHeight()) {
                menuSelectionManager.processMouseEvent(mouseEvent);
            }
        }
    }
}

